/*
 * Decompiled with CFR 0.152.
 */
package plfx.keeper.model;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import plfx.keeper.model.MapDescriptor;

public class MapRegistry {
    private final File workPath;
    private final List<MapDescriptor> maps = new ArrayList<MapDescriptor>();

    public MapRegistry(File p) {
        this.workPath = p;
        for (File f : this.workPath.listFiles(pathname -> pathname.getName().endsWith(".properties"))) {
            MapDescriptor m = MapDescriptor.getInstance(f);
            if (m == null) continue;
            this.maps.add(m);
        }
    }

    public MapDescriptor getMap(double lat, double lon) {
        for (MapDescriptor m : this.maps) {
            if (m.getPointAbsolute(lat, lon) == null) continue;
            return m;
        }
        return null;
    }
}

