/*
 * Decompiled with CFR 0.152.
 */
package plfx.keeper.model;

import java.io.File;
import java.io.FileInputStream;
import java.util.Properties;

public class MapDescriptor {
    private final String name;
    private final File file;
    private final int width;
    private final int height;
    private final double deltaLat;
    private final double deltaLong;
    private final double minLat;
    private final double minLong;
    private final double maxLat;
    private final double maxLong;

    static synchronized MapDescriptor getInstance(File mapFile) {
        MapDescriptor inst = null;
        String id = mapFile.getName().replace(".properties", "");
        try {
            if (mapFile.exists()) {
                Properties prop = new Properties();
                prop.load(new FileInputStream(mapFile));
                String f = prop.getProperty("file");
                String w = prop.getProperty("width");
                String h = prop.getProperty("height");
                String p1x = prop.getProperty("point.1.x");
                String p1y = prop.getProperty("point.1.y");
                String p1lat = prop.getProperty("point.1.lat");
                String p1long = prop.getProperty("point.1.long");
                String p2x = prop.getProperty("point.2.x");
                String p2y = prop.getProperty("point.2.y");
                String p2lat = prop.getProperty("point.2.lat");
                String p2long = prop.getProperty("point.2.long");
                if (f == null) {
                    throw new NullPointerException("file");
                }
                if (w == null) {
                    throw new NullPointerException("width");
                }
                if (h == null) {
                    throw new NullPointerException("height");
                }
                if (p1x == null) {
                    throw new NullPointerException("point.1.x");
                }
                if (p1y == null) {
                    throw new NullPointerException("point.1.y");
                }
                if (p1lat == null) {
                    throw new NullPointerException("point.1.lat");
                }
                if (p1long == null) {
                    throw new NullPointerException("point.1.long");
                }
                if (p2x == null) {
                    throw new NullPointerException("point.2.x");
                }
                if (p2y == null) {
                    throw new NullPointerException("point.2.y");
                }
                if (p2lat == null) {
                    throw new NullPointerException("point.2.lat");
                }
                if (p2long == null) {
                    throw new NullPointerException("point.2.long");
                }
                File file = new File(mapFile.getParentFile(), f);
                int width = Integer.valueOf(w);
                int height = Integer.valueOf(h);
                int point1x = Integer.valueOf(p1x);
                int point1y = Integer.valueOf(p1y);
                int point2x = Integer.valueOf(p2x);
                int point2y = Integer.valueOf(p2y);
                double lat1 = Double.valueOf(p1lat);
                double long1 = Double.valueOf(p1long);
                double lat2 = Double.valueOf(p2lat);
                double long2 = Double.valueOf(p2long);
                inst = new MapDescriptor(id, file, width, height, point1x, point1y, point2x, point2y, lat1, long1, lat2, long2);
            }
        }
        catch (Exception ex) {
            System.out.println("Map " + id + " create error:" + ex.getMessage());
        }
        return inst;
    }

    private MapDescriptor(String name, File file, int width, int height, int point1x, int point1y, int point2x, int point2y, double lat1, double long1, double lat2, double long2) {
        this.name = name;
        this.file = file;
        this.width = width;
        this.height = height;
        int absLeft = Math.min(point1x, point2x);
        int absRight = Math.max(point1x, point2x);
        int absTop = Math.min(point1y, point2y);
        int absBottom = Math.max(point1y, point2y);
        double geoLeft = Math.min(long1, long2);
        double geoRight = Math.max(long1, long2);
        double geoTop = Math.max(lat1, lat2);
        double geoBottom = Math.min(lat1, lat2);
        this.deltaLat = (geoTop - geoBottom) / (double)(absBottom - absTop);
        this.deltaLong = (geoRight - geoLeft) / (double)(absRight - absLeft);
        this.maxLat = geoTop + this.deltaLat * (double)absTop;
        this.minLat = geoBottom - this.deltaLat * (double)(height - absBottom);
        this.maxLong = geoRight + this.deltaLong * (double)(width - absRight);
        this.minLong = geoLeft - this.deltaLong * (double)absLeft;
    }

    public String getName() {
        return this.name;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public File getImageFile() {
        return this.file;
    }

    public PointAbsolute getPointAbsolute(PointGeo geo) {
        return this.getPointAbsolute(geo.getLatitude(), geo.getLongitude());
    }

    public PointAbsolute getPointAbsolute(double latitude, double longitude) {
        PointAbsolute abs = null;
        if (latitude >= this.minLat && latitude <= this.maxLat && longitude >= this.minLong && longitude <= this.maxLong) {
            int x = (int)((longitude - this.minLong) * (double)this.width / (this.maxLong - this.minLong));
            int y = (int)((this.maxLat - latitude) * (double)this.height / (this.maxLat - this.minLat));
            abs = new PointAbsolute(x, y);
        }
        return abs;
    }

    public PointGeo getPointGeo(PointAbsolute abs) {
        return this.getPointGeo(abs.getX(), abs.getY());
    }

    public PointGeo getPointGeo(int x, int y) {
        PointGeo geo = null;
        if (x >= 0 && x < this.width && y >= 0 && y < this.height) {
            double latitude = this.maxLat - this.deltaLat * (double)y;
            double longitude = this.minLong + this.deltaLong * (double)x;
            geo = new PointGeo(latitude, longitude);
        }
        return geo;
    }

    public PointGeo getMin() {
        return new PointGeo(this.minLat, this.minLong);
    }

    public PointGeo getMax() {
        return new PointGeo(this.maxLat, this.maxLong);
    }

    public class PointGeo {
        double latitude;
        double longitude;

        public PointGeo(double latitude, double longitude) {
            this.latitude = latitude;
            this.longitude = longitude;
        }

        public double getLatitude() {
            return this.latitude;
        }

        public double getLongitude() {
            return this.longitude;
        }

        public String toString() {
            return String.format("PointGeo{%.6f, %.6f}", this.latitude, this.longitude);
        }
    }

    public class PointAbsolute {
        int x;
        int y;

        public PointAbsolute(int x, int y) {
            this.x = x;
            this.y = y;
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }

        public boolean equals(Object obj) {
            if (obj instanceof PointAbsolute) {
                PointAbsolute o = (PointAbsolute)obj;
                return this.x == o.x && this.y == o.y;
            }
            return false;
        }

        public int hashCode() {
            int hash = 5;
            hash = 67 * hash + this.x;
            hash = 67 * hash + this.y;
            return hash;
        }

        public String toString() {
            return "PointAbsolute{" + this.x + ", " + this.y + '}';
        }
    }
}

