/*
 * Decompiled with CFR 0.152.
 */
package plfx.screen.input.keeper.utils;

import java.io.File;
import java.io.IOException;
import plfx.screen.input.keeper.utils.AutoPaymentIntervalHolder;
import plfx.screen.input.keeper.utils.CashSourceHolder;
import plfx.screen.input.keeper.utils.CashSourceMenuHolder;
import plfx.screen.input.keeper.utils.CommissionHolder;
import plfx.screen.input.keeper.utils.CurrenciesHolder;
import plfx.screen.input.keeper.utils.LoginTypeHolder;
import plfx.screen.input.keeper.utils.MenuItemsHolder;
import plfx.screen.input.keeper.utils.MessageTypeHolder;
import plfx.screen.input.keeper.utils.ReferenceStorage;
import plfx.screen.input.keeper.utils.ReferenceSynchronizer;
import plfx.screen.input.keeper.utils.ServicesHolder;
import ru.softlogic.keeper.api.model.DTOParameter;
import ru.softlogic.keeper.api.model.reference.domain.DTOInformationTemplate;
import ru.softlogic.keeper.api.model.reference.domain.DTOReference;
import ru.softlogic.keeper.db.model.Area;
import ru.softlogic.keeper.db.model.AutoPaymentInterval;
import ru.softlogic.keeper.db.model.CashSource;
import ru.softlogic.keeper.db.model.CashSourceMenu;
import ru.softlogic.keeper.db.model.ClientAccountType;
import ru.softlogic.keeper.db.model.Commission;
import ru.softlogic.keeper.db.model.CommissionProfile;
import ru.softlogic.keeper.db.model.Currency;
import ru.softlogic.keeper.db.model.LoginType;
import ru.softlogic.keeper.db.model.MenuItem;
import ru.softlogic.keeper.db.model.MessageType;
import ru.softlogic.keeper.db.model.OperationType;
import ru.softlogic.keeper.db.model.ProviderType;
import ru.softlogic.keeper.db.model.Service;
import ru.softlogic.keeper.db.model.ServiceType;
import ru.softlogic.smartkeeper.api.jackson.ObjectMapperFactory;

public class ReferencesHelper {
    private static ReferencesHelper instance;
    private File workDir;
    private File verFile;
    private File sequenceFile;
    private final DTOReference references;
    private boolean initialized = false;
    private boolean localLoad;
    private final Object lock = new Object();
    private final MenuItemsHolder menuItemsHolder;
    private final ServicesHolder servicesHolder;
    private final CurrenciesHolder currenciesHolder;
    private final CashSourceMenuHolder cashSourceMenuHolder;
    private final CashSourceHolder cashSourceHolder;
    private final CommissionHolder commissionHolder;
    private final AutoPaymentIntervalHolder autoPaymentIntervalHolder;
    private final LoginTypeHolder loginTypeHolder;
    private final MessageTypeHolder messageTypeHolder;
    private ReferenceStorage<DTOParameter> storParameters;
    private ReferenceStorage<Area> storAreas;
    private ReferenceStorage<ClientAccountType> storClientAccountTypes;
    private ReferenceStorage<OperationType> storOperationTypes;
    private ReferenceStorage<CashSource> storCashSources;
    private ReferenceStorage<CashSourceMenu> storCashSourceMenus;
    private ReferenceStorage<AutoPaymentInterval> storAutoPaymentIntervals;
    private ReferenceStorage<ServiceType> storServiceTypes;
    private ReferenceStorage<Service> storServices;
    private ReferenceStorage<CommissionProfile> storCommissionProfiles;
    private ReferenceStorage<Commission> storCommissions;
    private ReferenceStorage<DTOInformationTemplate> storInformationTemplates;
    private ReferenceStorage<ProviderType> storProviderTypes;
    private ReferenceStorage<MenuItem> storMenuItems;
    private ReferenceStorage<Currency> storCurrencies;
    private ReferenceStorage<LoginType> storLoginTypes;
    private ReferenceStorage<MessageType> storMessageTypes;

    private ReferencesHelper() {
        this.references = new DTOReference();
        this.menuItemsHolder = new MenuItemsHolder();
        this.servicesHolder = new ServicesHolder();
        this.currenciesHolder = new CurrenciesHolder();
        this.cashSourceMenuHolder = new CashSourceMenuHolder();
        this.cashSourceHolder = new CashSourceHolder();
        this.commissionHolder = new CommissionHolder();
        this.autoPaymentIntervalHolder = new AutoPaymentIntervalHolder();
        this.loginTypeHolder = new LoginTypeHolder();
        this.messageTypeHolder = new MessageTypeHolder();
    }

    public static synchronized ReferencesHelper getInstance() {
        if (instance == null) {
            instance = new ReferencesHelper();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(File path) throws IOException {
        this.workDir = new File(path, "refs");
        if (!this.workDir.exists() && !this.workDir.mkdirs()) {
            throw new IOException("\u041e\u0448\u0438\u0431\u043a\u0430 \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u044f \u0440\u0430\u0431\u043e\u0447\u0435\u0433\u043e \u043a\u0430\u0442\u0430\u043b\u043e\u0433\u0430 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u043e\u0432");
        }
        this.verFile = new File(this.workDir, "ver.json");
        File sequenceFileOld = new File(this.workDir, "sequence.json");
        this.sequenceFile = new File(path, "sequence.json");
        if (sequenceFileOld.exists()) {
            Integer seqValue = 0;
            try {
                seqValue = (Integer)ObjectMapperFactory.getInstance().readValue(sequenceFileOld, Integer.class);
            }
            catch (IOException e) {
                // empty catch block
            }
            ObjectMapperFactory.getInstance().writeValue(this.sequenceFile, (Object)seqValue);
            sequenceFileOld.delete();
        }
        Long verValue = 0L;
        if (this.verFile.exists()) {
            verValue = (Long)ObjectMapperFactory.getInstance().readValue(this.verFile, Long.class);
        } else {
            ObjectMapperFactory.getInstance().writeValue(this.verFile, (Object)verValue);
        }
        if (!this.sequenceFile.exists()) {
            ObjectMapperFactory.getInstance().writeValue(this.sequenceFile, (Object)0);
        }
        this.references.setVersion(verValue.longValue());
        this.localLoad = false;
        this.storParameters = new ReferenceStorage<DTOParameter>(new File(this.workDir, "parameters.json"), DTOParameter.class);
        this.storAreas = new ReferenceStorage<Area>(new File(this.workDir, "areas.json"), Area.class);
        this.storClientAccountTypes = new ReferenceStorage<ClientAccountType>(new File(this.workDir, "clientAccountTypes.json"), ClientAccountType.class);
        this.storOperationTypes = new ReferenceStorage<OperationType>(new File(this.workDir, "operationTypes.json"), OperationType.class);
        this.storCashSources = new ReferenceStorage<CashSource>(new File(this.workDir, "cashSources.json"), CashSource.class);
        this.storCashSourceMenus = new ReferenceStorage<CashSourceMenu>(new File(this.workDir, "cashSourceMenus.json"), CashSourceMenu.class);
        this.storAutoPaymentIntervals = new ReferenceStorage<AutoPaymentInterval>(new File(this.workDir, "autoPaymentIntervals.json"), AutoPaymentInterval.class);
        this.storServiceTypes = new ReferenceStorage<ServiceType>(new File(this.workDir, "serviceTypes.json"), ServiceType.class);
        this.storServices = new ReferenceStorage<Service>(new File(this.workDir, "services.json"), Service.class);
        this.storCommissionProfiles = new ReferenceStorage<CommissionProfile>(new File(this.workDir, "commissionProfiles.json"), CommissionProfile.class);
        this.storCommissions = new ReferenceStorage<Commission>(new File(this.workDir, "commissions.json"), Commission.class);
        this.storInformationTemplates = new ReferenceStorage<DTOInformationTemplate>(new File(this.workDir, "informationTemplates.json"), DTOInformationTemplate.class);
        this.storProviderTypes = new ReferenceStorage<ProviderType>(new File(this.workDir, "providerTypes.json"), ProviderType.class);
        this.storMenuItems = new ReferenceStorage<MenuItem>(new File(this.workDir, "menuItems.json"), MenuItem.class);
        this.storCurrencies = new ReferenceStorage<Currency>(new File(this.workDir, "currencies.json"), Currency.class);
        this.storLoginTypes = new ReferenceStorage<LoginType>(new File(this.workDir, "loginTypes.json"), LoginType.class);
        this.storMessageTypes = new ReferenceStorage<MessageType>(new File(this.workDir, "messageTypes.json"), MessageType.class);
        Object object = this.lock;
        synchronized (object) {
            this.initialized = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInitialized() {
        Object object = this.lock;
        synchronized (object) {
            return this.initialized;
        }
    }

    public long getVersion() {
        return this.references.getVersion();
    }

    public synchronized int getSequence() throws IOException {
        Integer seqValue = 0;
        try {
            seqValue = (Integer)ObjectMapperFactory.getInstance().readValue(this.sequenceFile, Integer.class);
        }
        catch (IOException e) {
            System.out.println("getSequence read error:" + e.getMessage());
        }
        Integer n = seqValue;
        Integer n2 = seqValue = Integer.valueOf(seqValue + 1);
        ObjectMapperFactory.getInstance().writeValue(this.sequenceFile, (Object)seqValue);
        return seqValue;
    }

    public DTOReference getReferences() {
        return this.references;
    }

    public boolean isLocalLoad() {
        return this.localLoad;
    }

    public void reload() throws IOException {
        ObjectMapperFactory.getInstance().writeValue(this.verFile, (Object)0);
        this.references.setVersion(0L);
        this.storParameters.reset();
        this.storAreas.reset();
        this.storClientAccountTypes.reset();
        this.storOperationTypes.reset();
        this.storCashSources.reset();
        this.storCashSourceMenus.reset();
        this.storAutoPaymentIntervals.reset();
        this.storServiceTypes.reset();
        this.storServices.reset();
        this.storCommissionProfiles.reset();
        this.storCommissions.reset();
        this.storMenuItems.reset();
        this.storInformationTemplates.reset();
        this.storProviderTypes.reset();
        this.storCurrencies.reset();
        this.storLoginTypes.reset();
        this.storMessageTypes.reset();
        this.references.setParameters(null);
        this.references.setAreas(null);
        this.references.setClientAccountTypes(null);
        this.references.setOperationTypes(null);
        this.references.setCashSources(null);
        this.references.setCashSourceMenu(null);
        this.references.setAutoPaymentIntervals(null);
        this.references.setServiceTypes(null);
        this.references.setServices(null);
        this.references.setCommissionProfiles(null);
        this.references.setCommissions(null);
        this.references.setMenuItems(null);
        this.references.setInformationTemplates(null);
        this.references.setProviderTypes(null);
        this.references.setCurrencies(null);
        this.references.setLoginTypes(null);
        this.references.setMessageTypes(null);
        this.localLoad = false;
    }

    public void loadLocal() throws IOException {
        this.storParameters.load();
        this.storAreas.load();
        this.storClientAccountTypes.load();
        this.storOperationTypes.load();
        this.storCashSources.load();
        this.storCashSourceMenus.load();
        this.storAutoPaymentIntervals.load();
        this.storServiceTypes.load();
        this.storServices.load();
        this.storCommissionProfiles.load();
        this.storCommissions.load();
        this.storMenuItems.load();
        this.storInformationTemplates.load();
        this.storProviderTypes.load();
        this.storCurrencies.load();
        this.storLoginTypes.load();
        this.storMessageTypes.load();
        this.references.setParameters(this.storParameters.getReference());
        this.references.setAreas(this.storAreas.getReference());
        this.references.setClientAccountTypes(this.storClientAccountTypes.getReference());
        this.references.setOperationTypes(this.storOperationTypes.getReference());
        this.references.setCashSources(this.storCashSources.getReference());
        this.references.setCashSourceMenu(this.storCashSourceMenus.getReference());
        this.references.setAutoPaymentIntervals(this.storAutoPaymentIntervals.getReference());
        this.references.setServiceTypes(this.storServiceTypes.getReference());
        this.references.setServices(this.storServices.getReference());
        this.references.setCommissionProfiles(this.storCommissionProfiles.getReference());
        this.references.setCommissions(this.storCommissions.getReference());
        this.references.setMenuItems(this.storMenuItems.getReference());
        this.references.setInformationTemplates(this.storInformationTemplates.getReference());
        this.references.setProviderTypes(this.storProviderTypes.getReference());
        this.references.setCurrencies(this.storCurrencies.getReference());
        this.references.setLoginTypes(this.storLoginTypes.getReference());
        this.references.setMessageTypes(this.storMessageTypes.getReference());
        this.updateHolders();
        this.localLoad = true;
    }

    private void updateHolders() {
        if (this.references.getMenuItems() != null) {
            this.menuItemsHolder.update(this.references.getMenuItems());
        }
        if (this.references.getServices() != null) {
            this.servicesHolder.update(this.references.getServices());
        }
        if (this.references.getCurrencies() != null) {
            this.currenciesHolder.update(this.references.getCurrencies());
        }
        if (this.references.getCashSourceMenu() != null) {
            this.cashSourceMenuHolder.update(this.references.getCashSourceMenu());
        }
        if (this.references.getCashSources() != null) {
            this.cashSourceHolder.update(this.references.getCashSources());
        }
        if (this.references.getCommissionProfiles() != null && this.references.getCommissions() != null) {
            this.commissionHolder.update(this.references.getCommissionProfiles(), this.references.getCommissions());
        }
        if (this.references.getAutoPaymentIntervals() != null) {
            this.autoPaymentIntervalHolder.update(this.references.getAutoPaymentIntervals());
        }
        if (this.references.getLoginTypes() != null) {
            this.loginTypeHolder.update(this.references.getLoginTypes());
        }
        if (this.references.getMessageTypes() != null) {
            this.messageTypeHolder.update(this.references.getMessageTypes());
        }
    }

    public void updateReferences(DTOReference n) throws IOException {
        if (n.getVersion() != this.references.getVersion()) {
            ReferenceSynchronizer.synchronize(this.references, n);
            this.updateHolders();
            this.storParameters.setReference(this.references.getParameters());
            this.storAreas.setReference(this.references.getAreas());
            this.storClientAccountTypes.setReference(this.references.getClientAccountTypes());
            this.storOperationTypes.setReference(this.references.getOperationTypes());
            this.storCashSources.setReference(this.references.getCashSources());
            this.storCashSourceMenus.setReference(this.references.getCashSourceMenu());
            this.storAutoPaymentIntervals.setReference(this.references.getAutoPaymentIntervals());
            this.storServiceTypes.setReference(this.references.getServiceTypes());
            this.storServices.setReference(this.references.getServices());
            this.storCommissionProfiles.setReference(this.references.getCommissionProfiles());
            this.storCommissions.setReference(this.references.getCommissions());
            this.storMenuItems.setReference(this.references.getMenuItems());
            this.storInformationTemplates.setReference(this.references.getInformationTemplates());
            this.storProviderTypes.setReference(this.references.getProviderTypes());
            this.storCurrencies.setReference(this.references.getCurrencies());
            this.storLoginTypes.setReference(this.references.getLoginTypes());
            this.storMessageTypes.setReference(this.references.getMessageTypes());
            this.storParameters.store();
            this.storAreas.store();
            this.storClientAccountTypes.store();
            this.storOperationTypes.store();
            this.storCashSources.store();
            this.storCashSourceMenus.store();
            this.storAutoPaymentIntervals.store();
            this.storServiceTypes.store();
            this.storServices.store();
            this.storCommissionProfiles.store();
            this.storCommissions.store();
            this.storMenuItems.store();
            this.storInformationTemplates.store();
            this.storProviderTypes.store();
            this.storCurrencies.store();
            this.storLoginTypes.store();
            this.storMessageTypes.store();
            Long verValue = n.getVersion();
            ObjectMapperFactory.getInstance().writeValue(this.verFile, (Object)verValue);
            this.references.setVersion(verValue.longValue());
        }
    }

    public MenuItemsHolder getMenuItemsHolder() {
        return this.menuItemsHolder;
    }

    public ServicesHolder getServicesHolder() {
        return this.servicesHolder;
    }

    public CurrenciesHolder getCurrenciesHolder() {
        return this.currenciesHolder;
    }

    public CashSourceMenuHolder getCashSourceMenuHolder() {
        return this.cashSourceMenuHolder;
    }

    public CashSourceHolder getCashSourceHolder() {
        return this.cashSourceHolder;
    }

    public CommissionHolder getCommissionHolder() {
        return this.commissionHolder;
    }

    public AutoPaymentIntervalHolder getAutoPaymentIntervalHolder() {
        return this.autoPaymentIntervalHolder;
    }

    public LoginTypeHolder getLoginTypeHolder() {
        return this.loginTypeHolder;
    }

    public MessageTypeHolder getMessageTypeHolder() {
        return this.messageTypeHolder;
    }
}

