/*
 * Decompiled with CFR 0.152.
 */
package plfx.screen.input.keeper.utils;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.CollectionType;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import ru.softlogic.smartkeeper.api.jackson.ObjectMapperFactory;

public class ReferenceStorage<T> {
    private File file;
    private Collection<T> data;
    private Class<T> clazz;

    public ReferenceStorage(File f, Class<T> cl) throws IOException {
        if (f == null) {
            throw new NullPointerException("File is null");
        }
        this.file = f;
        this.clazz = cl;
    }

    public void setReference(Collection<T> req) {
        this.data = req;
    }

    public void load() throws IOException {
        if (this.file.exists()) {
            ObjectMapper mapper = ObjectMapperFactory.getInstance();
            CollectionType javaType = mapper.getTypeFactory().constructCollectionType(Collection.class, this.clazz);
            this.data = (Collection)mapper.readValue(this.file, (JavaType)javaType);
        } else {
            this.data = null;
        }
    }

    public void store() throws IOException {
        if (!this.file.exists()) {
            this.file.createNewFile();
        }
        ObjectMapper mapper = ObjectMapperFactory.getInstance();
        mapper.writeValue(this.file, this.data);
    }

    public void reset() throws IOException {
        this.data = null;
        this.store();
    }

    public Collection<T> getReference() {
        return this.data;
    }
}

