/*
 * Decompiled with CFR 0.152.
 */
package plfx.screen.input.keeper.template;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.log4j.Logger;
import plfx.screen.input.keeper.Global;
import plfx.screen.input.keeper.menu.MenuSelectListener;
import plfx.screen.input.keeper.menu.MenuSelectModule;
import plfx.screen.input.keeper.module.KeeperDefaultModule;
import plfx.screen.input.keeper.module.KeeperScreenListener;
import plfx.screen.input.keeper.template.AutopaysDataProvider;
import plfx.screen.input.keeper.template.TemplatesDataProvider;
import plfx.screen.input.keeper.utils.AutoPaymentIntervalHolder;
import plfx.screen.input.keeper.utils.CommissionHolder;
import plfx.screen.input.keeper.utils.MathUtils;
import plfx.screen.input.keeper.utils.MenuItemsHolder;
import plfx.screen.input.keeper.utils.ReferencesHelper;
import plfx.screen.input.keeper.utils.ServicesHolder;
import ru.slkf.atm.AtmAPI;
import ru.slkf.atm.AtmInputListener;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.input.model.field.IdentityField;
import ru.softlogic.input.model.field.numeric.NumericField;
import ru.softlogic.input.model.field.numeric.Range;
import ru.softlogic.input.model.field.selector.ItemsStore;
import ru.softlogic.input.model.field.selector.SelectorField;
import ru.softlogic.input.model.field.selector.SelectorItem;
import ru.softlogic.input.model.field.selector.StaticStore;
import ru.softlogic.input.model.field.text.NumericRangeValidator;
import ru.softlogic.input.model.field.text.Validator;
import ru.softlogic.input.model.screen.description.ScreenDescription;
import ru.softlogic.keeper.api.model.DTOAccount;
import ru.softlogic.keeper.api.model.DTOAttribute;
import ru.softlogic.keeper.api.model.DTOSum;
import ru.softlogic.keeper.api.model.autopayment.DTOAutoPayment;
import ru.softlogic.keeper.api.model.autopayment.DTOAutoPaymentInfo;
import ru.softlogic.keeper.api.model.commission.CommissionInfo;
import ru.softlogic.keeper.api.model.commission.SumResult;
import ru.softlogic.keeper.api.model.template.DTOTemplate;
import ru.softlogic.keeper.api.model.template.DTOTemplateInfo;
import ru.softlogic.keeper.db.model.AutoPaymentInterval;
import ru.softlogic.keeper.db.model.MenuItem;
import ru.softlogic.keeper.db.model.Service;
import ru.softlogic.keeper.db.model.TemplateAttribute;

public class TemplateModule
extends KeeperDefaultModule {
    private Set<DTOTemplateInfo> tplStorage;
    private List<DTOTemplateInfo> tplList;
    private TemplatesDataProvider tplProvider;
    private Set<DTOAutoPaymentInfo> apayStorage;
    private List<DTOAutoPaymentInfo> apayList;
    private AutopaysDataProvider apayProvider;
    private short pageTplSize;
    private int pageTpl;
    private short pageApaySize;
    private int pageApay;
    private Integer selectedMenuItemId;
    private Short selectedServiceId;
    private DTOTemplateInfo selectedTpl;
    private DTOAutoPaymentInfo selectedApay;
    private String newName;
    private String newSum;
    private String newTime;
    private String newDate;
    private String newPeriod;
    private Map<String, InputElement> newData;
    private Integer sumFromForm;
    private final MenuItemsHolder miHolder;
    private final ServicesHolder sHolder;
    private final AutoPaymentIntervalHolder apiHolder;
    private final DateFormat df = new SimpleDateFormat("dd.MM.yyyy");
    private final List<Range> sumRanges = new LinkedList<Range>();
    private final NumericRangeValidator sumValidator;

    public TemplateModule(AtmAPI modulelistener, Logger log) {
        super(modulelistener, log);
        this.miHolder = ReferencesHelper.getInstance().getMenuItemsHolder();
        this.sHolder = ReferencesHelper.getInstance().getServicesHolder();
        this.apiHolder = ReferencesHelper.getInstance().getAutoPaymentIntervalHolder();
        this.pageTplSize = (short)-1;
        this.pageApaySize = (short)-1;
        this.sumValidator = new NumericRangeValidator(this.sumRanges);
    }

    @Override
    public void onStart(boolean timeout) {
        this.setSection("payment");
        this.reset();
        this.menu();
    }

    @Override
    public void onFinish() {
        this.reset();
    }

    private void reset() {
        this.selectedApay = null;
        this.apayList = null;
        this.apayStorage = null;
        this.apayProvider = null;
        this.selectedTpl = null;
        this.tplList = null;
        this.tplStorage = null;
        this.tplProvider = null;
        this.sumFromForm = null;
    }

    private void exit() {
        this.modulelistener.endPaymentSession();
        Global.getInstance().getKeeperModule().exit();
    }

    @Override
    public void onTimeOut() {
        this.exit();
    }

    private void back() {
        this.modulelistener.endPaymentSession();
        Global.getInstance().getKeeperModule().getMenuPaymentModule().menu();
    }

    private void callPaymentSession(Short serviceId, HashMap<String, InputElement> ieMap, AtmInputListener listener) {
        Service s = this.sHolder.getService(serviceId);
        if (s != null) {
            this.log.debug((Object)("selected service:" + s));
            this.log.debug((Object)("id:" + s.getId()));
            this.log.debug((Object)("code:" + s.getCode()));
            this.log.debug((Object)("name:" + s.getName()));
            this.log.debug((Object)("fullname:" + s.getFullName()));
            this.log.debug((Object)("altname:" + s.getAltName()));
            this.log.debug((Object)("active:" + s.getActive()));
            this.log.debug((Object)("image2:" + s.getImage2()));
            this.modulelistener.addDataItem("service", (Object)s);
            this.modulelistener.startPaymentSession(s.getId().shortValue(), ieMap, listener, false);
        } else {
            this.modulelistener.addDataItem("fail_message", (Object)"Service not found");
            this.modulelistener.showDialog("login/fail", i -> {
                this.log.debug((Object)("dialog result: " + i));
                this.back();
            });
        }
    }

    private void restorePaymentSession(Short serviceId, AtmInputListener listener) {
        Service s = this.sHolder.getService(serviceId);
        if (s != null) {
            this.log.debug((Object)("selected service:" + s));
            this.log.debug((Object)("id:" + s.getId()));
            this.log.debug((Object)("code:" + s.getCode()));
            this.log.debug((Object)("name:" + s.getName()));
            this.log.debug((Object)("fullname:" + s.getFullName()));
            this.log.debug((Object)("altname:" + s.getAltName()));
            this.log.debug((Object)("active:" + s.getActive()));
            this.log.debug((Object)("image2:" + s.getImage2()));
            this.modulelistener.addDataItem("service", (Object)s);
            this.modulelistener.restoreInputModule(listener);
        } else {
            this.modulelistener.addDataItem("fail_message", (Object)"Service not found");
            this.modulelistener.showDialog("login/fail", i -> {
                this.log.debug((Object)("dialog result: " + i));
                this.back();
            });
        }
    }

    private void endPaymentSession() {
        this.modulelistener.endPaymentSession();
        this.modulelistener.removeDataItem("service");
    }

    private String formatSum(int sum) {
        String s = Integer.toString(sum / 100);
        if (sum % 100 > 0) {
            s = s + "." + String.format("%02d", sum % 100);
        }
        return s;
    }

    private int parseSum(String s) {
        int sum = (int)Math.round(Double.parseDouble(s) * 100.0);
        return sum;
    }

    public void menu() {
        this.modulelistener.endPaymentSession();
        this.showOrCreate("menu", () -> this.modulelistener.getScreen("keeper/selector/tplmenu"), () -> this.modulelistener.getScreenDescription("forms/tplmenu"), () -> new KeeperScreenListener(this.modulelistener, this.log){

            @Override
            protected void onAction(String action, Map<String, Object> data) {
                switch (action) {
                    case "next": {
                        InputElement item = (InputElement)data.get("menu.action");
                        TemplateModule.this.log.debug((Object)("Menu item action:" + item.getValue()));
                        switch (item.getValue()) {
                            case "templates": {
                                TemplateModule.this.templates();
                                break;
                            }
                            case "autopays": {
                                TemplateModule.this.autopays();
                                break;
                            }
                            case "createTemplate": {
                                TemplateModule.this.selectTemplateService();
                                break;
                            }
                            case "createAutopay": {
                                TemplateModule.this.selectApayService();
                            }
                        }
                        break;
                    }
                    case "prev": {
                        TemplateModule.this.back();
                    }
                }
            }
        });
    }

    private void listTpl(int p, int shift) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        boolean nextDisable = true;
        ArrayList templates = new ArrayList();
        if (this.pageTplSize > 0) {
            List ops = this.tplProvider.getData(p + shift, this.pageTplSize > 0 ? (short)this.pageTplSize : (short)10);
            if (ops != null) {
                this.pageTpl = p >= 0 ? p + shift : 0;
                nextDisable = this.tplProvider.getData(this.pageTpl + 1, this.pageTplSize > 0 ? (short)this.pageTplSize : (short)10) == null;
                this.tplList = ops;
            }
            if (this.tplList != null) {
                for (DTOTemplateInfo tpl : this.tplList) {
                    Service s = ReferencesHelper.getInstance().getServicesHolder().getService(tpl.getTemplate().getService().getId());
                    HashMap<String, String> pay = new HashMap<String, String>();
                    pay.put("title", tpl.getTemplate().getName());
                    pay.put("service", s.getName());
                    pay.put("sum", MathUtils.formatMoney(tpl.getTemplate().getSumOut().intValue()));
                    pay.put("object", (String)tpl);
                    templates.add(pay);
                }
            }
        }
        map.put("prevDisable", this.pageTpl == 0);
        map.put("nextDisable", nextDisable);
        map.put("templates", templates);
        this.showOrCreate("templates", () -> this.modulelistener.getScreen("keeper/templates"), null, () -> new KeeperScreenListener(this.modulelistener, this.log){

            @Override
            protected void onAction(String action, Map<String, Object> data) {
                switch (action) {
                    case "shortcutCreateTpl": {
                        TemplateModule.this.selectTemplateService();
                        break;
                    }
                    case "back": {
                        TemplateModule.this.menu();
                        break;
                    }
                    case "template": {
                        TemplateModule.this.selectedTpl = (DTOTemplateInfo)data.get("object");
                        TemplateModule.this.templateDetails();
                        break;
                    }
                    case "pageSize": {
                        Short ps = (Short)data.get("pageSize");
                        if (ps != null) {
                            TemplateModule.this.pageTplSize = ps;
                        }
                        TemplateModule.this.pageTpl = 0;
                        TemplateModule.this.tplList = null;
                        TemplateModule.this.listTpl(-1, 0);
                        break;
                    }
                    case "prevPage": {
                        if (TemplateModule.this.pageTpl <= 0) break;
                        TemplateModule.this.listTpl(TemplateModule.this.pageTpl, -1);
                        break;
                    }
                    case "nextPage": {
                        TemplateModule.this.listTpl(TemplateModule.this.pageTpl, 1);
                    }
                }
            }
        }, map);
    }

    public void templates() {
        this.modulelistener.endPaymentSession();
        if (this.tplStorage == null) {
            this.tplStorage = new TreeSet<DTOTemplateInfo>((o1, o2) -> {
                int r = o1.getTemplate().getId().compareTo(o2.getTemplate().getId());
                return r < 0 ? 1 : (r > 0 ? -1 : 0);
            });
        }
        if (this.tplProvider == null) {
            this.tplProvider = new TemplatesDataProvider(this.tplStorage);
        }
        this.tplStorage.clear();
        try {
            Collection<DTOTemplateInfo> list = Global.getInstance().doTemplates();
            if (list != null) {
                this.tplStorage.addAll(list);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.pageTpl = 0;
        this.tplList = null;
        this.listTpl(-1, 0);
    }

    private void templateDetails() {
        this.modulelistener.addDataItem("template", (Object)this.selectedTpl);
        StringBuilder sb = new StringBuilder();
        for (TemplateAttribute att : this.selectedTpl.getAttributes()) {
            if (att.getTitle() != null) {
                sb.append(att.getTitle());
            } else {
                sb.append(att.getName());
            }
            sb.append(": ");
            if (att.getView() != null) {
                sb.append(att.getView());
            } else {
                sb.append(att.getValue());
            }
            sb.append("\n");
        }
        String details = sb.toString();
        this.modulelistener.addDataItem("template_attrs", (Object)details);
        this.showOrCreate("tplDetails", () -> this.modulelistener.getScreen("keeper/templates/details"), null, () -> new KeeperScreenListener(this.modulelistener, this.log){

            @Override
            protected void onAction(String action, Map<String, Object> data) {
                switch (action) {
                    case "back": {
                        TemplateModule.this.selectedTpl = null;
                        TemplateModule.this.listTpl(TemplateModule.this.pageTpl, 0);
                        break;
                    }
                    case "paymentCreate": {
                        Global.getInstance().getKeeperModule().getPaymentModule().payment(TemplateModule.this.selectedTpl, () -> TemplateModule.this.templateDetails());
                        break;
                    }
                    case "templateEdit": {
                        TemplateModule.this.newData = null;
                        TemplateModule.this.newName = TemplateModule.this.selectedTpl.getTemplate().getName();
                        TemplateModule.this.newSum = TemplateModule.this.formatSum(TemplateModule.this.selectedTpl.getTemplate().getSumOut());
                        TemplateModule.this.selectedServiceId = TemplateModule.this.selectedTpl.getTemplate().getService().getId();
                        TemplateModule.this.selectedMenuItemId = TemplateModule.this.selectedTpl.getTemplate().getMenuItem().getId();
                        TemplateModule.this.modulelistener.addDataItem("group_mode", (Object)"templateEdit");
                        TemplateModule.this.inputTemplateName();
                        break;
                    }
                    case "templateDelete": {
                        TemplateModule.this.modulelistener.showDialog("template/delconfirm", i -> {
                            TemplateModule.this.log.debug((Object)("dialog result: " + i));
                            if (i == 1) {
                                TemplateModule.this.deleteTemplate();
                            }
                        });
                    }
                }
            }
        });
    }

    private void inputTemplateName() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tpl.name", new InputElement("tpl.name", null, this.newName));
        this.showOrCreate("tplName", () -> this.modulelistener.getScreen("group"), () -> this.modulelistener.getScreenDescription("forms/tplname"), () -> new KeeperScreenListener(this.modulelistener, this.log){

            @Override
            protected void onAction(String action, Map<String, Object> data) {
                switch (action) {
                    case "next": {
                        InputElement name = (InputElement)data.get("tpl.name");
                        if (name == null) break;
                        TemplateModule.this.newName = name.getValue();
                        TemplateModule.this.inputTemplateForm(false);
                        break;
                    }
                    case "prev": {
                        if (TemplateModule.this.selectedTpl != null) {
                            TemplateModule.this.templateDetails();
                            break;
                        }
                        TemplateModule.this.menu();
                    }
                }
            }
        }, map);
    }

    private void inputTemplateForm(boolean restore) {
        if (!restore) {
            HashMap<String, InputElement> ieMap = new HashMap<String, InputElement>();
            if (this.selectedTpl != null) {
                for (TemplateAttribute attr : this.selectedTpl.getAttributes()) {
                    InputElement ie = new InputElement();
                    ie.setKey(attr.getName());
                    ie.setKeyTitle(attr.getTitle());
                    ie.setValue(attr.getValue());
                    ie.setValueTitle(attr.getView());
                    ieMap.put(ie.getKey(), ie);
                }
            }
            this.callPaymentSession(this.selectedServiceId, ieMap, new TplFormListener());
        } else {
            this.restorePaymentSession(this.selectedServiceId, new TplFormListener());
        }
    }

    private void inputTemplateSum() {
        if (this.sumFromForm != null) {
            this.newSum = this.formatSum(this.sumFromForm);
            this.editTemplate();
        } else {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("cs.sum", new InputElement("cs.sum", null, this.newSum));
            Service s = this.sHolder.getService(this.selectedServiceId);
            this.sumRanges.clear();
            this.sumRanges.add(new Range((float)((double)s.getMinSum().intValue() / 100.0), (float)((double)s.getMaxSum().intValue() / 100.0)));
            this.modulelistener.addDataItem("service_min_sum", (Object)s.getMinSum());
            this.modulelistener.addDataItem("service_max_sum", (Object)s.getMaxSum());
            this.showOrCreate("tplSum", () -> this.modulelistener.getScreen("group"), () -> {
                ScreenDescription sd = this.modulelistener.getScreenDescription("forms/tplsum");
                for (IdentityField f : sd.getSequence().getFields()) {
                    if (!(f instanceof NumericField) || !f.getId().equals("cs.sum")) continue;
                    ((NumericField)f).setValidator((Validator)this.sumValidator);
                    break;
                }
                return sd;
            }, () -> new KeeperScreenListener(this.modulelistener, this.log){

                @Override
                protected void onAction(String action, Map<String, Object> data) {
                    switch (action) {
                        case "next": {
                            InputElement sum = (InputElement)data.get("cs.sum");
                            if (sum == null) break;
                            TemplateModule.this.newSum = sum.getValue();
                            TemplateModule.this.editTemplate();
                            break;
                        }
                        case "prev": {
                            TemplateModule.this.inputTemplateForm(true);
                        }
                    }
                }
            }, map);
        }
    }

    private void editTemplate() {
        this.modulelistener.execute(() -> {
            Short operationTypeId;
            DTOAccount ac = new DTOAccount();
            String acc1 = null;
            String acc2 = null;
            ArrayList<DTOAttribute> attrs = new ArrayList<DTOAttribute>();
            for (InputElement ie : this.newData.values()) {
                if (ie.getKey().equals("id1")) {
                    acc1 = ie.getValue();
                } else if (ie.getKey().equals("id2")) {
                    acc2 = ie.getValue();
                }
                attrs.add(new DTOAttribute(ie.getKey(), ie.getValue(), ie.getKeyTitle(), ie.getValueTitle()));
            }
            ac.setAccount(acc1);
            ac.setAccount2(acc2);
            ac.setAttributes(attrs);
            ac.setMenuItem(this.selectedMenuItemId.intValue());
            ac.setService(this.selectedServiceId.shortValue());
            Service s = this.sHolder.getService(this.selectedServiceId);
            DTOSum sum = new DTOSum();
            ArrayList sattrs = new ArrayList();
            sum.setOutcome(this.parseSum(this.newSum));
            CommissionHolder cHolder = ReferencesHelper.getInstance().getCommissionHolder();
            MenuItem menuItem = this.miHolder.getItem(this.selectedMenuItemId);
            CommissionInfo commissionInfo = cHolder.getCommissionInfo(menuItem.getCommissionProfile().getId());
            CommissionInfo minCommissionInfo = null;
            CommissionInfo maxCommissionInfo = null;
            if (s.getMinCommissionProfile() != null) {
                minCommissionInfo = cHolder.getCommissionInfo(s.getMinCommissionProfile().getId());
            }
            if (s.getMaxCommissionProfile() != null) {
                maxCommissionInfo = cHolder.getCommissionInfo(s.getMaxCommissionProfile().getId());
            }
            SumResult calcCommission = Global.getInstance().calcCommission(sum, commissionInfo, minCommissionInfo, maxCommissionInfo, (short)0);
            sum.setOutcome(calcCommission.getOut());
            sum.setCommission(calcCommission.getCommission());
            sum.setIncome(calcCommission.getOut() + calcCommission.getCommission());
            this.log.debug((Object)("sum:" + sum));
            if (this.selectedTpl != null) {
                operationTypeId = this.selectedTpl.getTemplate().getOperationType().getId();
            } else if (menuItem.getOperationType() != null) {
                operationTypeId = menuItem.getOperationType().getId();
            } else {
                MenuItem root = Global.getInstance().findMenuRoot("PAYMENT");
                operationTypeId = root.getOperationType().getId();
            }
            DTOTemplate newTpl = new DTOTemplate(ac, this.newName, sum, Global.getInstance().getClientDescription().getAccount().getId().longValue(), operationTypeId.shortValue(), true);
            if (this.selectedTpl != null) {
                return Global.getInstance().editTemplate(this.selectedTpl.getTemplate().getId(), newTpl);
            }
            return Global.getInstance().addTemplate(newTpl);
        }, t -> {
            this.modulelistener.endPaymentSession();
            if (this.selectedTpl != null) {
                this.tplStorage.remove(this.selectedTpl);
                this.tplStorage.add((DTOTemplateInfo)t);
                this.selectedTpl = t;
                this.templateDetails();
            } else {
                this.templates();
            }
        }, t -> {
            this.modulelistener.addDataItem("fail_message", (Object)t.getMessage());
            this.modulelistener.showDialog("login/fail", i -> {
                this.log.debug((Object)("dialog result: " + i));
                this.inputTemplateSum();
            });
        });
    }

    private void deleteTemplate() {
        if (this.selectedTpl != null) {
            this.modulelistener.execute(() -> Global.getInstance().removeTemplate(this.selectedTpl.getTemplate().getId()), t -> this.templates(), t -> {
                this.modulelistener.addDataItem("fail_message", (Object)t.getMessage());
                this.modulelistener.showDialog("login/fail", i -> {
                    this.log.debug((Object)("dialog result: " + i));
                    this.menu();
                });
            });
        }
    }

    private void selectTemplateService() {
        this.modulelistener.endPaymentSession();
        MenuSelectModule mm = Global.getInstance().getKeeperModule().getMenuSelectModule();
        MenuItem root = Global.getInstance().findMenuRoot("PAYMENT");
        if (root != null) {
            mm.setRoot(root);
            mm.setListener(new MenuSelectListener(){

                @Override
                public void onBack() {
                    TemplateModule.this.menu();
                }

                @Override
                public void onExit() {
                    TemplateModule.this.menu();
                }

                @Override
                public void onAction(String action) {
                    TemplateModule.this.menu();
                }

                @Override
                public void onSelect(MenuItem item) {
                    TemplateModule.this.selectedMenuItemId = item.getId();
                    TemplateModule.this.selectedServiceId = item.getService().getId();
                    TemplateModule.this.selectedTpl = null;
                    TemplateModule.this.newName = "";
                    TemplateModule.this.newSum = "";
                    TemplateModule.this.newData = null;
                    TemplateModule.this.inputTemplateName();
                }
            });
            this.modulelistener.addDataItem("group_mode", (Object)"createTemplate");
            mm.start();
        }
    }

    private void listApay(int p, int shift) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        ArrayList autopays = new ArrayList();
        boolean nextDisable = true;
        if (this.pageApaySize > 0) {
            List ops = this.apayProvider.getData(p + shift, this.pageApaySize > 0 ? (short)this.pageApaySize : (short)10);
            if (ops != null) {
                this.pageApay = p >= 0 ? p + shift : 0;
                nextDisable = this.apayProvider.getData(this.pageApay + 1, this.pageApaySize > 0 ? (short)this.pageApaySize : (short)10) == null;
                this.apayList = ops;
            }
            if (this.apayList != null) {
                for (DTOAutoPaymentInfo tpl : this.apayList) {
                    Service s = ReferencesHelper.getInstance().getServicesHolder().getService(tpl.getAutoPayment().getTemplate().getService().getId());
                    HashMap<String, String> pay = new HashMap<String, String>();
                    pay.put("title", tpl.getAutoPayment().getTemplate().getName());
                    pay.put("service", s.getName());
                    pay.put("sum", MathUtils.formatMoney(tpl.getAutoPayment().getTemplate().getSumOut().intValue()));
                    pay.put("object", (String)tpl);
                    autopays.add(pay);
                }
            }
        }
        map.put("prevDisable", this.pageApay == 0);
        map.put("nextDisable", nextDisable);
        map.put("autopays", autopays);
        this.showOrCreate("autopays", () -> this.modulelistener.getScreen("keeper/autopays"), null, () -> new KeeperScreenListener(this.modulelistener, this.log){

            @Override
            protected void onAction(String action, Map<String, Object> data) {
                switch (action) {
                    case "back": {
                        TemplateModule.this.menu();
                        break;
                    }
                    case "autopay": {
                        TemplateModule.this.selectedApay = (DTOAutoPaymentInfo)data.get("object");
                        TemplateModule.this.autopayDetails();
                        break;
                    }
                    case "pageSize": {
                        Short ps = (Short)data.get("pageSize");
                        if (ps != null) {
                            TemplateModule.this.pageApaySize = ps;
                        }
                        TemplateModule.this.pageApay = 0;
                        TemplateModule.this.apayList = null;
                        TemplateModule.this.listApay(-1, 0);
                        break;
                    }
                    case "prevPage": {
                        if (TemplateModule.this.pageApay <= 0) break;
                        TemplateModule.this.listApay(TemplateModule.this.pageApay, -1);
                        break;
                    }
                    case "nextPage": {
                        TemplateModule.this.listApay(TemplateModule.this.pageApay, 1);
                    }
                }
            }
        }, map);
    }

    public void autopays() {
        this.modulelistener.endPaymentSession();
        if (this.apayStorage == null) {
            this.apayStorage = new TreeSet<DTOAutoPaymentInfo>((o1, o2) -> {
                int r = o1.getAutoPayment().getId().compareTo(o2.getAutoPayment().getId());
                return r < 0 ? 1 : (r > 0 ? -1 : 0);
            });
        }
        if (this.apayProvider == null) {
            this.apayProvider = new AutopaysDataProvider(this.apayStorage);
        }
        this.apayStorage.clear();
        Collection<DTOAutoPaymentInfo> list = Global.getInstance().doAutoPayments();
        if (list != null) {
            this.apayStorage.addAll(list);
        }
        this.pageApay = 0;
        this.apayList = null;
        this.listApay(-1, 0);
    }

    public void autopayDetails() {
        this.modulelistener.addDataItem("autopay", (Object)this.selectedApay);
        StringBuilder sb = new StringBuilder();
        for (TemplateAttribute att : this.selectedApay.getAttributes()) {
            if (att.getTitle() != null) {
                sb.append(att.getTitle());
            } else {
                sb.append(att.getName());
            }
            sb.append(": ");
            if (att.getView() != null) {
                sb.append(att.getView());
            } else {
                sb.append(att.getValue());
            }
            sb.append("\n");
        }
        String details = sb.toString();
        this.modulelistener.addDataItem("autopay_attrs", (Object)details);
        AutoPaymentInterval interval = this.apiHolder.getInterval(this.selectedApay.getAutoPayment().getAutoPaymentInterval().getId());
        this.modulelistener.addDataItem("autopay_interval", (Object)interval);
        this.modulelistener.addDataItem("autopay_next", (Object)this.df.format(this.selectedApay.getAutoPayment().getLastExecutionDate()));
        this.showOrCreate("apayDetails", () -> this.modulelistener.getScreen("keeper/autopays/details"), null, () -> new KeeperScreenListener(this.modulelistener, this.log){

            @Override
            protected void onAction(String action, Map<String, Object> data) {
                switch (action) {
                    case "back": {
                        TemplateModule.this.selectedApay = null;
                        TemplateModule.this.listApay(TemplateModule.this.pageApay, 0);
                        break;
                    }
                    case "autopayDelete": {
                        TemplateModule.this.modulelistener.showDialog("autopay/delconfirm", i -> {
                            TemplateModule.this.log.debug((Object)("dialog result: " + i));
                            if (i == 1) {
                                TemplateModule.this.deleteApay();
                            }
                        });
                        break;
                    }
                    case "autopayEdit": {
                        TemplateModule.this.newData = null;
                        TemplateModule.this.newName = TemplateModule.this.selectedApay.getAutoPayment().getTemplate().getName();
                        TemplateModule.this.newPeriod = TemplateModule.this.selectedApay.getAutoPayment().getAutoPaymentInterval().getCode();
                        TemplateModule.this.newTime = String.format("%02d", TemplateModule.this.selectedApay.getAutoPayment().getExecuteHour());
                        TemplateModule.this.newDate = TemplateModule.this.df.format(TemplateModule.this.selectedApay.getAutoPayment().getDbegin());
                        TemplateModule.this.newSum = TemplateModule.this.formatSum(TemplateModule.this.selectedApay.getAutoPayment().getTemplate().getSumOut());
                        TemplateModule.this.selectedServiceId = TemplateModule.this.selectedApay.getAutoPayment().getTemplate().getService().getId();
                        TemplateModule.this.selectedMenuItemId = TemplateModule.this.selectedApay.getAutoPayment().getTemplate().getMenuItem().getId();
                        TemplateModule.this.modulelistener.addDataItem("group_mode", (Object)"autopayEdit");
                        TemplateModule.this.inputApayName();
                    }
                }
            }
        });
    }

    private void inputApayName() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("autopay.name", new InputElement("autopay.name", null, this.newName));
        this.showOrCreate("apayName", () -> this.modulelistener.getScreen("group"), () -> this.modulelistener.getScreenDescription("forms/apayname"), () -> new KeeperScreenListener(this.modulelistener, this.log){

            @Override
            protected void onAction(String action, Map<String, Object> data) {
                switch (action) {
                    case "next": {
                        InputElement name = (InputElement)data.get("autopay.name");
                        if (name == null) break;
                        TemplateModule.this.newName = name.getValue();
                        TemplateModule.this.inputApayForm(false);
                        break;
                    }
                    case "prev": {
                        if (TemplateModule.this.selectedApay != null) {
                            TemplateModule.this.autopayDetails();
                            break;
                        }
                        TemplateModule.this.menu();
                    }
                }
            }
        }, map);
    }

    private void inputApayForm(boolean restore) {
        if (!restore) {
            HashMap<String, InputElement> ieMap = new HashMap<String, InputElement>();
            if (this.selectedApay != null) {
                for (TemplateAttribute attr : this.selectedApay.getAttributes()) {
                    InputElement ie = new InputElement();
                    ie.setKey(attr.getName());
                    ie.setKeyTitle(attr.getTitle());
                    ie.setValue(attr.getValue());
                    ie.setValueTitle(attr.getView());
                    ieMap.put(ie.getKey(), ie);
                }
            }
            this.callPaymentSession(this.selectedServiceId, ieMap, new ApayFormListener());
        } else {
            this.restorePaymentSession(this.selectedServiceId, new ApayFormListener());
        }
    }

    private void inputApayPeriod() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("autopay.period", new InputElement("autopay.period", null, this.newPeriod));
        this.showOrCreate("apayPeriod", () -> this.modulelistener.getScreen("keeper/selector/apimenu"), () -> {
            ScreenDescription periodSD = this.modulelistener.getScreenDescription("forms/apayperiod");
            SelectorField sf = (SelectorField)periodSD.getSequence().getFields().get(0);
            ArrayList apiList = new ArrayList();
            this.apiHolder.getIntervals().stream().forEach(i -> apiList.add(new SelectorItem(i.getName(), Short.toString(i.getId()))));
            sf.setStore((ItemsStore)new StaticStore(apiList));
            return periodSD;
        }, () -> new KeeperScreenListener(this.modulelistener, this.log){

            @Override
            protected void onAction(String action, Map<String, Object> data) {
                switch (action) {
                    case "next": {
                        InputElement period = (InputElement)data.get("autopay.period");
                        if (period == null) break;
                        TemplateModule.this.newPeriod = period.getValue();
                        TemplateModule.this.inputApayDateTime();
                        break;
                    }
                    case "prev": {
                        TemplateModule.this.inputApayForm(true);
                    }
                }
            }
        }, map);
    }

    private void inputApayDateTime() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("autopay.time", new InputElement("autopay.time", null, this.newTime));
        if (this.newDate != null) {
            map.put("autopay.date", new InputElement("autopay.date", null, this.newDate));
        }
        this.showOrCreate("apayDateTime", () -> this.modulelistener.getScreen("group"), () -> this.modulelistener.getScreenDescription("forms/apaydatetime"), () -> new KeeperScreenListener(this.modulelistener, this.log){

            @Override
            protected void onAction(String action, Map<String, Object> data) {
                switch (action) {
                    case "next": {
                        InputElement time = (InputElement)data.get("autopay.time");
                        InputElement date = (InputElement)data.get("autopay.date");
                        if (time == null || date == null) break;
                        TemplateModule.this.newTime = time.getValue();
                        TemplateModule.this.newDate = date.getValue();
                        TemplateModule.this.inputApaySum();
                        break;
                    }
                    case "prev": {
                        TemplateModule.this.inputApayPeriod();
                    }
                }
            }
        }, map);
    }

    private void inputApaySum() {
        if (this.sumFromForm != null) {
            this.newSum = this.formatSum(this.sumFromForm);
            this.editAutopay();
        } else {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("cs.sum", new InputElement("cs.sum", null, this.newSum));
            Service s = this.sHolder.getService(this.selectedServiceId);
            this.sumRanges.clear();
            this.sumRanges.add(new Range((float)((double)s.getMinSum().intValue() / 100.0), (float)((double)s.getMaxSum().intValue() / 100.0)));
            this.modulelistener.addDataItem("service_min_sum", (Object)s.getMinSum());
            this.modulelistener.addDataItem("service_max_sum", (Object)s.getMaxSum());
            this.showOrCreate("apaySum", () -> this.modulelistener.getScreen("group"), () -> {
                ScreenDescription sd = this.modulelistener.getScreenDescription("forms/apaysum");
                for (IdentityField f : sd.getSequence().getFields()) {
                    if (!(f instanceof NumericField) || !f.getId().equals("cs.sum")) continue;
                    ((NumericField)f).setValidator((Validator)this.sumValidator);
                    break;
                }
                return sd;
            }, () -> new KeeperScreenListener(this.modulelistener, this.log){

                @Override
                protected void onAction(String action, Map<String, Object> data) {
                    switch (action) {
                        case "next": {
                            InputElement sum = (InputElement)data.get("cs.sum");
                            if (sum == null) break;
                            TemplateModule.this.newSum = sum.getValue();
                            TemplateModule.this.editAutopay();
                            break;
                        }
                        case "prev": {
                            TemplateModule.this.inputApayDateTime();
                        }
                    }
                }
            }, map);
        }
    }

    private void editAutopay() {
        this.modulelistener.execute(() -> {
            Date dBegin;
            Short operationTypeId;
            MenuItem menuItem = this.miHolder.getItem(this.selectedMenuItemId);
            Service s = this.sHolder.getService(this.selectedServiceId);
            DTOAccount ac = new DTOAccount();
            String acc1 = null;
            String acc2 = null;
            ArrayList<DTOAttribute> attrs = new ArrayList<DTOAttribute>();
            for (InputElement ie : this.newData.values()) {
                if (ie.getKey().equals("id1")) {
                    acc1 = ie.getValue();
                } else if (ie.getKey().equals("id2")) {
                    acc2 = ie.getValue();
                }
                attrs.add(new DTOAttribute(ie.getKey(), ie.getValue(), ie.getKeyTitle(), ie.getValueTitle()));
            }
            ac.setAccount(acc1);
            ac.setAccount2(acc2);
            ac.setAttributes(attrs);
            ac.setMenuItem(menuItem.getId().intValue());
            ac.setService(s.getId().shortValue());
            DTOSum sum = new DTOSum();
            ArrayList sattrs = new ArrayList();
            sum.setOutcome(this.parseSum(this.newSum));
            CommissionHolder cHolder = ReferencesHelper.getInstance().getCommissionHolder();
            CommissionInfo commissionInfo = cHolder.getCommissionInfo(menuItem.getCommissionProfile().getId());
            CommissionInfo minCommissionInfo = null;
            CommissionInfo maxCommissionInfo = null;
            if (s.getMinCommissionProfile() != null) {
                minCommissionInfo = cHolder.getCommissionInfo(s.getMinCommissionProfile().getId());
            }
            if (s.getMaxCommissionProfile() != null) {
                maxCommissionInfo = cHolder.getCommissionInfo(s.getMaxCommissionProfile().getId());
            }
            SumResult calcCommission = Global.getInstance().calcCommission(sum, commissionInfo, minCommissionInfo, maxCommissionInfo, (short)0);
            sum.setOutcome(calcCommission.getOut());
            sum.setCommission(calcCommission.getCommission());
            sum.setIncome(calcCommission.getOut() + calcCommission.getCommission());
            this.log.debug((Object)("sum:" + sum));
            if (this.selectedApay != null) {
                operationTypeId = this.selectedApay.getAutoPayment().getTemplate().getOperationType().getId();
            } else if (menuItem.getOperationType() != null) {
                operationTypeId = menuItem.getOperationType().getId();
            } else {
                MenuItem root = Global.getInstance().findMenuRoot("PAYMENT");
                operationTypeId = root.getOperationType().getId();
            }
            AutoPaymentInterval interval = new AutoPaymentInterval(Short.valueOf(Short.parseShort(this.newPeriod)));
            Date dEnd = null;
            try {
                dBegin = this.df.parse(this.newDate);
            }
            catch (ParseException e) {
                throw new RuntimeException(e);
            }
            DTOAutoPayment newApay = new DTOAutoPayment(ac, this.newName, sum, Global.getInstance().getClientDescription().getAccount().getId().longValue(), operationTypeId.shortValue(), interval, Short.parseShort(this.newTime), false, dBegin, dEnd, true);
            if (this.selectedApay != null) {
                return Global.getInstance().editAutopay(this.selectedApay.getAutoPayment().getTemplate().getId(), newApay);
            }
            return Global.getInstance().addAutopay(newApay);
        }, t -> {
            this.modulelistener.endPaymentSession();
            if (this.selectedApay != null) {
                this.apayStorage.remove(this.selectedApay);
                this.apayStorage.add((DTOAutoPaymentInfo)t);
                this.selectedApay = t;
                this.autopayDetails();
            } else {
                this.autopays();
            }
        }, t -> {
            this.log.error((Object)("Error edit/create autopay:" + t.getMessage()), (Throwable)t);
            this.modulelistener.addDataItem("fail_message", (Object)t.getMessage());
            this.modulelistener.showDialog("login/fail", i -> {
                this.log.debug((Object)("dialog result: " + i));
                this.inputApaySum();
            });
        });
    }

    private void deleteApay() {
        if (this.selectedApay != null) {
            this.modulelistener.execute(() -> Global.getInstance().removeAutopay(this.selectedApay.getAutoPayment().getId()), t -> this.autopays(), t -> {
                this.modulelistener.addDataItem("fail_message", (Object)t.getMessage());
                this.modulelistener.showDialog("login/fail", i -> {
                    this.log.debug((Object)("dialog result: " + i));
                    this.menu();
                });
            });
        }
    }

    private void selectApayService() {
        this.modulelistener.endPaymentSession();
        MenuSelectModule mm = Global.getInstance().getKeeperModule().getMenuSelectModule();
        MenuItem root = Global.getInstance().findMenuRoot("PAYMENT");
        if (root != null) {
            mm.setRoot(root);
            mm.setListener(new MenuSelectListener(){

                @Override
                public void onBack() {
                    TemplateModule.this.menu();
                }

                @Override
                public void onExit() {
                    TemplateModule.this.menu();
                }

                @Override
                public void onAction(String action) {
                    TemplateModule.this.menu();
                }

                @Override
                public void onSelect(MenuItem item) {
                    TemplateModule.this.selectedMenuItemId = item.getId();
                    TemplateModule.this.selectedServiceId = item.getService().getId();
                    TemplateModule.this.selectedApay = null;
                    TemplateModule.this.newName = "";
                    TemplateModule.this.newPeriod = "";
                    TemplateModule.this.newTime = "";
                    TemplateModule.this.newDate = null;
                    TemplateModule.this.newSum = "";
                    TemplateModule.this.newData = null;
                    TemplateModule.this.inputApayName();
                }
            });
            this.modulelistener.addDataItem("group_mode", (Object)"createAutopay");
            mm.start();
        }
    }

    class ApayFormListener
    implements AtmInputListener {
        ApayFormListener() {
        }

        public void onBack() {
            TemplateModule.this.log.debug((Object)"SERVICE: onBack()");
            TemplateModule.this.endPaymentSession();
            TemplateModule.this.inputApayName();
        }

        public void onExit() {
            TemplateModule.this.log.debug((Object)"SERVICE: onExit()");
            TemplateModule.this.endPaymentSession();
            if (TemplateModule.this.selectedApay != null) {
                TemplateModule.this.autopayDetails();
            } else {
                TemplateModule.this.menu();
            }
        }

        public void onPay(Map<String, InputElement> data, Short serviceId, Integer sum) {
            TemplateModule.this.log.debug((Object)("SERVICE: onPay():" + data));
            TemplateModule.this.newData = data;
            TemplateModule.this.modulelistener.removeDataItem("service");
            TemplateModule.this.sumFromForm = sum;
            TemplateModule.this.inputApayPeriod();
        }

        public void onAction(String action) {
            TemplateModule.this.log.debug((Object)("onAction: " + action));
            TemplateModule.this.endPaymentSession();
            switch (action) {
                case "payment": {
                    Global.getInstance().getKeeperModule().getHomeModule().payment();
                    break;
                }
                case "transfer": {
                    Global.getInstance().getKeeperModule().getHomeModule().transfer();
                    break;
                }
                case "receipt": {
                    Global.getInstance().getKeeperModule().getHomeModule().receipt();
                    break;
                }
                case "home": {
                    Global.getInstance().getKeeperModule().getHomeModule().home();
                    break;
                }
                case "exit": {
                    Global.getInstance().getKeeperModule().exit();
                }
            }
        }

        public void onRedirect(int id) {
            TemplateModule.this.log.debug((Object)("SERVICE: onRedirect():" + id));
        }
    }

    class TplFormListener
    implements AtmInputListener {
        TplFormListener() {
        }

        public void onBack() {
            TemplateModule.this.log.debug((Object)"SERVICE: onBack()");
            TemplateModule.this.endPaymentSession();
            TemplateModule.this.inputTemplateName();
        }

        public void onExit() {
            TemplateModule.this.log.debug((Object)"SERVICE: onExit()");
            TemplateModule.this.endPaymentSession();
            if (TemplateModule.this.selectedTpl != null) {
                TemplateModule.this.templateDetails();
            } else {
                TemplateModule.this.menu();
            }
        }

        public void onPay(Map<String, InputElement> data, Short serviceId, Integer sum) {
            TemplateModule.this.log.debug((Object)("SERVICE: onPay():" + data));
            TemplateModule.this.newData = data;
            TemplateModule.this.modulelistener.removeDataItem("service");
            if (sum != null) {
                TemplateModule.this.newSum = Integer.toString(sum / 100) + "." + String.format("%02d", sum % 100);
                TemplateModule.this.editTemplate();
            } else {
                TemplateModule.this.inputTemplateSum();
            }
        }

        public void onAction(String action) {
            TemplateModule.this.log.debug((Object)("onAction: " + action));
            TemplateModule.this.endPaymentSession();
            switch (action) {
                case "payment": {
                    Global.getInstance().getKeeperModule().getHomeModule().payment();
                    break;
                }
                case "transfer": {
                    Global.getInstance().getKeeperModule().getHomeModule().transfer();
                    break;
                }
                case "receipt": {
                    Global.getInstance().getKeeperModule().getHomeModule().receipt();
                    break;
                }
                case "home": {
                    Global.getInstance().getKeeperModule().getHomeModule().home();
                    break;
                }
                case "exit": {
                    Global.getInstance().getKeeperModule().exit();
                }
            }
        }

        public void onRedirect(int id) {
            TemplateModule.this.log.debug((Object)("SERVICE: onRedirect():" + id));
        }
    }
}

