/*
 * Decompiled with CFR 0.152.
 */
package plfx.screen.input.keeper.payment;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.apache.log4j.Logger;
import plfx.screen.input.keeper.Global;
import plfx.screen.input.keeper.module.KeeperDefaultModule;
import plfx.screen.input.keeper.module.KeeperScreenListener;
import plfx.screen.input.keeper.utils.CashSourceHolder;
import plfx.screen.input.keeper.utils.CashSourceMenuHolder;
import plfx.screen.input.keeper.utils.CommissionHolder;
import plfx.screen.input.keeper.utils.MenuItemsHolder;
import plfx.screen.input.keeper.utils.ReferencesHelper;
import plfx.screen.input.keeper.utils.ServicesHolder;
import ru.slkf.atm.AtmAPI;
import ru.slkf.atm.AtmInputListener;
import ru.slkf.atm.AtmPaymentListener;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.input.model.field.selector.SelectorField;
import ru.softlogic.input.model.field.selector.SelectorItem;
import ru.softlogic.input.model.screen.description.ScreenDescription;
import ru.softlogic.keeper.api.model.DTOAccount;
import ru.softlogic.keeper.api.model.DTOAttribute;
import ru.softlogic.keeper.api.model.DTOSum;
import ru.softlogic.keeper.api.model.DTOVHistory;
import ru.softlogic.keeper.api.model.client.domain.DTOClientDescription;
import ru.softlogic.keeper.api.model.commission.CommissionInfo;
import ru.softlogic.keeper.api.model.commission.SumResult;
import ru.softlogic.keeper.api.model.operation.DTOOperationInformation;
import ru.softlogic.keeper.api.model.operation.DTOPayment;
import ru.softlogic.keeper.api.model.template.DTOTemplateInfo;
import ru.softlogic.keeper.db.model.CashSource;
import ru.softlogic.keeper.db.model.CashSourceMenu;
import ru.softlogic.keeper.db.model.MenuItem;
import ru.softlogic.keeper.db.model.OperationAttribute;
import ru.softlogic.keeper.db.model.ProcessingPaymentSource;
import ru.softlogic.keeper.db.model.Service;
import ru.softlogic.keeper.db.model.TemplateAttribute;

public class PaymentModule
extends KeeperDefaultModule {
    private LocalCashSourceScreenListener cashSourceScreenListener;
    private List<CashSourceMenu> cashSourceMenu;
    private List<SelectorItem> itemsCashSource;
    private CashSource selectedCashSource;
    private CashSource csKeeper;
    private DTOOperationInformation payment;
    private Map<String, InputElement> context = new HashMap<String, InputElement>();
    private Map<String, Object> cashSourceData = new HashMap<String, Object>();
    private Short operationTypeId;
    private Short commissionProfileId;
    private Short serviceId;
    private Integer menuItemId;
    private Integer sumFromForm;
    private Integer sumFromTemplate;
    private MenuItemsHolder miHolder = ReferencesHelper.getInstance().getMenuItemsHolder();
    private ServicesHolder sHolder = ReferencesHelper.getInstance().getServicesHolder();
    private CashSourceHolder csHolder = ReferencesHelper.getInstance().getCashSourceHolder();
    private CashSourceMenuHolder csmHolder = ReferencesHelper.getInstance().getCashSourceMenuHolder();
    private int from;
    private AtmInputListener inputListener;

    public PaymentModule(AtmAPI modulelistener, Logger log) {
        super(modulelistener, log);
        this.csKeeper = this.csHolder.getItemByCode("KEEPER");
        if (this.csKeeper == null) {
            throw new NullPointerException("KEEPER cashSource not found");
        }
        this.cashSourceScreenListener = new LocalCashSourceScreenListener(modulelistener, log);
    }

    @Override
    public void onStart(boolean timeout) {
        this.resetData();
    }

    private void callPaymentSession(boolean confirm, HashMap<String, InputElement> ieMap, AtmInputListener listener) {
        Integer get = (Integer)Global.getInstance().getClientDescription().getCashSourceMenuProfiles().get(this.operationTypeId);
        this.cashSourceMenu = this.csmHolder.getChildsByMenuProfile(get);
        this.log.debug((Object)("cashSourceMenu:" + this.cashSourceMenu));
        Service s = this.sHolder.getService(this.serviceId);
        if (s != null) {
            this.log.debug((Object)("selected service:" + s));
            this.log.debug((Object)("id:" + s.getId()));
            this.log.debug((Object)("code:" + s.getCode()));
            this.log.debug((Object)("name:" + s.getName()));
            this.log.debug((Object)("fullname:" + s.getFullName()));
            this.log.debug((Object)("altname:" + s.getAltName()));
            this.log.debug((Object)("active:" + s.getActive()));
            this.log.debug((Object)("image2:" + s.getImage2()));
            this.modulelistener.addDataItem("service", (Object)s);
            this.modulelistener.startPaymentSession(s.getId().shortValue(), ieMap, listener, confirm);
        } else {
            this.modulelistener.addDataItem("fail_message", (Object)"Service not found");
            this.modulelistener.showDialog("login/fail", i -> {
                this.log.debug((Object)("dialog result: " + i));
                this.back();
            });
        }
    }

    public void payment(DTOVHistory pay) {
        this.from = 1;
        this.resetData();
        MenuItem item = this.miHolder.getItem(pay.getOperation().getMenuItem().getId());
        if (item != null) {
            this.commissionProfileId = item.getCommissionProfile().getId();
            this.serviceId = pay.getOperation().getService().getId();
            this.menuItemId = pay.getOperation().getMenuItem().getId();
            this.operationTypeId = pay.getOperation().getOperationType().getId();
            HashMap<String, InputElement> ieMap = new HashMap<String, InputElement>();
            for (OperationAttribute attr : pay.getAttributes()) {
                InputElement ie = new InputElement();
                ie.setKey(attr.getName());
                ie.setKeyTitle(attr.getTitle());
                ie.setValue(attr.getValue());
                ie.setValueTitle(attr.getView());
                ieMap.put(ie.getKey(), ie);
            }
            this.inputListener = new PaymentModuleAtmInputListener();
            this.callPaymentSession(true, ieMap, this.inputListener);
        } else {
            this.modulelistener.addDataItem("fail_message", (Object)"Menu item not found");
            this.modulelistener.showDialog("login/fail", i -> {
                this.log.debug((Object)("dialog result: " + i));
                this.back();
            });
        }
    }

    public void payment(DTOTemplateInfo tpl, Runnable onBackHandler) {
        this.from = 2;
        this.resetData();
        MenuItem item = this.miHolder.getItem(tpl.getTemplate().getMenuItem().getId());
        if (item != null) {
            this.commissionProfileId = item.getCommissionProfile().getId();
            this.serviceId = tpl.getTemplate().getService().getId();
            this.menuItemId = tpl.getTemplate().getMenuItem().getId();
            this.operationTypeId = tpl.getTemplate().getOperationType().getId();
            LinkedHashMap<String, InputElement> ieMap = new LinkedHashMap<String, InputElement>();
            for (TemplateAttribute attr : tpl.getAttributes()) {
                InputElement ie = new InputElement();
                ie.setKey(attr.getName());
                ie.setKeyTitle(attr.getTitle());
                ie.setValue(attr.getValue());
                ie.setValueTitle(attr.getView());
                ieMap.put(ie.getKey(), ie);
            }
            this.sumFromTemplate = tpl.getSum().getOutcome();
            this.inputListener = new PaymentModuleAtmInputListener(onBackHandler);
            this.callPaymentSession(true, ieMap, this.inputListener);
        } else {
            this.modulelistener.addDataItem("fail_message", (Object)"Menu item not found");
            this.modulelistener.showDialog("login/fail", i -> {
                this.log.debug((Object)("dialog result: " + i));
                onBackHandler.run();
            });
        }
    }

    public void payment(MenuItem it) {
        this.from = 0;
        this.resetData();
        MenuItem item = this.miHolder.getItem(it.getId());
        if (item != null) {
            this.commissionProfileId = item.getCommissionProfile().getId();
            this.serviceId = item.getService().getId();
            this.menuItemId = item.getId();
            if (item.getOperationType() != null) {
                this.operationTypeId = item.getOperationType().getId();
            } else {
                MenuItem root = Global.getInstance().findMenuRoot("PAYMENT");
                this.operationTypeId = root.getOperationType().getId();
            }
            this.inputListener = new PaymentModuleAtmInputListener();
            this.callPaymentSession(false, new HashMap<String, InputElement>(), this.inputListener);
        } else {
            this.modulelistener.addDataItem("fail_message", (Object)"Menu item not found");
            this.modulelistener.showDialog("login/fail", i -> {
                this.log.debug((Object)("dialog result: " + i));
                this.back();
            });
        }
    }

    private void resetData() {
        this.payment = null;
        this.selectedCashSource = null;
        this.serviceId = null;
        this.sumFromForm = null;
        this.sumFromTemplate = null;
        this.context.clear();
        this.cashSourceData.clear();
        this.inputListener = null;
    }

    @Override
    public void onFinish() {
        this.resetData();
    }

    private void exit() {
        Global.getInstance().getKeeperModule().exit();
    }

    @Override
    public void onTimeOut() {
        this.exit();
    }

    private void back() {
        this.modulelistener.endPaymentSession();
        this.resetData();
        if (this.from == 1) {
            Global.getInstance().getKeeperModule().getHistoryModule().start();
        } else if (this.from == 2) {
            Global.getInstance().getKeeperModule().getTemplateModule().start();
        } else {
            Global.getInstance().getKeeperModule().getMenuPaymentModule().menu();
        }
    }

    private String formatSum(int sum) {
        String s = Integer.toString(sum / 100);
        if (sum % 100 > 0) {
            s = s + "." + String.format("%02d", sum % 100);
        }
        return s;
    }

    private int parseSum(String s) {
        int sum = (int)Math.round(Double.parseDouble(s) * 100.0);
        return sum;
    }

    private void inputSum() {
        if ("TERMINAL".equals(this.selectedCashSource.getCode())) {
            this.createPayment();
        } else if (this.sumFromForm != null && "KEEPER".equals(this.selectedCashSource.getCode())) {
            InputElement ie = new InputElement("cs.sum", "sum", this.formatSum(this.sumFromForm));
            this.cashSourceData.put("cs.sum", ie);
            this.createPayment();
        } else {
            HashMap<String, Object> ieMap = new HashMap<String, Object>();
            if (this.sumFromTemplate != null) {
                ieMap.put("cs.sum", new InputElement("cs.sum", "sum", this.formatSum(this.sumFromTemplate)));
            }
            this.showOrCreate("inputSum" + this.selectedCashSource.getCode(), () -> this.modulelistener.getScreen("group"), () -> this.modulelistener.getScreenDescription("forms/cashsource/" + this.selectedCashSource.getCode().toLowerCase()), () -> new KeeperScreenListener(this.modulelistener, this.log){

                @Override
                protected void onAction(String action, Map<String, Object> data) {
                    switch (action) {
                        case "next": {
                            PaymentModule.this.cashSourceData.putAll(data);
                            PaymentModule.this.createPayment();
                            break;
                        }
                        case "prev": {
                            PaymentModule.this.selectCashSource(PaymentModule.this.cashSourceMenu);
                        }
                    }
                }
            }, ieMap);
        }
    }

    private void inputTemplateName() {
        this.showOrCreate("inputName", () -> this.modulelistener.getScreen("group"), () -> this.modulelistener.getScreenDescription("forms/tplname"), () -> new KeeperScreenListener(this.modulelistener, this.log){

            @Override
            protected void onAction(String action, Map<String, Object> data) {
                switch (action) {
                    case "next": {
                        PaymentModule.this.createTemplate(data);
                        break;
                    }
                    case "prev": {
                        PaymentModule.this.successPayment();
                    }
                }
            }
        });
    }

    private void selectCashSource(List<CashSourceMenu> csml) {
        ArrayList<SelectorItem> list = new ArrayList<SelectorItem>();
        for (CashSourceMenu csm : csml) {
            boolean enable = true;
            if (csm.getCashSource() != null) {
                CashSource cashSource = this.csHolder.getItem(csm.getCashSource().getId());
                enable = cashSource.getCode().equals("KEEPER") || cashSource.getCode().equals("TERMINAL");
            }
            SelectorItem item = new SelectorItem(csm.getName(), csm.getName());
            HashMap<String, CashSourceMenu> d = new HashMap<String, CashSourceMenu>();
            d.put("csm", csm);
            item.setCustomData(d);
            item.setEnable(enable);
            list.add(item);
        }
        if (this.itemsCashSource != null) {
            this.itemsCashSource.clear();
            this.itemsCashSource.addAll(list);
        }
        if (csml == this.cashSourceMenu) {
            this.cashSourceScreenListener.init(null);
        }
        this.cashSourceScreenListener.init(csml);
        this.showOrCreate("selectCashSource", () -> this.modulelistener.getScreen("keeper/selector/cashsource"), () -> {
            ScreenDescription sd = this.modulelistener.getScreenDescription("forms/cashsource");
            SelectorField f = (SelectorField)sd.getSequence().getFields().get(0);
            this.itemsCashSource = f.getItems();
            this.itemsCashSource.clear();
            this.itemsCashSource.addAll(list);
            return sd;
        }, () -> this.cashSourceScreenListener);
    }

    private void successPayment() {
        this.showOrCreate("successPayment", () -> this.modulelistener.getScreen("keeper/success/payment"), null, () -> new KeeperScreenListener(this.modulelistener, this.log){

            @Override
            protected void onAction(String action, Map<String, Object> data) {
                switch (action) {
                    case "details": {
                        PaymentModule.this.showDetails();
                        break;
                    }
                    case "createTemplate": {
                        PaymentModule.this.inputTemplateName();
                        break;
                    }
                    case "createAutopay": {
                        break;
                    }
                    case "back": {
                        PaymentModule.this.back();
                    }
                }
            }
        });
    }

    private void showDetails() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("check", this.payment.getCheck());
        this.showOrCreate("successDetails", () -> this.modulelistener.getScreen("keeper/success/details"), null, () -> new KeeperScreenListener(this.modulelistener, this.log){

            @Override
            protected void onAction(String action, Map<String, Object> data) {
                switch (action) {
                    case "back": {
                        PaymentModule.this.successPayment();
                    }
                }
            }
        }, map);
    }

    protected void createTemplate(Map<String, Object> data) throws NumberFormatException {
        InputElement name = (InputElement)data.get("tpl.name");
        if (name != null) {
            this.modulelistener.execute(() -> Global.getInstance().createTemplate(this.payment.getOperation().getId(), name.getValue()), t -> {
                if (t.booleanValue()) {
                    Global.getInstance().getKeeperModule().getTemplateModule().templates();
                }
            }, e -> this.modulelistener.showDialog("system/error", i -> Global.getInstance().getKeeperModule().getTemplateModule().templates()));
        }
    }

    private void initSum(DTOPayment pay, ProcessingPaymentSource ps) {
        DTOSum sum = pay.getSum();
        ArrayList<DTOAttribute> sattrs = new ArrayList<DTOAttribute>();
        this.log.debug((Object)("cashSourceData: " + this.cashSourceData));
        for (Object ob : this.cashSourceData.values()) {
            InputElement ie = (InputElement)ob;
            if (ie.getKey().equals("cs.sum")) {
                sum.setOutcome(this.parseSum(ie.getValue()));
                continue;
            }
            if (ie.getKey().equals("cs.sumIn")) {
                sum.setIncome(this.parseSum(ie.getValue()));
                continue;
            }
            sattrs.add(new DTOAttribute(ie.getKey(), ie.getValue(), ie.getKeyTitle(), ie.getValueTitle()));
        }
        pay.setSystemAttributes(sattrs.isEmpty() ? null : sattrs);
        Service s = this.sHolder.getService(this.serviceId);
        CommissionHolder cHolder = ReferencesHelper.getInstance().getCommissionHolder();
        CommissionInfo commissionInfo = cHolder.getCommissionInfo(this.commissionProfileId);
        CommissionInfo minCommissionInfo = null;
        CommissionInfo maxCommissionInfo = null;
        if (s.getMinCommissionProfile() != null) {
            minCommissionInfo = cHolder.getCommissionInfo(s.getMinCommissionProfile().getId());
        }
        if (s.getMaxCommissionProfile() != null) {
            maxCommissionInfo = cHolder.getCommissionInfo(s.getMaxCommissionProfile().getId());
        }
        this.log.debug((Object)("sum:" + sum));
        this.log.debug((Object)("commissionInfo:" + commissionInfo));
        this.log.debug((Object)("minCommissionInfo:" + minCommissionInfo));
        this.log.debug((Object)("maxCommissionInfo:" + maxCommissionInfo));
        SumResult calcCommission = Global.getInstance().calcCommission(sum, commissionInfo, minCommissionInfo, maxCommissionInfo, ps.getId());
        sum.setOutcome(calcCommission.getOut());
        sum.setCommission(calcCommission.getCommission());
        sum.setIncome(calcCommission.getOut() + calcCommission.getCommission());
        this.log.debug((Object)("sum:" + sum));
    }

    protected void createPayment() {
        final DTOPayment pay = new DTOPayment();
        DTOAccount ac = new DTOAccount();
        String acc1 = null;
        String acc2 = null;
        ArrayList<DTOAttribute> attrs = new ArrayList<DTOAttribute>();
        for (InputElement ie : this.context.values()) {
            if (ie.getKey().equals("id1")) {
                acc1 = ie.getValue();
            } else if (ie.getKey().equals("id2")) {
                acc2 = ie.getValue();
            }
            attrs.add(new DTOAttribute(ie.getKey(), ie.getValue(), ie.getKeyTitle(), ie.getValueTitle()));
        }
        ac.setAccount(acc1);
        ac.setAccount2(acc2);
        ac.setAttributes(attrs);
        ac.setMenuItem(this.menuItemId.intValue());
        ac.setService(this.serviceId.shortValue());
        pay.setAccount(ac);
        DTOSum sum = new DTOSum();
        pay.setSum(sum);
        if (this.selectedCashSource.getCode().equals("TERMINAL")) {
            pay.setCashSource(this.csKeeper.getId().shortValue());
        } else {
            pay.setCashSource(this.selectedCashSource.getId().shortValue());
            this.initSum(pay, this.selectedCashSource.getProcessingPaymentSource());
        }
        DTOClientDescription clientDescription = Global.getInstance().getClientDescription();
        pay.setClientAccount(clientDescription.getAccount().getId().longValue());
        pay.setOperationType(this.operationTypeId.shortValue());
        pay.setCommissionProfile(this.commissionProfileId.shortValue());
        int operationNumber = 1;
        try {
            operationNumber = ReferencesHelper.getInstance().getSequence();
        }
        catch (IOException ex) {
            this.log.error((Object)("Sequence error:" + ex.getMessage()), (Throwable)ex);
        }
        pay.setOperationNumber(operationNumber);
        if (this.selectedCashSource.getCode().equals("TERMINAL")) {
            String d = Global.getInstance().getClientDescription().getClient().getLogin();
            this.modulelistener.receiptKeeper(null, d, this.sumFromForm, (AtmPaymentListener)new LocalAtmPaymentListener(this.modulelistener, this.log){

                public void onPay(int sumOutcome) {
                    PaymentModule.this.log.debug((Object)"-------------------------------------------------");
                    PaymentModule.this.log.debug((Object)"receiptKeeper AtmPaymentListener.onPay()");
                    PaymentModule.this.log.debug((Object)("Cash sumOut:" + sumOutcome));
                    if (PaymentModule.this.sumFromForm != null) {
                        InputElement ie = new InputElement("cs.sum", null, PaymentModule.this.formatSum(PaymentModule.this.sumFromForm));
                        PaymentModule.this.cashSourceData.put("cs.sum", ie);
                    } else {
                        InputElement ie = new InputElement("cs.sumIn", null, PaymentModule.this.formatSum(sumOutcome));
                        PaymentModule.this.cashSourceData.put("cs.sumIn", ie);
                    }
                    PaymentModule.this.initSum(pay, PaymentModule.this.csKeeper.getProcessingPaymentSource());
                    PaymentModule.this.doPayment(pay);
                }
            });
        } else {
            this.doPayment(pay);
        }
    }

    private void doPayment(DTOPayment pay) {
        this.log.debug((Object)("pay:" + pay));
        this.modulelistener.execute(() -> Global.getInstance().doPayment(pay), t -> {
            this.payment = t;
            this.log.debug((Object)("payment:" + this.payment));
            Global.getInstance().getKeeperModule().getHomeModule().onLogin(null);
            this.successPayment();
        }, e -> {
            this.log.error((Object)("Payment error:" + e.getMessage()), (Throwable)e);
            this.modulelistener.addDataItem("fail_message", (Object)e.getMessage());
            this.modulelistener.showDialog("login/fail", i -> this.back());
        });
    }

    abstract class LocalAtmPaymentListener
    extends KeeperScreenListener
    implements AtmPaymentListener {
        Runnable onPay;

        public LocalAtmPaymentListener(AtmAPI modulelistener, Logger log) {
            super(modulelistener, log);
        }

        public void onBack() {
            PaymentModule.this.log.debug((Object)"onBack()");
            PaymentModule.this.back();
        }

        public void onExit() {
            PaymentModule.this.log.debug((Object)"onExit()");
            this.onDefaultExit(null);
        }

        public void onAction(String action) {
            this.onAction(action, null, () -> {});
        }

        @Override
        protected void onAction(String action, Map<String, Object> data) {
            PaymentModule.this.log.debug((Object)("onAction():" + action));
        }
    }

    public class PaymentModuleAtmInputListener
    implements AtmInputListener {
        private final Runnable onBackHandler;

        public PaymentModuleAtmInputListener() {
            this.onBackHandler = null;
        }

        public PaymentModuleAtmInputListener(Runnable onBackHandler) {
            this.onBackHandler = onBackHandler;
        }

        public void onBack() {
            PaymentModule.this.log.debug((Object)"SERVICE: onBack()");
            PaymentModule.this.modulelistener.removeDataItem("service");
            if (this.onBackHandler != null) {
                this.onBackHandler.run();
            } else {
                PaymentModule.this.back();
            }
        }

        public void onExit() {
            PaymentModule.this.log.debug((Object)"SERVICE: onExit()");
            PaymentModule.this.modulelistener.removeDataItem("service");
            PaymentModule.this.back();
        }

        public void onPay(Map<String, InputElement> data, Short sid, Integer sum) {
            PaymentModule.this.log.debug((Object)("SERVICE: onPay():" + data));
            if (sid != null) {
                PaymentModule.this.log.debug((Object)("SERVICE change: " + sid));
                MenuItem item = PaymentModule.this.miHolder.findByServiceId(sid);
                if (item != null) {
                    PaymentModule.this.commissionProfileId = item.getCommissionProfile().getId();
                    PaymentModule.this.serviceId = sid;
                    PaymentModule.this.menuItemId = item.getId();
                    if (item.getOperationType() != null) {
                        PaymentModule.this.operationTypeId = item.getOperationType().getId();
                    } else {
                        MenuItem root = Global.getInstance().findMenuRoot("PAYMENT");
                        PaymentModule.this.operationTypeId = root.getOperationType().getId();
                    }
                    Integer get = (Integer)Global.getInstance().getClientDescription().getCashSourceMenuProfiles().get(PaymentModule.this.operationTypeId);
                    PaymentModule.this.cashSourceMenu = PaymentModule.this.csmHolder.getChildsByMenuProfile(get);
                    PaymentModule.this.log.debug((Object)("cashSourceMenu:" + PaymentModule.this.cashSourceMenu));
                } else {
                    PaymentModule.this.modulelistener.addDataItem("fail_message", (Object)"Menu item not found");
                    PaymentModule.this.modulelistener.showDialog("login/fail", i -> {
                        PaymentModule.this.log.debug((Object)("dialog result: " + i));
                        PaymentModule.this.back();
                    });
                    return;
                }
            }
            PaymentModule.this.sumFromForm = sum;
            PaymentModule.this.log.debug((Object)("sumFromForm:" + PaymentModule.this.sumFromForm));
            PaymentModule.this.context.clear();
            PaymentModule.this.context.putAll(data);
            PaymentModule.this.selectCashSource(PaymentModule.this.cashSourceMenu);
        }

        public void onAction(String action) {
            PaymentModule.this.log.debug((Object)("onAction: " + action));
            switch (action) {
                case "payment": {
                    Global.getInstance().getKeeperModule().getHomeModule().payment();
                    break;
                }
                case "transfer": {
                    Global.getInstance().getKeeperModule().getHomeModule().transfer();
                    break;
                }
                case "receipt": {
                    Global.getInstance().getKeeperModule().getHomeModule().receipt();
                    break;
                }
                case "home": {
                    Global.getInstance().getKeeperModule().getHomeModule().home();
                    break;
                }
                case "exit": {
                    Global.getInstance().getKeeperModule().exit();
                }
            }
        }

        public void onRedirect(int id) {
            PaymentModule.this.log.debug((Object)("SERVICE: onRedirect():" + id));
        }
    }

    class LocalCashSourceScreenListener
    extends KeeperScreenListener {
        private final Stack<List<CashSourceMenu>> stack;

        public LocalCashSourceScreenListener(AtmAPI modulelistener, Logger log) {
            super(modulelistener, log);
            this.stack = new Stack();
        }

        public void init(List<CashSourceMenu> current) {
            if (current == null) {
                this.stack.clear();
            } else {
                this.stack.push(current);
            }
        }

        @Override
        protected void onAction(String action, Map<String, Object> data) {
            switch (action) {
                case "next": {
                    CashSourceMenu csm = (CashSourceMenu)data.get("csm");
                    PaymentModule.this.log.debug((Object)("onAction():" + csm.getName()));
                    if (csm.getCashSource() != null) {
                        PaymentModule.this.selectedCashSource = PaymentModule.this.csHolder.getItem(csm.getCashSource().getId());
                        PaymentModule.this.inputSum();
                        break;
                    }
                    List<CashSourceMenu> childs = PaymentModule.this.csmHolder.getChilds(csm.getId());
                    PaymentModule.this.log.debug((Object)("childs:" + childs));
                    PaymentModule.this.selectCashSource(childs);
                    break;
                }
                case "prev": {
                    PaymentModule.this.log.debug((Object)("onAction(): prev" + this.stack));
                    if (!this.stack.isEmpty()) {
                        this.stack.pop();
                    }
                    if (!this.stack.isEmpty()) {
                        List<CashSourceMenu> l = this.stack.pop();
                        PaymentModule.this.log.debug((Object)("list:" + l));
                        PaymentModule.this.selectCashSource(l);
                        break;
                    }
                    Service s = PaymentModule.this.sHolder.getService(PaymentModule.this.serviceId);
                    PaymentModule.this.modulelistener.addDataItem("service", (Object)s);
                    PaymentModule.this.modulelistener.restoreInputModule(PaymentModule.this.inputListener);
                }
            }
        }
    }
}

