/*
 * Decompiled with CFR 0.152.
 */
package plfx.screen.input.keeper.module;

import java.util.Map;
import org.apache.log4j.Logger;
import plfx.GuiNotifier;
import plfx.screen.CommonScreen;
import plfx.screen.ScreenCreateException;
import plfx.screen.ScreenInit;
import plfx.screen.ScreenListener;
import plfx.screen.input.keeper.Global;
import ru.slkf.atm.AtmAPI;
import ru.softlogic.input.model.field.InitException;
import ru.softlogic.input.model.screen.description.ScreenDescription;

public abstract class KeeperScreenListener
implements ScreenListener {
    final AtmAPI modulelistener;
    final Logger log;

    public KeeperScreenListener(AtmAPI modulelistener, Logger log) {
        this.modulelistener = modulelistener;
        this.log = log;
    }

    protected abstract void onAction(String var1, Map<String, Object> var2);

    protected void onDefaultPayment(Map<String, Object> data) {
        Global.getInstance().getKeeperModule().getHomeModule().payment();
    }

    protected void onDefaultTransfer(Map<String, Object> data) {
        Global.getInstance().getKeeperModule().getHomeModule().transfer();
    }

    protected void onDefaultReceipt(Map<String, Object> data) {
        Global.getInstance().getKeeperModule().getHomeModule().receipt();
    }

    protected void onDefaultHome(Map<String, Object> data) {
        Global.getInstance().getKeeperModule().getHomeModule().home();
    }

    protected void onDefaultSetup(Map<String, Object> data) {
        Global.getInstance().getKeeperModule().getSetupModule().start();
    }

    protected void onDefaultExit(Map<String, Object> data) {
        Global.getInstance().getKeeperModule().logout(true);
    }

    public void onAction(String action, Map<String, Object> data, Runnable r) {
        this.log.debug((Object)"------------------------------------------------------");
        this.log.debug((Object)("onAction: " + action + ", Data:"));
        if (data != null) {
            data.entrySet().stream().forEach(p -> this.log.debug((Object)("    " + (String)p.getKey() + ":" + p.getValue())));
        } else {
            this.log.debug((Object)"    null");
        }
        switch (action) {
            case "payment": {
                this.onDefaultPayment(data);
                break;
            }
            case "transfer": {
                this.onDefaultTransfer(data);
                break;
            }
            case "receipt": {
                this.onDefaultReceipt(data);
                break;
            }
            case "home": {
                this.onDefaultHome(data);
                break;
            }
            case "setup": {
                this.onDefaultSetup(data);
                break;
            }
            case "exit": {
                this.onDefaultExit(data);
                break;
            }
            default: {
                this.onAction(action, data);
            }
        }
        r.run();
    }

    public void onSelectLang(String string) {
        this.log.debug((Object)("onSelectLang:" + string));
    }

    public void onNextLang() {
        this.log.debug((Object)"onNextLang:");
    }

    public void onSelectField(int i) {
        this.log.debug((Object)("onSelectField:" + i));
        this.modulelistener.setActiveField(i);
    }

    public void showPopup(ScreenDescription sd, ScreenInit si, ScreenListener listener) {
        this.log.info((Object)("showPopup: " + sd.getType()));
        try {
            CommonScreen cs = this.modulelistener.getScreen(sd.getType());
            if (cs != null) {
                cs.init(sd, si);
                this.modulelistener.showCustomScreen(cs, listener, 45);
            } else {
                GuiNotifier.notifyError((String)("Can't get screen for type: " + sd.getType()));
            }
        }
        catch (ScreenCreateException | InitException ex) {
            GuiNotifier.notifyError((Throwable)ex);
        }
    }

    public void setFieldPage(int index, int pageSize) {
        this.log.debug((Object)("setFieldPage:" + index + ", pageSize:" + pageSize));
        this.modulelistener.setFieldPage(index, pageSize);
    }

    public void notifyUpdate() {
        this.modulelistener.notifyUpdate();
    }
}

