/*
 * Decompiled with CFR 0.152.
 */
package plfx.screen.input.keeper.menu;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.apache.log4j.Logger;
import plfx.screen.TemplateCreateException;
import plfx.screen.input.keeper.Global;
import plfx.screen.input.keeper.menu.MenuPager;
import plfx.screen.input.keeper.menu.MenuPagesProvider;
import plfx.screen.input.keeper.module.KeeperDefaultModule;
import plfx.screen.input.keeper.module.KeeperMenuListener;
import plfx.screen.input.keeper.utils.MenuItemsHolder;
import plfx.screen.input.keeper.utils.ReferencesHelper;
import plfx.screen.input.keeper.utils.ServicesHolder;
import plfx.screen.menu.MenuTemplate;
import plfx.screen.menu.button.ActionListener;
import plfx.screen.menu.button.MenuButtonInit;
import ru.slkf.atm.AtmAPI;
import ru.softlogic.keeper.db.model.MenuItem;
import ru.softlogic.keeper.db.model.Service;

public class MenuPaymentModule
extends KeeperDefaultModule {
    private MenuTemplate menuMainTemplate;
    private MenuTemplate menuServiceTemplate;
    private LocalMenuPagesProvider mainMenuPagesProvider;
    private LocalMenuPagesProvider serviceMenuPagesProvider;
    private MenuItem root;
    private MenuItem current;
    private final Stack<MenuItem> stack = new Stack();
    private MenuPager mainPager;
    private MenuPager servicePager;
    private MenuItemsHolder miHolder = ReferencesHelper.getInstance().getMenuItemsHolder();
    private ServicesHolder sHolder = ReferencesHelper.getInstance().getServicesHolder();

    public MenuPaymentModule(AtmAPI modulelistener, Logger log) {
        super(modulelistener, log);
        try {
            this.menuMainTemplate = modulelistener.getMenuTemplate("payment/main");
            this.menuServiceTemplate = modulelistener.getMenuTemplate("payment/service");
            this.mainMenuPagesProvider = new LocalMenuPagesProvider();
            this.serviceMenuPagesProvider = new LocalMenuPagesProvider();
            LocalMenuTemplateListener lis = new LocalMenuTemplateListener(modulelistener, log);
            this.mainPager = new MenuPager(modulelistener, this.mainMenuPagesProvider, lis, "group", this.menuMainTemplate, this.menuMainTemplate.getGroupArea());
            this.servicePager = new MenuPager(modulelistener, this.serviceMenuPagesProvider, lis, "mixed", this.menuServiceTemplate, this.menuServiceTemplate.getMixedArea());
        }
        catch (TemplateCreateException ex) {
            log.error((Object)("Error get menu template:" + ex.getMessage()), (Throwable)ex);
        }
    }

    public void setRoot(MenuItem root) {
        this.log.debug((Object)("MenuPaymentModule setRoot:" + root));
        this.root = root;
    }

    @Override
    public void onStart(boolean timeout) {
        this.stack.clear();
        this.current = null;
        this.modulelistener.addDataItem("group_mode", (Object)"menu");
        this.inside(this.root);
    }

    @Override
    public void onFinish() {
        this.clearContext();
    }

    public void menu() {
        if (this.current.getLevel() == 0) {
            this.mainPager.show();
        } else {
            this.servicePager.show();
        }
    }

    private void inside(MenuItem item) {
        if (this.current != null) {
            this.stack.push(this.current);
        }
        this.current = item;
        this.modulelistener.addDataItem("group", (Object)this.current.getName());
        this.modulelistener.addDataItem("group_invite", (Object)this.current.getInvitation());
        if (this.current.getLevel() == 0) {
            this.mainMenuPagesProvider.setCurr(this.current);
            this.mainPager.firstPage();
        } else {
            this.serviceMenuPagesProvider.setCurr(this.current);
            this.servicePager.firstPage();
        }
        this.menu();
    }

    private void outside() {
        if (this.stack.isEmpty()) {
            this.exit(false);
        } else {
            this.current = null;
            this.inside(this.stack.pop());
        }
    }

    private void clearContext() {
        this.stack.clear();
    }

    private void root() {
        this.modulelistener.endPaymentSession();
        this.clearContext();
        this.inside(this.root);
    }

    private void exit(boolean timeout) {
        this.modulelistener.endPaymentSession();
        this.clearContext();
        this.current = null;
        this.root = null;
        Global.getInstance().getKeeperModule().logout(timeout);
    }

    @Override
    public void onTimeOut() {
        this.exit(true);
    }

    @Override
    public int getInactivityTimeout() {
        return 60;
    }

    class LocalMenuPagesProvider
    implements MenuPagesProvider {
        MenuItem curr;

        LocalMenuPagesProvider() {
        }

        public void setCurr(MenuItem curr) {
            this.curr = curr;
        }

        @Override
        public List<List<MenuButtonInit>> getPages(int pageSize) {
            MenuPaymentModule.this.log.debug((Object)"-------------------------------------------");
            MenuPaymentModule.this.log.debug((Object)("getPages pageSize: " + pageSize));
            ArrayList<List<MenuButtonInit>> res = new ArrayList<List<MenuButtonInit>>();
            List<MenuItem> childs = MenuPaymentModule.this.miHolder.getChilds(this.curr.getId());
            if (childs != null) {
                int i = 1;
                ArrayList<MenuButtonInit> list = null;
                for (MenuItem ch : childs) {
                    Service s;
                    if (list == null) {
                        list = new ArrayList<MenuButtonInit>(pageSize);
                    }
                    if (ch.getName().startsWith("#") || ch.getState() != 0 && ch.getState() != 3) continue;
                    String img = null;
                    if (ch.getService() != null && (s = MenuPaymentModule.this.sHolder.getService(ch.getService().getId())) != null) {
                        img = s.getImage2();
                    }
                    if (img == null && ch.getImage2() != null) {
                        img = ch.getImage2();
                    }
                    String type = null;
                    String style = "";
                    String desc = null;
                    boolean disable = false;
                    MenuButtonInit bi = new MenuButtonInit(type, ch.getName(), img, style, desc, disable, (ActionListener)new LocalMenuButtonActionListener(ch));
                    MenuPaymentModule.this.log.debug((Object)("MenuButtonInit: " + bi));
                    list.add(bi);
                    if (++i <= pageSize) continue;
                    res.add(list);
                    i = 0;
                    list = null;
                }
                if (list != null) {
                    res.add(list);
                }
            } else {
                res.add(new ArrayList());
            }
            return res;
        }
    }

    class LocalMenuTemplateListener
    extends KeeperMenuListener {
        public LocalMenuTemplateListener(AtmAPI modulelistener, Logger log) {
            super(modulelistener, log);
        }

        @Override
        protected void onAction(String id, Map<String, Object> data) {
            MenuPaymentModule.this.log.debug((Object)("MenuPaymentModule onAction():" + id));
            switch (id) {
                case "history": 
                case "historyIcon": {
                    Global.getInstance().getKeeperModule().getHistoryModule().start();
                    break;
                }
                case "templates": 
                case "templatesIcon": {
                    Global.getInstance().getKeeperModule().getTemplateModule().start();
                    break;
                }
                case "searchProvider": 
                case "searchProviderIcon": {
                    Global.getInstance().getKeeperModule().getMenuSearchModule().start();
                    break;
                }
                case "back": {
                    MenuPaymentModule.this.outside();
                }
            }
        }
    }

    class LocalMenuButtonActionListener
    implements ActionListener {
        private final MenuItem item;

        public LocalMenuButtonActionListener(MenuItem item) {
            this.item = item;
        }

        public void onAction() {
            MenuPaymentModule.this.log.debug((Object)("onAction():" + this.item.getName()));
            if (this.item.getService() != null) {
                Global.getInstance().getKeeperModule().getPaymentModule().payment(this.item);
            } else {
                MenuPaymentModule.this.inside(this.item);
            }
        }
    }
}

