/*
 * Decompiled with CFR 0.152.
 */
package plfx.screen.input.keeper.menu;

import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import plfx.element.ButtonListener;
import plfx.element.SButton;
import plfx.screen.input.keeper.menu.MenuPagesProvider;
import plfx.screen.menu.MenuTemplate;
import plfx.screen.menu.MenuTemplateListener;
import plfx.screen.menu.area.ButtonArea;
import plfx.screen.menu.button.MenuButtonInit;
import ru.slkf.atm.AtmAPI;

public class MenuPager {
    AtmAPI modulelistener;
    MenuPagesProvider pagesProvider;
    String prefix;
    MenuTemplate menuTemplate;
    MenuTemplateListener listener;
    ButtonArea area;
    SButton prevButton;
    SButton nextButton;
    List<List<MenuButtonInit>> pages;
    int page;

    public MenuPager(AtmAPI modulelistener, MenuPagesProvider pagesProvider, MenuTemplateListener lis, String prefix, MenuTemplate menuTemplate, ButtonArea area) {
        this.modulelistener = modulelistener;
        this.pagesProvider = pagesProvider;
        this.prefix = prefix;
        this.menuTemplate = menuTemplate;
        this.listener = lis;
        this.area = area;
        this.prevButton = menuTemplate.getPrevButton();
        this.nextButton = menuTemplate.getNextButton();
        Optional.ofNullable(this.prevButton).ifPresent(n -> n.setListener((ButtonListener)new PaginatorListener("prev")));
        Optional.ofNullable(this.nextButton).ifPresent(n -> n.setListener((ButtonListener)new PaginatorListener("next")));
    }

    public void firstPage() {
        this.pages = this.pagesProvider.getPages(this.area.getCapacity());
        this.page = 0;
    }

    public void show() {
        this.initPage();
        this.menuTemplate.initAreas();
        this.menuTemplate.setListener(this.listener);
        this.modulelistener.showMenuTemplate(this.menuTemplate);
    }

    private void initPage() {
        List<MenuButtonInit> list = this.pages.get(this.page);
        this.area.fill(list);
        HashMap titles = new HashMap();
        int l = list.size();
        for (int i = 0; i < l; ++i) {
            HashMap<String, String> lang = new HashMap<String, String>();
            lang.put(this.modulelistener.getLocale().getLanguage(), list.get(i).getText());
            titles.put(this.prefix + i, lang);
        }
        this.modulelistener.setMenuTitles(titles);
        int cnt = this.pages.size();
        boolean canPrev = this.page > 0;
        boolean canNext = this.page + 1 < cnt;
        Optional.ofNullable(this.prevButton).ifPresent(n -> n.setVisible(canPrev));
        Optional.ofNullable(this.nextButton).ifPresent(n -> n.setVisible(canNext));
    }

    public void next() {
        int cnt = this.pages.size();
        if (this.page + 1 < cnt) {
            ++this.page;
            this.show();
        }
    }

    public void prev() {
        if (this.page > 0) {
            --this.page;
            this.show();
        }
    }

    class PaginatorListener
    implements ButtonListener {
        private final String id;

        public PaginatorListener(String id) {
            this.id = id;
        }

        public void onAction() {
            switch (this.id) {
                case "prev": {
                    MenuPager.this.prev();
                    break;
                }
                case "next": {
                    MenuPager.this.next();
                }
            }
        }
    }
}

