/*
 * Decompiled with CFR 0.152.
 */
package plfx.screen.input.keeper.login;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import plfx.screen.input.keeper.Global;
import plfx.screen.input.keeper.module.KeeperDefaultModule;
import plfx.screen.input.keeper.module.KeeperScreenListener;
import ru.slkf.atm.AtmAPI;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.keeper.api.model.client.DTORegistrationInfo;
import ru.softlogic.keeper.api.model.client.domain.DTOClientDescription;
import ru.softlogic.keeper.api.model.client.domain.DTOLoginPin;
import ru.softlogic.keeper.api.model.client.domain.DTOSecureLogin;
import ru.softlogic.smartkeeper.api.exception.KeeperApiException;

public class AuthModule
extends KeeperDefaultModule {
    private DTOLoginPin savedLoginPin;
    private InputElement savedLogin;
    private InputElement savedPassword;
    private DTORegistrationInfo savedRegPin;
    private PinMode pinMode;
    private RecoverFrom recoverFrom;
    private boolean showLoginPopup;

    public AuthModule(AtmAPI modulelistener, Logger log) {
        super(modulelistener, log);
    }

    @Override
    public void onStart(boolean timeout) {
        this.showLoginPopup = !timeout;
        this.login(null);
    }

    @Override
    public void onFinish() {
        this.resetData();
    }

    private void resetData() {
        this.savedLoginPin = null;
        this.savedPassword = null;
        this.savedLogin = null;
        this.savedRegPin = null;
        this.pinMode = null;
        this.recoverFrom = null;
    }

    protected void login(InputElement input) {
        this.resetData();
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (input != null) {
            this.savedLogin = input;
        }
        map.put("selectFirstField", this.showLoginPopup);
        if (this.showLoginPopup) {
            this.showLoginPopup = false;
        }
        this.showOrCreate("login", () -> this.modulelistener.getScreen("keeper/auth/login"), () -> this.modulelistener.getScreenDescription("forms/auth/login"), () -> new KeeperScreenListener(this.modulelistener, this.log){

            @Override
            protected void onDefaultExit(Map<String, Object> data) {
                Global.getInstance().getKeeperModule().exit();
            }

            @Override
            protected void onAction(String action, Map<String, Object> data) {
                switch (action) {
                    case "recoverStart": {
                        AuthModule.this.recoverFrom = RecoverFrom.Login;
                        AuthModule.this.recover((InputElement)data.get("login"));
                        break;
                    }
                    case "next": {
                        AuthModule.this.savedLogin = (InputElement)data.get("login");
                        AuthModule.this.modulelistener.execute(() -> {
                            String login = AuthModule.this.savedLogin.getValue();
                            return Global.getInstance().isExist(login);
                        }, exist -> {
                            if (exist.booleanValue()) {
                                AuthModule.this.password(null);
                            } else {
                                AuthModule.this.modulelistener.execute(() -> {
                                    String login = AuthModule.this.savedLogin.getValue();
                                    return Global.getInstance().doRegister(login);
                                }, reg -> {
                                    String codeRegLogic;
                                    switch (codeRegLogic = reg.getCodeRegLogic()) {
                                        case "Auto": {
                                            String smsId = reg.getCode();
                                            AuthModule.this.password(smsId);
                                            break;
                                        }
                                        case "Manual": {
                                            AuthModule.this.modulelistener.showDialog("register/manual", i -> {
                                                AuthModule.this.log.debug((Object)("dialog result: " + i));
                                                AuthModule.this.login(AuthModule.this.savedLogin);
                                            });
                                            break;
                                        }
                                        case "PinAccept": {
                                            AuthModule.this.savedRegPin = reg;
                                            AuthModule.this.pin((DTORegistrationInfo)reg);
                                        }
                                    }
                                }, ex -> AuthModule.this.onException(ex));
                            }
                        }, ex -> AuthModule.this.onException(ex));
                    }
                }
            }
        }, map);
    }

    protected void password(String smsId) {
        if (smsId != null) {
            this.modulelistener.addDataItem("register_smsid", (Object)smsId);
        } else {
            this.modulelistener.removeDataItem("register_smsid");
        }
        this.showOrCreate("password", () -> this.modulelistener.getScreen("keeper/auth/password"), () -> this.modulelistener.getScreenDescription("forms/auth/password"), () -> new KeeperScreenListener(this.modulelistener, this.log){

            @Override
            protected void onDefaultExit(Map<String, Object> data) {
                AuthModule.this.login(AuthModule.this.savedLogin);
            }

            @Override
            protected void onAction(String action, Map<String, Object> data) {
                switch (action) {
                    case "recoverStart": {
                        AuthModule.this.recoverFrom = RecoverFrom.Password;
                        AuthModule.this.recover(AuthModule.this.savedLogin);
                        break;
                    }
                    case "next": {
                        AuthModule.this.savedPassword = (InputElement)data.get("password");
                        AuthModule.this.modulelistener.execute(() -> {
                            String login = AuthModule.this.savedLogin.getValue();
                            String password = AuthModule.this.savedPassword.getValue();
                            DTOSecureLogin resp = Global.getInstance().doLogin(login, password);
                            if (resp.getDtoClientDescription() != null) {
                                AuthModule.this.backgroundTaskOnSuccessAuth();
                            }
                            return resp;
                        }, login -> {
                            if (login.getDtoClientDescription() != null) {
                                AuthModule.this.successAuth(login.getDtoClientDescription());
                            } else {
                                AuthModule.this.savedLoginPin = login.getDtoPin();
                                AuthModule.this.pin(login.getDtoPin());
                            }
                        }, ex -> AuthModule.this.onException(ex));
                    }
                }
            }
        });
    }

    public void recover(InputElement input) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        this.savedLogin = input;
        if (input != null) {
            map.put("login", input);
        }
        this.showOrCreate("recover", () -> this.modulelistener.getScreen("keeper/auth/recover"), () -> this.modulelistener.getScreenDescription("forms/auth/recover"), () -> new KeeperScreenListener(this.modulelistener, this.log){

            @Override
            protected void onDefaultExit(Map<String, Object> data) {
                Global.getInstance().getKeeperModule().exit();
            }

            @Override
            protected void onAction(String action, Map<String, Object> data) {
                switch (action) {
                    case "back": {
                        switch (AuthModule.this.recoverFrom) {
                            case Login: {
                                AuthModule.this.login(AuthModule.this.savedLogin);
                                break;
                            }
                            case Password: {
                                AuthModule.this.password(null);
                            }
                        }
                        break;
                    }
                    case "next": {
                        AuthModule.this.modulelistener.execute(() -> {
                            AuthModule.this.savedLogin = (InputElement)data.get("login");
                            String login = AuthModule.this.savedLogin.getValue();
                            String secret = ((InputElement)data.get("password")).getValue();
                            return Global.getInstance().doRecover(login, secret);
                        }, smsId -> {
                            AuthModule.this.modulelistener.addDataItem("recover_smsid", smsId);
                            AuthModule.this.modulelistener.showDialog("recover/sms", i -> {
                                AuthModule.this.log.debug((Object)("dialog result: " + i));
                                AuthModule.this.password((String)smsId);
                            });
                        }, ex -> AuthModule.this.onException(ex));
                    }
                }
            }
        }, map);
    }

    private void showPin() {
        this.showOrCreate("pin", () -> this.modulelistener.getScreen("keeper/auth/pin"), () -> this.modulelistener.getScreenDescription("forms/auth/pin"), () -> new KeeperScreenListener(this.modulelistener, this.log){

            @Override
            protected void onDefaultExit(Map<String, Object> data) {
                Global.getInstance().getKeeperModule().exit();
            }

            @Override
            protected void onAction(String action, Map<String, Object> data) {
                block4 : switch (action) {
                    case "back": {
                        AuthModule.this.start();
                        break;
                    }
                    case "next": {
                        switch (AuthModule.this.pinMode) {
                            case Auth: {
                                AuthModule.this.modulelistener.execute(() -> {
                                    InputElement pin = (InputElement)data.get("pin");
                                    AuthModule.this.log.debug((Object)("pin: " + pin.getValue()));
                                    DTOClientDescription resp = Global.getInstance().doLoginPin(AuthModule.this.savedLoginPin, AuthModule.this.savedLogin.getValue(), AuthModule.this.savedPassword.getValue(), pin.getValue());
                                    if (resp != null) {
                                        AuthModule.this.backgroundTaskOnSuccessAuth();
                                    }
                                    return resp;
                                }, loginData -> {
                                    if (loginData != null) {
                                        AuthModule.this.successAuth(loginData);
                                    }
                                }, ex -> AuthModule.this.onException(ex));
                                break block4;
                            }
                            case Register: {
                                AuthModule.this.modulelistener.execute(() -> {
                                    InputElement pin = (InputElement)data.get("pin");
                                    AuthModule.this.log.debug((Object)("pin: " + pin.getValue()));
                                    Boolean resp = Global.getInstance().doRegisterPin(AuthModule.this.savedRegPin, pin.getValue());
                                    return resp;
                                }, res -> {
                                    String smsId = AuthModule.this.savedRegPin.getCode2();
                                    AuthModule.this.password(smsId);
                                }, ex -> AuthModule.this.onException(ex));
                            }
                        }
                    }
                }
            }
        });
    }

    public void pin(DTOLoginPin loginPin) {
        this.pinMode = PinMode.Auth;
        this.modulelistener.addDataItem("pin_smsid", (Object)loginPin.getMsgCode());
        this.showPin();
    }

    public void pin(DTORegistrationInfo regPin) {
        this.pinMode = PinMode.Register;
        this.modulelistener.addDataItem("pin_smsid", (Object)regPin.getCode());
        this.showPin();
    }

    @Override
    public void onTimeOut() {
        if (this.isCurrent("login")) {
            Global.getInstance().getKeeperModule().exit();
        } else {
            this.login(null);
        }
    }

    private void backgroundTaskOnSuccessAuth() throws Exception {
        Global.getInstance().getKeeperModule().getMenuReceiptModule().setPoints(Global.getInstance().doGetPoints());
    }

    private void successAuth(DTOClientDescription loginData) {
        if (loginData.isHasClientSecretKey()) {
            Global.getInstance().getKeeperModule().getHomeModule().onLogin(loginData);
            Global.getInstance().getKeeperModule().getHomeModule().start();
        } else {
            this.enterSecret();
        }
    }

    private void enterSecret() {
        this.showOrCreate("pin", () -> this.modulelistener.getScreen("keeper/auth/secret"), () -> this.modulelistener.getScreenDescription("forms/auth/secret"), () -> new KeeperScreenListener(this.modulelistener, this.log){

            @Override
            protected void onDefaultExit(Map<String, Object> data) {
                Global.getInstance().getKeeperModule().exit();
            }

            @Override
            protected void onAction(String action, Map<String, Object> data) {
                switch (action) {
                    case "back": {
                        Global.getInstance().getKeeperModule().logout(false);
                        break;
                    }
                    case "next": {
                        String secret = ((InputElement)data.get("secret")).getValue();
                        String secret2 = ((InputElement)data.get("secret2")).getValue();
                        if (secret.equals(secret2)) {
                            AuthModule.this.saveSecret(secret);
                            break;
                        }
                        AuthModule.this.modulelistener.showDialog("auth/secretdiff", i -> AuthModule.this.enterSecret());
                    }
                }
            }
        });
    }

    private void saveSecret(String value) {
        this.modulelistener.execute(() -> Global.getInstance().setSecret(value), res -> {
            if (res.booleanValue()) {
                Global.getInstance().getClientDescription().setHasClientSecretKey(true);
                this.successAuth(Global.getInstance().getClientDescription());
            } else {
                this.modulelistener.showDialog("auth/secretfail", i -> Global.getInstance().getKeeperModule().logout(false));
            }
        }, e -> this.onException((Exception)e));
    }

    private void onException(Exception ex) {
        String dialog;
        boolean fatal = false;
        if (ex instanceof KeeperApiException) {
            KeeperApiException e = (KeeperApiException)((Object)ex);
            dialog = "login/fail";
            this.modulelistener.addDataItem("fail_message", (Object)e.getMessage());
            this.log.debug((Object)("code: " + e.getMessageCode()));
            this.log.error((Object)("Login error:" + e.getMessage()), (Throwable)ex);
        } else if (ex instanceof IOException) {
            dialog = "system/noconnect";
        } else {
            dialog = "system/error";
            fatal = true;
        }
        if (fatal) {
            this.modulelistener.showDialog(dialog, i -> {
                this.log.debug((Object)("dialog result: " + i));
                Global.getInstance().getKeeperModule().exit();
            });
        } else {
            this.modulelistener.showDialog(dialog, i -> this.log.debug((Object)("dialog result: " + i)));
        }
    }

    private static enum RecoverFrom {
        Login,
        Password;

    }

    private static enum PinMode {
        Auth,
        Register;

    }
}

