/*
 * Decompiled with CFR 0.152.
 */
package plfx.screen.input.keeper.init;

import java.util.Map;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import org.apache.log4j.Logger;
import plfx.screen.input.keeper.Global;
import plfx.screen.input.keeper.ReferenceUpdater;
import plfx.screen.input.keeper.module.KeeperDefaultModule;
import plfx.screen.input.keeper.module.KeeperLogicModule;
import plfx.screen.input.keeper.module.KeeperScreenListener;
import ru.slkf.atm.AtmAPI;

public class InitModule
extends KeeperDefaultModule
implements KeeperLogicModule {
    private final ReferenceUpdater referenceUpdater;
    private final LocalChangeListener localChangeListener;
    private final Object lock = new Object();
    private boolean stoped;
    private final BooleanProperty done = new SimpleBooleanProperty(false);

    public InitModule(ReferenceUpdater updater, AtmAPI listener, Logger l) {
        super(listener, l);
        this.referenceUpdater = updater;
        this.localChangeListener = new LocalChangeListener();
    }

    @Override
    public void onStart(boolean timeout) {
        boolean ready = true;
        this.stoped = false;
        if (!this.referenceUpdater.isReady()) {
            this.log.debug((Object)"INITMODULE referenceUpdater not ready");
            ready = false;
        }
        if (!Global.getInstance().getKeeperModule().isReady()) {
            this.log.debug((Object)"INITMODULE KeeperModule not ready");
            ready = false;
        }
        if (!ready) {
            this.done.bind((ObservableValue)Global.getInstance().getKeeperModule().getReadyProperty().and((ObservableBooleanValue)this.referenceUpdater.getReadyProperty()));
            this.done.addListener((ChangeListener)this.localChangeListener);
            this.showOrCreate("init", () -> this.modulelistener.getScreen("keeper/init"), null, () -> new KeeperScreenListener(this.modulelistener, this.log){

                @Override
                protected void onAction(String action, Map<String, Object> data) {
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                protected void onDefaultExit(Map<String, Object> data) {
                    Object object = InitModule.this.lock;
                    synchronized (object) {
                        InitModule.this.setStoped(true);
                        InitModule.this.done.removeListener((ChangeListener)InitModule.this.localChangeListener);
                        if (!InitModule.this.done.getValue().booleanValue()) {
                            Global.getInstance().getKeeperModule().exit();
                        }
                    }
                }
            });
        } else {
            this.runKeeper();
        }
    }

    private void runKeeper() {
        Global.getInstance().getKeeperModule().getAuthModule().start();
    }

    @Override
    public int getInactivityTimeout() {
        return 60;
    }

    @Override
    public void onTimeOut() {
        this.setStoped(true);
        this.done.removeListener((ChangeListener)this.localChangeListener);
        Global.getInstance().getKeeperModule().exit();
    }

    @Override
    public void onFinish() {
    }

    private boolean isStoped() {
        return this.stoped;
    }

    private void setStoped(boolean stoped) {
        this.stoped = stoped;
    }

    private class LocalChangeListener
    implements ChangeListener<Boolean> {
        private LocalChangeListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
            InitModule.this.log.debug((Object)("changed: " + newValue));
            if (newValue.booleanValue()) {
                Object object = InitModule.this.lock;
                synchronized (object) {
                    InitModule.this.log.debug((Object)"remove listener");
                    InitModule.this.done.removeListener((ChangeListener)this);
                    if (!InitModule.this.isStoped()) {
                        InitModule.this.log.debug((Object)"doLogin");
                        Platform.runLater(() -> InitModule.this.runKeeper());
                    }
                }
                InitModule.this.log.debug((Object)"------");
            }
        }
    }
}

