/*
 * Decompiled with CFR 0.152.
 */
package plfx.screen.input.keeper.history;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.log4j.Logger;
import plfx.screen.input.keeper.Global;
import plfx.screen.input.keeper.LazyDataProvider;
import plfx.screen.input.keeper.history.HistoryDataProvider;
import plfx.screen.input.keeper.module.KeeperDefaultModule;
import plfx.screen.input.keeper.module.KeeperScreenListener;
import plfx.screen.input.keeper.utils.MathUtils;
import plfx.screen.input.keeper.utils.ReferencesHelper;
import ru.slkf.atm.AtmAPI;
import ru.softlogic.keeper.api.model.DTOVHistory;
import ru.softlogic.keeper.db.model.OperationAttribute;
import ru.softlogic.keeper.db.model.Service;

public class HistoryModule
extends KeeperDefaultModule {
    private Set<DTOVHistory> operationsStorage;
    private List<DTOVHistory> operations;
    private HistoryDataProvider dataProvider;
    private short pageSize = (short)-1;
    private int page;

    public HistoryModule(AtmAPI modulelistener, Logger log) {
        super(modulelistener, log);
    }

    @Override
    public void onStart(boolean timeout) {
        this.setSection("payment");
        if (this.operationsStorage == null) {
            this.operationsStorage = new TreeSet<DTOVHistory>((o1, o2) -> {
                int r = o1.getOperation().getId().compareTo(o2.getOperation().getId());
                return r < 0 ? 1 : (r > 0 ? -1 : 0);
            });
        }
        if (this.dataProvider == null) {
            this.dataProvider = new HistoryDataProvider(this.operationsStorage, 10, true, new LazyDataProvider.ProxyDataProvider(){

                @Override
                public List getDataAfter(Long lastId, short pageSize) {
                    ArrayList<DTOVHistory> res = null;
                    Collection<DTOVHistory> doHistoryLast = Global.getInstance().doHistoryLast(lastId, pageSize);
                    if (doHistoryLast != null) {
                        res = new ArrayList<DTOVHistory>();
                        res.addAll(doHistoryLast);
                    }
                    return res;
                }

                @Override
                public List getData(int page, short pageSize) {
                    ArrayList<DTOVHistory> res = null;
                    Collection<DTOVHistory> doHistory = Global.getInstance().doHistory(page, pageSize, null, null);
                    if (doHistory != null) {
                        res = new ArrayList<DTOVHistory>();
                        res.addAll(doHistory);
                    }
                    return res;
                }
            });
        }
        this.page = 0;
        this.list(-1, 0);
    }

    @Override
    public void onFinish() {
        this.operationsStorage = null;
        this.dataProvider = null;
    }

    private void exit() {
        Global.getInstance().getKeeperModule().getHomeModule().start();
    }

    private void repeat(DTOVHistory pay) {
        this.log.debug((Object)("pay:" + pay));
        for (OperationAttribute attr : pay.getAttributes()) {
            this.log.debug((Object)"--------------");
            this.log.debug((Object)("name:" + attr.getName()));
            this.log.debug((Object)("title:" + attr.getTitle()));
            this.log.debug((Object)("value:" + attr.getValue()));
            this.log.debug((Object)("view:" + attr.getView()));
        }
        Global.getInstance().getKeeperModule().getPaymentModule().payment(pay);
    }

    @Override
    public void onTimeOut() {
        this.exit();
    }

    private void list(int p, int shift) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        List ops = this.dataProvider.getData(p + shift, this.pageSize > 0 ? (short)this.pageSize : (short)10);
        boolean nextDisable = true;
        if (ops != null) {
            this.page = p >= 0 ? p + shift : 0;
            nextDisable = this.dataProvider.getData(this.page + 1, this.pageSize > 0 ? (short)this.pageSize : (short)10) == null;
            this.operations = ops;
        }
        map.put("prevDisable", this.page == 0);
        map.put("nextDisable", nextDisable);
        SimpleDateFormat df = new SimpleDateFormat("d MMMM");
        ArrayList pays = new ArrayList();
        if (this.operations != null) {
            for (DTOVHistory op : this.operations) {
                Service s = ReferencesHelper.getInstance().getServicesHolder().getService(op.getOperation().getService().getId());
                HashMap<String, Object> pay = new HashMap<String, Object>();
                pay.put("title", s.getName());
                pay.put("date", df.format(op.getOperation().getDateAdd()));
                pay.put("sum", MathUtils.formatMoney(op.getOperation().getSumOut().intValue()));
                Boolean st = null;
                if (op.getOperation().getState() == 6) {
                    st = true;
                } else if (op.getOperation().getState() == 8) {
                    st = false;
                }
                pay.put("state", st);
                pay.put("object", op);
                pays.add(pay);
            }
        }
        map.put("paymentsHistory", pays);
        this.showOrCreate("paymentsHistory", () -> this.modulelistener.getScreen("keeper/history"), null, () -> new KeeperScreenListener(this.modulelistener, this.log){

            @Override
            protected void onAction(String action, Map<String, Object> data) {
                switch (action) {
                    case "repeatPayment": {
                        DTOVHistory pay = (DTOVHistory)data.get("object");
                        HistoryModule.this.repeat(pay);
                        break;
                    }
                    case "prevPage": {
                        Short ps;
                        if (HistoryModule.this.pageSize == -1 && (ps = (Short)data.get("pageSize")) != null) {
                            HistoryModule.this.pageSize = ps;
                        }
                        if (HistoryModule.this.page <= 0) break;
                        HistoryModule.this.list(HistoryModule.this.page, -1);
                        break;
                    }
                    case "nextPage": {
                        Short ps;
                        if (HistoryModule.this.pageSize == -1 && (ps = (Short)data.get("pageSize")) != null) {
                            HistoryModule.this.pageSize = ps;
                        }
                        HistoryModule.this.list(HistoryModule.this.page, 1);
                        break;
                    }
                    case "back": {
                        this.onDefaultHome(data);
                    }
                }
            }
        }, map);
    }
}

