/*
 * Decompiled with CFR 0.152.
 */
package plfx.screen.input.keeper;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import plfx.screen.input.keeper.DataProvider;

public abstract class LazyDataProvider
implements DataProvider {
    private final Set<Object> data;
    private final short portion;
    private final boolean refreshHead;
    private final ProxyDataProvider proxy;
    private Long lastId = null;
    private boolean reachBegin = false;
    private boolean reachEnd = false;

    public LazyDataProvider(Set<Object> data, short portion, boolean refreshHead, ProxyDataProvider proxy) {
        this.data = data;
        this.portion = portion;
        this.refreshHead = refreshHead;
        this.proxy = proxy;
    }

    protected abstract Long getLastId();

    public void clear() {
        this.reachBegin = false;
        this.reachEnd = false;
        this.data.clear();
        this.lastId = null;
    }

    @Override
    public List getData(int page, short pageSize) {
        int have;
        int ask;
        int p;
        List newPortion = null;
        int n = p = page < 0 ? 0 : page;
        if (this.refreshHead && (page == -1 || page == 0 && !this.reachBegin)) {
            if (this.lastId != null) {
                newPortion = this.proxy.getDataAfter(this.lastId, this.portion);
                this.reachBegin = newPortion.isEmpty();
            } else {
                newPortion = this.proxy.getData(0, this.portion);
            }
        } else if (p >= 0 && (ask = (p + 1) * pageSize) > (have = this.data.size()) && !this.reachEnd) {
            int needPage = ask / this.portion + (ask % this.portion > 0 ? 1 : 0);
            newPortion = this.proxy.getData(needPage - 1, this.portion);
            boolean bl = this.reachEnd = newPortion.size() < this.portion;
        }
        if (newPortion != null && !newPortion.isEmpty()) {
            this.data.addAll(newPortion);
            this.lastId = this.getLastId();
        }
        have = this.data.size();
        ask = p * pageSize;
        int can = Math.min(have - ask, pageSize);
        ArrayList<Object> res = null;
        if (can > 0) {
            res = new ArrayList<Object>();
            Object[] ar = this.data.toArray();
            for (int i = 0; i < can; ++i) {
                res.add(ar[ask + i]);
            }
        }
        return res;
    }

    public boolean isReachBegin() {
        return this.reachBegin;
    }

    public boolean isReachEnd() {
        return this.reachEnd;
    }

    public static interface ProxyDataProvider
    extends DataProvider {
        public List getDataAfter(Long var1, short var2);
    }
}

