/*
 * Decompiled with CFR 0.152.
 */
package plfx.screen.input.keeper;

import java.io.File;
import java.util.Properties;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import org.apache.log4j.Logger;
import plfx.keeper.model.MapRegistry;
import plfx.screen.input.keeper.Global;
import plfx.screen.input.keeper.KeeperApiModuleImpl;
import plfx.screen.input.keeper.ReferenceUpdater;
import plfx.screen.input.keeper.history.HistoryModule;
import plfx.screen.input.keeper.home.HomeModule;
import plfx.screen.input.keeper.init.InitModule;
import plfx.screen.input.keeper.login.AuthModule;
import plfx.screen.input.keeper.menu.MenuPaymentModule;
import plfx.screen.input.keeper.menu.MenuReceiptModule;
import plfx.screen.input.keeper.menu.MenuSearchModule;
import plfx.screen.input.keeper.menu.MenuSelectModule;
import plfx.screen.input.keeper.module.KeeperLogicModule;
import plfx.screen.input.keeper.payment.PaymentModule;
import plfx.screen.input.keeper.receipt.ReceiptModule;
import plfx.screen.input.keeper.setup.SetupModule;
import plfx.screen.input.keeper.template.TemplateModule;
import plfx.screen.input.keeper.utils.ReferencesHelper;
import ru.slkf.KeeperModule;
import ru.slkf.api.KeeperApiModule;
import ru.slkf.atm.AtmAPI;

public class KeeperModuleImpl
implements KeeperModule {
    private static final String KEEPER_CONFIG_PARAM_WORKDIR = "keeper.workdir";
    private static final String KEEPER_CONFIG_PARAM_IMGDIR = "keeper.images";
    private static final String KEEPER_CONFIG_PARAM_BASEURL = "keeper.baseurl";
    Properties properties;
    File workPath;
    private Thread thread;
    private final AtmAPI modulelistener;
    private final Logger log = Logger.getLogger((String)"keeper");
    private final ReferenceUpdater referenceUpdater;
    private final BooleanProperty ready = new SimpleBooleanProperty(false);
    private final Object lock = new Object();
    private final KeeperApiModule apiModule;
    private KeeperLogicModule currentModule;
    private InitModule initModule;
    private AuthModule authModule;
    private HomeModule homeModule;
    private MenuPaymentModule menuPaymentModule;
    private MenuReceiptModule menuReceiptModule;
    private MenuSearchModule menuSearchModule;
    private MenuSelectModule menuSelectModule;
    private HistoryModule historyModule;
    private PaymentModule paymentModule;
    private ReceiptModule receiptModule;
    private TemplateModule templateModule;
    private SetupModule setupModule;
    private final MapRegistry mapRegistry;

    public KeeperModuleImpl(File workPath, Properties properties, AtmAPI listener) throws Exception {
        this.properties = properties;
        this.modulelistener = listener;
        if (!workPath.exists() && !workPath.mkdirs()) {
            throw new Exception("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0441\u043e\u0437\u0434\u0430\u0442\u044c \u0440\u0430\u0431\u043e\u0447\u0438\u0439 \u043a\u0430\u0442\u0430\u043b\u043e\u0433");
        }
        this.workPath = workPath;
        this.mapRegistry = new MapRegistry(new File(workPath, "maps"));
        this.apiModule = new KeeperApiModuleImpl(properties.getProperty(KEEPER_CONFIG_PARAM_BASEURL));
        Global.getInstance().setKeeperModule(this);
        Global.getInstance().setTerminalListener(this.modulelistener);
        this.referenceUpdater = new ReferenceUpdater(ReferencesHelper.getInstance(), this.log);
    }

    public KeeperApiModule getKeeperApiModule() {
        return this.apiModule;
    }

    public Runnable getReferenceUpdater() {
        return this.referenceUpdater;
    }

    public KeeperLogicModule getCurrentModule() {
        return this.currentModule;
    }

    public void setCurrentModule(KeeperLogicModule currentModule) {
        this.currentModule = currentModule;
    }

    private void resetData() {
        if (this.isReady()) {
            if (this.authModule != null) {
                this.authModule.finish();
            }
            if (this.homeModule != null) {
                this.homeModule.finish();
            }
            if (this.homeModule != null) {
                this.homeModule.finish();
            }
            if (this.menuPaymentModule != null) {
                this.menuPaymentModule.finish();
            }
            if (this.menuReceiptModule != null) {
                this.menuReceiptModule.finish();
            }
            if (this.menuSearchModule != null) {
                this.menuSearchModule.finish();
            }
            if (this.menuSelectModule != null) {
                this.menuSelectModule.finish();
            }
            if (this.historyModule != null) {
                this.historyModule.finish();
            }
            if (this.paymentModule != null) {
                this.paymentModule.finish();
            }
            if (this.receiptModule != null) {
                this.receiptModule.finish();
            }
            if (this.templateModule != null) {
                this.templateModule.finish();
            }
            if (this.setupModule != null) {
                this.setupModule.finish();
            }
        }
    }

    public void exit() {
        this.log.debug((Object)"exit()");
        this.currentModule = null;
        Global.getInstance().logout();
        this.resetData();
        this.modulelistener.exit();
    }

    public void logout(boolean timeout) {
        this.log.debug((Object)"logout()");
        this.currentModule = null;
        Global.getInstance().logout();
        this.resetData();
        this.modulelistener.exit();
    }

    public InitModule getInitModule() {
        return this.initModule;
    }

    public synchronized AuthModule getAuthModule() {
        if (this.authModule == null) {
            this.log.debug((Object)"create AuthModule");
            this.authModule = new AuthModule(this.modulelistener, this.log);
        }
        return this.authModule;
    }

    public synchronized HomeModule getHomeModule() {
        if (this.homeModule == null) {
            this.log.debug((Object)"create HomeModule");
            this.homeModule = new HomeModule(this.modulelistener, this.log);
        }
        return this.homeModule;
    }

    public synchronized MenuPaymentModule getMenuPaymentModule() {
        if (this.menuPaymentModule == null) {
            this.log.debug((Object)"create MenuPaymentModule");
            this.menuPaymentModule = new MenuPaymentModule(this.modulelistener, this.log);
        }
        return this.menuPaymentModule;
    }

    public synchronized MenuReceiptModule getMenuReceiptModule() {
        if (this.menuReceiptModule == null) {
            this.log.debug((Object)"create MenuReceiptModule");
            this.menuReceiptModule = new MenuReceiptModule(this.modulelistener, this.log);
        }
        return this.menuReceiptModule;
    }

    public synchronized MenuSearchModule getMenuSearchModule() {
        if (this.menuSearchModule == null) {
            this.log.debug((Object)"create MenuSearchModule");
            this.menuSearchModule = new MenuSearchModule(this.modulelistener, this.log);
        }
        return this.menuSearchModule;
    }

    public synchronized MenuSelectModule getMenuSelectModule() {
        if (this.menuSelectModule == null) {
            this.log.debug((Object)"create MenuSelectModule");
            this.menuSelectModule = new MenuSelectModule(this.modulelistener, this.log);
        }
        return this.menuSelectModule;
    }

    public synchronized HistoryModule getHistoryModule() {
        if (this.historyModule == null) {
            this.log.debug((Object)"create HistoryModule");
            this.historyModule = new HistoryModule(this.modulelistener, this.log);
        }
        return this.historyModule;
    }

    public synchronized PaymentModule getPaymentModule() {
        if (this.paymentModule == null) {
            this.log.debug((Object)"create PaymentModule");
            this.paymentModule = new PaymentModule(this.modulelistener, this.log);
        }
        return this.paymentModule;
    }

    public synchronized ReceiptModule getReceiptModule() {
        if (this.receiptModule == null) {
            this.log.debug((Object)"create ReceiptModule");
            this.receiptModule = new ReceiptModule(this.modulelistener, this.log);
        }
        return this.receiptModule;
    }

    public synchronized TemplateModule getTemplateModule() {
        if (this.templateModule == null) {
            this.log.debug((Object)"create TemplateModule");
            this.templateModule = new TemplateModule(this.modulelistener, this.log);
        }
        return this.templateModule;
    }

    public synchronized SetupModule getSetupModule() {
        if (this.setupModule == null) {
            this.log.debug((Object)"create SetupModule");
            this.setupModule = new SetupModule(this.modulelistener, this.log);
        }
        return this.setupModule;
    }

    public File getWorkPath() {
        return this.workPath;
    }

    public MapRegistry getMapRegistry() {
        return this.mapRegistry;
    }

    public synchronized void init() {
        if (this.initModule == null) {
            this.initModule = new InitModule(this.referenceUpdater, this.modulelistener, this.log);
            Executors.newSingleThreadExecutor().submit(new Runnable(){

                @Override
                public void run() {
                    KeeperModuleImpl.this.log.debug((Object)"KeeperModule initalize start");
                    try {
                        ReferencesHelper.getInstance().init(KeeperModuleImpl.this.workPath);
                        KeeperModuleImpl.this.log.debug((Object)"ReferencesHelper init done");
                    }
                    catch (Exception ex) {
                        KeeperModuleImpl.this.log.error((Object)("ReferencesHelper init error:" + ex.getMessage()), (Throwable)ex);
                        return;
                    }
                    Executors.newSingleThreadScheduledExecutor().scheduleAtFixedRate(KeeperModuleImpl.this.referenceUpdater, 0L, 1L, TimeUnit.MINUTES);
                    KeeperModuleImpl.this.referenceUpdater.getReadyProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

                        public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                            if (newValue.booleanValue()) {
                                KeeperModuleImpl.this.referenceUpdater.getReadyProperty().removeListener((ChangeListener)this);
                                Platform.runLater(() -> {
                                    KeeperModuleImpl.this.log.debug((Object)"KeeperModule inited");
                                    KeeperModuleImpl.this.setReady(true);
                                    KeeperModuleImpl.this.log.debug((Object)"KeeperModule initalize finish");
                                });
                            }
                        }
                    });
                }
            });
        }
    }

    public void start() {
        this.log.debug((Object)"START ");
        this.init();
        this.initModule.start();
    }

    public int getInactivityTimeout() {
        int to = -1;
        if (this.currentModule != null) {
            to = this.currentModule.getInactivityTimeout();
        } else {
            this.log.trace((Object)("KeeperModuleImpl getInactivityTimeout():" + to));
        }
        return to;
    }

    public void onTimeOut() {
        this.log.debug((Object)"KeeperModuleImpl onTimeOut()");
        if (this.currentModule != null) {
            this.currentModule.onTimeOut();
        } else {
            this.log.debug((Object)"KeeperModuleImpl onTimeOut(): NO MODULE!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setReady(boolean v) {
        this.log.debug((Object)("KeeperModuleImpl setReady(" + v + ") call"));
        Object object = this.lock;
        synchronized (object) {
            this.ready.set(v);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isReady() {
        boolean v;
        this.log.debug((Object)"KeeperModuleImpl isReady() call");
        Object object = this.lock;
        synchronized (object) {
            v = this.ready.get();
        }
        return v;
    }

    public BooleanProperty getReadyProperty() {
        return this.ready;
    }
}

