/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.smartkeeper.api.utils;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public final class HashUtils {
    private static final String HEXES = "0123456789abcdef";
    public static final String DEFAULT_ENCODING = "UTF-8";

    private HashUtils() {
    }

    public static String createMd5Hash(String text) {
        if (text == null) {
            throw new IllegalArgumentException("HashUtil::createMD5Hash [text] \u0420\u0405\u0420\u00b5 \u0420\u0458\u0420\u0455\u0420\u00b6\u0420\u00b5\u0421\u201a \u0420\u00b1\u0421\u2039\u0421\u201a\u0421\u040a \u0420\u0457\u0421\u0453\u0421\u0403\u0421\u201a\u0421\u2039\u0420\u0458");
        }
        return HashUtils.createHash(text, "MD5");
    }

    private static String createHash(String text, String alg) {
        try {
            MessageDigest digest = MessageDigest.getInstance(alg);
            digest.update(text.getBytes(DEFAULT_ENCODING));
            return HashUtils.getHex(digest.digest());
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static String getHex(byte[] raw) {
        if (raw == null) {
            return null;
        }
        StringBuilder hex = new StringBuilder(2 * raw.length);
        for (byte b : raw) {
            hex.append(HEXES.charAt((b & 0xF0) >> 4)).append(HEXES.charAt(b & 0xF));
        }
        return hex.toString();
    }

    public static String createMd5Hash(byte[] file) {
        return HashUtils.createHash(file, "MD5");
    }

    private static String createHash(byte[] file, String alg) {
        if (alg == null || alg.length() == 0) {
            throw new IllegalArgumentException("Hash algoritm can't be null");
        }
        if (file == null) {
            throw new IllegalArgumentException("Bytes array can't be null");
        }
        MessageDigest digest = null;
        try {
            digest = MessageDigest.getInstance(alg);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException("Wrong hash algoritm", e);
        }
        digest.update(file);
        return HashUtils.getHex(digest.digest());
    }
}

