/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.smartkeeper.api.exception;

import com.fasterxml.jackson.databind.ObjectReader;
import java.io.IOException;
import retrofit.ErrorHandler;
import retrofit.RetrofitError;
import retrofit.client.Header;
import ru.softlogic.keeper.api.model.DTOResponse;
import ru.softlogic.keeper.api.model.DTOResult;
import ru.softlogic.smartkeeper.api.exception.KeeperApiException;
import ru.softlogic.smartkeeper.api.exception.ParseResponseException;
import ru.softlogic.smartkeeper.api.exception.ServerUnavailableException;
import ru.softlogic.smartkeeper.api.jackson.ObjectMapperFactory;

public class KeeperErrorHandler
implements ErrorHandler {
    private static final int UNAUTHORIZED = 401;
    private static final int BAD_REQUEST = 400;
    private static final int UNPROCESSABLE_ENTITY = 422;
    private static final int LOCKED = 423;
    private static final int INTERNAL_SERVER_ERROR = 500;

    public Throwable handleError(RetrofitError retrofitError) {
        if (retrofitError.getResponse() != null) {
            int responseStatus = retrofitError.getResponse().getStatus();
            if (this.isApiError(retrofitError) && responseStatus == 401 || retrofitError.getResponse().getStatus() == 400 || retrofitError.getResponse().getStatus() == 422 || retrofitError.getResponse().getStatus() == 423) {
                ObjectReader objectReader = ObjectMapperFactory.getInstance().reader(DTOResponse.class);
                try {
                    DTOResponse responseValue = (DTOResponse)objectReader.readValue(retrofitError.getResponse().getBody().in());
                    DTOResult result = responseValue.getResult();
                    return new KeeperApiException(result);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    DTOResult dtoResult = new DTOResult();
                    dtoResult.setMsgCode("server_error");
                    dtoResult.setMsg("Server error");
                    return new ParseResponseException(dtoResult);
                }
            }
            if (responseStatus == 500) {
                DTOResult dtoResult = new DTOResult();
                dtoResult.setMsgCode("server_unavaible");
                dtoResult.setMsg("Server is unavailable");
                return new ServerUnavailableException(dtoResult);
            }
            return new IOException(retrofitError.getCause());
        }
        return new IOException(retrofitError.getCause());
    }

    private boolean isApiError(RetrofitError retrofitError) {
        if (retrofitError.getResponse().getHeaders() != null) {
            for (Header header : retrofitError.getResponse().getHeaders()) {
                if (!"sl-label".equals(header.getName())) continue;
                return true;
            }
        }
        return false;
    }
}

