/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.smartkeeper.api;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectReader;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.security.KeyStore;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;
import retrofit.client.Header;
import retrofit.client.Request;
import retrofit.client.Response;
import retrofit.client.UrlConnectionClient;
import retrofit.mime.TypedByteArray;
import retrofit.mime.TypedInput;
import retrofit.mime.TypedOutput;
import ru.softlogic.keeper.db.model.ClientAccount;
import ru.softlogic.smartkeeper.api.RequestHeadersHelper;
import ru.softlogic.smartkeeper.api.jackson.ObjectMapperFactory;
import ru.softlogic.smartkeeper.api.utils.CommonUtils;
import ru.softlogic.smartkeeper.api.utils.HashUtils;
import ru.softlogic.smartkeeper.api.utils.StreamUtils;

public class KeeperUrlConnectionClient
extends UrlConnectionClient {
    private static final int CHUNK_SIZE = 4096;
    private SimpleDateFormat dateFormat;
    private RequestHeadersHelper requestHeadersHelper;
    private String baseUrl;
    private boolean log;
    private int connectionTimout;
    private int readTimeout;
    private KeyStore keyStore;
    private long referenceVersion;
    private String requestBody;
    private boolean verifyHostname;

    public KeeperUrlConnectionClient(String baseUrl, RequestHeadersHelper requestHeadersHelper, boolean log, int connectionTimout, int readTimeout, KeyStore keyStore, boolean verifyHostname) {
        this.baseUrl = baseUrl;
        this.requestHeadersHelper = requestHeadersHelper;
        this.log = log;
        this.dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS Z", Locale.US);
        this.dateFormat.setLenient(false);
        this.connectionTimout = connectionTimout;
        this.readTimeout = readTimeout;
        this.keyStore = keyStore;
        this.verifyHostname = verifyHostname;
    }

    private Request addSlHeadersToReqiest(Request request) {
        if (this.requestHeadersHelper != null) {
            ArrayList<Header> headerList = new ArrayList<Header>();
            String clientLogin = this.requestHeadersHelper.getClientLogin();
            String clientPassword = this.requestHeadersHelper.getClientPassword();
            String uuid = this.requestHeadersHelper.getUUID();
            this.referenceVersion = this.requestHeadersHelper.getReferenceVersion();
            String apiUser = this.requestHeadersHelper.getApiUser();
            String apiPassword = this.requestHeadersHelper.getApiPassword();
            String clientDate = this.dateFormat.format(new Date());
            headerList.add(new Header("sl-api-version", this.requestHeadersHelper.getApiVersion() != null ? this.requestHeadersHelper.getApiVersion() : "1.0.13.0"));
            headerList.add(new Header("sl-soft-version", this.requestHeadersHelper.getClientVersion()));
            headerList.add(new Header("sl-user", apiUser));
            headerList.add(new Header("sl-pwd-hash", apiPassword));
            headerList.add(new Header("sl-iface", this.requestHeadersHelper.getInterfaceType().name()));
            headerList.add(new Header("sl-current-date", clientDate));
            headerList.add(new Header("sl-ref-version", String.valueOf(this.referenceVersion)));
            headerList.add(new Header("sl-client-login", clientLogin));
            headerList.add(new Header("sl-client-pwd-hash", clientPassword));
            headerList.add(new Header("sl-client-locale", this.requestHeadersHelper.getLocale()));
            headerList.add(new Header("sl-uid", uuid));
            headerList.add(new Header("sl-zip-keys", String.valueOf(true)));
            this.requestBody = request.getBody() != null ? new String(((TypedByteArray)request.getBody()).getBytes()) : "";
            String slHash = CommonUtils.arrayToDelimitedString(new String[]{request.getMethod(), this.baseUrl != null ? request.getUrl().replace(this.baseUrl + "/keeper-api", "") : request.getUrl(), apiUser, apiPassword, clientLogin, clientPassword, this.requestBody, uuid, this.requestHeadersHelper.getSecretKey(), clientDate}, ":");
            headerList.add(new Header("sl-hash", HashUtils.createMd5Hash(slHash)));
            return new Request(request.getMethod(), request.getUrl(), headerList, request.getBody());
        }
        return request;
    }

    private void processResponseHeaders(Response response) {
        if (this.requestHeadersHelper != null) {
            List responseHeaders = response.getHeaders();
            for (Header header : responseHeaders) {
                long newReferenceVersion;
                if ("sl-ref-version".equals(header.getName()) && (newReferenceVersion = Long.parseLong(header.getValue())) > this.referenceVersion) {
                    this.requestHeadersHelper.onUpdateReferenceRequired();
                }
                if (!"sl-accounts".equals(header.getName())) continue;
                try {
                    ObjectReader objectReader = ObjectMapperFactory.getInstance().reader((TypeReference)new TypeReference<Collection<ClientAccount>>(){});
                    Collection clientAccounts = (Collection)objectReader.readValue(URLDecoder.decode(header.getValue(), "UTF-8"));
                    this.requestHeadersHelper.onClientAccountsUpdated(clientAccounts);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public Response execute(Request request) throws IOException {
        Request modifiedRequest = this.addSlHeadersToReqiest(request);
        HttpURLConnection connection = this.openConnection(modifiedRequest);
        this.prepareRequest(connection, modifiedRequest);
        Response response = this.readResponse(connection, 0);
        this.processResponseHeaders(response);
        if (this.log) {
            return this.logConnection(modifiedRequest, response);
        }
        return response;
    }

    private Response logConnection(Request request, final Response response) throws IOException {
        if (this.requestHeadersHelper != null) {
            StringBuilder stringBuilder = new StringBuilder("==============================================================================================\n");
            stringBuilder.append(request.getMethod());
            stringBuilder.append(" ");
            stringBuilder.append(request.getUrl());
            stringBuilder.append("\n--------------------------------------------------------------------");
            stringBuilder.append("\nREQUEST HEADERS:\n");
            if (request.getHeaders() != null) {
                for (Header header : request.getHeaders()) {
                    stringBuilder.append(header.getName());
                    stringBuilder.append(": ");
                    stringBuilder.append(header.getValue());
                    stringBuilder.append("\n");
                }
            }
            stringBuilder.append("--------------------------------------------------------------------");
            stringBuilder.append("\nREQUEST BODY:\n");
            stringBuilder.append(this.requestBody);
            stringBuilder.append("\n--------------------------------------------------------------------");
            stringBuilder.append("\nRESPONSE HEADERS:\n");
            if (response.getHeaders() != null) {
                for (Header header : response.getHeaders()) {
                    if ("sl-ref-version".equals(header.getName())) {
                        stringBuilder.append(header.getName());
                        stringBuilder.append(": ");
                        stringBuilder.append(header.getValue());
                        stringBuilder.append("\n");
                    }
                    if (!"sl-accounts".equals(header.getName())) continue;
                    stringBuilder.append(header.getName());
                    stringBuilder.append(": ");
                    stringBuilder.append(URLDecoder.decode(header.getValue(), "UTF-8"));
                    stringBuilder.append("\n");
                }
            }
            Response finalResponse = response;
            final InputStream inputStream = response.getBody().in();
            if (inputStream != null) {
                final byte[] bodyArray = StreamUtils.convertInputStreamToByteArray(inputStream);
                stringBuilder.append("--------------------------------------------------------------------");
                stringBuilder.append("\nRESPONSE BODY: \n");
                if (bodyArray != null) {
                    stringBuilder.append(new String(bodyArray));
                }
                finalResponse = new Response(response.getUrl(), response.getStatus(), response.getReason(), response.getHeaders(), new TypedInput(){

                    public String mimeType() {
                        return response.getBody().mimeType();
                    }

                    public long length() {
                        return response.getBody().length();
                    }

                    public InputStream in() throws IOException {
                        return bodyArray != null ? new ByteArrayInputStream(bodyArray) : inputStream;
                    }
                });
            }
            this.requestHeadersHelper.logRequest(stringBuilder.toString());
            return finalResponse;
        }
        return response;
    }

    protected HttpURLConnection openConnection(Request request) throws IOException {
        HttpURLConnection httpURLConnection = (HttpURLConnection)new URL(request.getUrl()).openConnection();
        httpURLConnection.setConnectTimeout(this.connectionTimout);
        httpURLConnection.setReadTimeout(this.readTimeout);
        if (httpURLConnection instanceof HttpsURLConnection) {
            if (this.keyStore != null) {
                ((HttpsURLConnection)httpURLConnection).setSSLSocketFactory(this.getSocketFactory(this.keyStore));
            }
            if (!this.verifyHostname) {
                ((HttpsURLConnection)httpURLConnection).setHostnameVerifier(new HostnameVerifier(){

                    @Override
                    public boolean verify(String s, SSLSession sslSession) {
                        return true;
                    }
                });
            }
        }
        return httpURLConnection;
    }

    private void prepareRequest(HttpURLConnection connection, Request request) throws IOException {
        connection.setRequestProperty("Connection", "close");
        connection.setRequestMethod(request.getMethod());
        connection.setDoInput(true);
        for (Header header : request.getHeaders()) {
            connection.addRequestProperty(header.getName(), header.getValue());
        }
        TypedOutput body = request.getBody();
        if (body != null) {
            connection.setDoOutput(true);
            connection.addRequestProperty("Content-Type", body.mimeType());
            long length = body.length();
            if (length != -1L) {
                connection.setFixedLengthStreamingMode((int)length);
                connection.addRequestProperty("Content-Length", String.valueOf(length));
            } else {
                connection.setChunkedStreamingMode(4096);
            }
            body.writeTo(connection.getOutputStream());
        }
    }

    private Response readResponse(HttpURLConnection connection, int tryCount) throws IOException {
        try {
            int status;
            try {
                status = connection.getResponseCode();
            }
            catch (IOException e) {
                e.printStackTrace();
                status = connection.getResponseCode();
            }
            if (status < 200) {
                throw new IOException("Response status: " + status);
            }
            String reason = connection.getResponseMessage();
            if (reason == null) {
                reason = "";
            }
            ArrayList<Header> headers = new ArrayList<Header>();
            for (Map.Entry<String, List<String>> field : connection.getHeaderFields().entrySet()) {
                String name = field.getKey();
                for (String value : field.getValue()) {
                    headers.add(new Header(name, value));
                }
            }
            String mimeType = connection.getContentType();
            int length = connection.getContentLength();
            InputStream stream = status >= 400 ? connection.getErrorStream() : connection.getInputStream();
            TypedInputStream responseBody = new TypedInputStream(mimeType, length, stream);
            return new Response(connection.getURL().toString(), status, reason, headers, (TypedInput)responseBody);
        }
        catch (IOException e) {
            e.printStackTrace();
            if (e.getCause() instanceof EOFException && tryCount < 3) {
                return this.readResponse(connection, tryCount + 1);
            }
            throw new IOException(e.getMessage());
        }
    }

    private SSLSocketFactory getSocketFactory(KeyStore keyStore) {
        if (keyStore != null) {
            try {
                SSLContext sslContext = SSLContext.getInstance("TLS");
                TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                trustManagerFactory.init(keyStore);
                sslContext.init(null, trustManagerFactory.getTrustManagers(), null);
                return sslContext.getSocketFactory();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private static class TypedInputStream
    implements TypedInput {
        private final String mimeType;
        private final long length;
        private final InputStream stream;

        private TypedInputStream(String mimeType, long length, InputStream stream) {
            this.mimeType = mimeType;
            this.length = length;
            this.stream = stream;
        }

        public String mimeType() {
            return this.mimeType;
        }

        public long length() {
            return this.length;
        }

        public InputStream in() throws IOException {
            return this.stream;
        }
    }
}

