/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.keeper.db.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import ru.softlogic.keeper.annotation.documentation.FieldDoc;
import ru.softlogic.keeper.annotation.documentation.TypeDoc;
import ru.softlogic.keeper.db.model.CashSource;
import ru.softlogic.keeper.db.model.Client;
import ru.softlogic.keeper.db.model.ClientAccount;
import ru.softlogic.keeper.db.model.Currency;
import ru.softlogic.keeper.db.model.MenuItem;
import ru.softlogic.keeper.db.model.OperationType;
import ru.softlogic.keeper.db.model.Service;
import ru.softlogic.keeper.db.model.common.PrimaryKey;

@Entity
@Table(name="v_history")
@JsonSerialize(include=JsonSerialize.Inclusion.NON_DEFAULT)
@TypeDoc(value="\u0418\u0441\u0442\u043e\u0440\u0438\u044f \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u0439")
public class VHistory
extends PrimaryKey {
    private static final long serialVersionUID = 1L;
    @Id
    @Column(name="id")
    private Long id;
    @Column(name="account")
    @FieldDoc(value="ID 1")
    private String account;
    @Column(name="account2")
    @FieldDoc(value="ID 2")
    private String account2;
    @Column(name="date_add")
    @Temporal(value=TemporalType.TIMESTAMP)
    @FieldDoc(value="\u0414\u0430\u0442\u0430 \u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u044f")
    private Date dateAdd;
    @Column(name="date_update")
    @Temporal(value=TemporalType.TIMESTAMP)
    @FieldDoc(value="\u0414\u0430\u0442\u0430 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f")
    private Date dateUpdate;
    @Column(name="date_writeoff")
    @Temporal(value=TemporalType.TIMESTAMP)
    @FieldDoc(value="\u0414\u0430\u0442\u0430 \u0441\u043f\u0438\u0441\u0430\u043d\u0438\u044f \u0441\u0440\u0435\u0434\u0441\u0442\u0432 \u0441 \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a\u0430 \u043e\u043f\u043b\u0430\u0442\u044b")
    private Date dateWriteoff;
    @Column(name="date_change")
    @Temporal(value=TemporalType.TIMESTAMP)
    @FieldDoc(value="\u0414\u0430\u0442\u0430 \u043f\u043e\u0441\u043b\u0435\u0434\u043d\u0435\u0433\u043e \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f \u0441\u0442\u0430\u0442\u0443\u0441\u0430")
    private Date dateChange;
    @Column(name="sum_in")
    @FieldDoc(value="\u0421\u0443\u043c\u043c\u0430 \u0441\u043f\u0438\u0441\u0430\u043d\u0438\u044f")
    private Integer sumIn;
    @Column(name="sum_comm")
    @FieldDoc(value="\u0421\u0443\u043c\u043c\u0430 \u043a\u043e\u043c\u0438\u0441\u0441\u0438\u0438")
    private Integer sumComm;
    @Column(name="sum_out")
    @FieldDoc(value="\u0421\u0443\u043c\u043c\u0430 ")
    private Integer sumOut;
    @Column(name="state")
    @FieldDoc(value="\u0421\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u0435")
    private Short state;
    @Column(name="sub_state")
    @FieldDoc(value="\u0421\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u0435")
    private Short subState;
    @Column(name="check_number")
    @FieldDoc(value="\u041d\u043e\u043c\u0435\u0440 \u0447\u0435\u043a\u0430")
    private String checkNumber;
    @Column(name="ip")
    @FieldDoc(value="IP-\u0430\u0434\u0440\u0435\u0441")
    private String ip;
    @Column(name="operation_number")
    @FieldDoc(value="\u041d\u043e\u043c\u0435\u0440 \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u0438")
    private Integer operationNumber;
    @Column(name="currency_code")
    @FieldDoc(value="\u041a\u043e\u0434 \u0432\u0430\u043b\u044e\u0442\u044b")
    private String currencyCode;
    @Column(name="currency_name")
    @FieldDoc(value="\u041d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 \u0432\u0430\u043b\u044e\u0442\u044b")
    private String currencyName;
    @Column(name="currency_digital_code")
    @FieldDoc(value="\u0427\u0438\u0441\u043b\u043e\u0432\u043e\u0439 \u043a\u043e\u0434 \u0432\u0430\u043b\u044e\u0442\u044b")
    private Short currencyDigitalCode;
    @Column(name="currency_small_name")
    @FieldDoc(value="\u041a\u0440\u0430\u0442\u043a\u043e\u0435 \u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 \u0432\u0430\u043b\u044e\u0442\u044b")
    private String currencySmallName;
    @Column(name="cash_source_code")
    @FieldDoc(value="\u041a\u043e\u0434 \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a\u0430 \u043e\u043f\u043b\u0430\u0442\u044b")
    private String cashSourceCode;
    @Column(name="cash_source_name")
    @FieldDoc(value="\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a\u0430 \u043e\u043f\u043b\u0430\u0442\u044b")
    private String cashSourceName;
    @Column(name="client_login")
    @FieldDoc(value="\u0418\u043c\u044f \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f")
    private String clientLogin;
    @Column(name="service_name")
    @FieldDoc(value="\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0441\u0435\u0440\u0432\u0438\u0441\u0430")
    private String serviceName;
    @Column(name="service_info")
    @FieldDoc(value="\u0418\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f \u043e \u0441\u0435\u0440\u0432\u0438\u0441\u0435")
    private String serviceInfo;
    @Column(name="service_full_name")
    @FieldDoc(value="\u041f\u043e\u043b\u043d\u043e\u0435 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0441\u0435\u0440\u0432\u0438\u0441\u0430")
    private String serviceFullName;
    @Column(name="service_image")
    @FieldDoc(value="\u0424\u0430\u0439\u043b \u0438\u0437\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u044f \u0441\u0435\u0440\u0432\u0438\u0441\u0430")
    private String serviceImage;
    @Column(name="service_code")
    @FieldDoc(value="\u041a\u043e\u0434 \u0441\u0435\u0440\u0432\u0438\u0441\u0430")
    private Integer serviceCode;
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    @JoinColumn(name="menu_item", referencedColumnName="id")
    @FieldDoc(value="\u042d\u043b\u0435\u043c\u0435\u043d\u0442 \u043c\u0435\u043d\u044e", required={"id"})
    private MenuItem menuItem;
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    @JoinColumn(name="client", referencedColumnName="id")
    @FieldDoc(value="\u041a\u043b\u0438\u0435\u043d\u0442", required={"id"})
    private Client client;
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    @JoinColumn(name="client_account", referencedColumnName="id")
    @FieldDoc(value="\u0421\u0447\u0435\u0442 \u043a\u043b\u0438\u0435\u043d\u0442\u0430", required={"id"})
    private ClientAccount clientAccount;
    @FieldDoc(value="\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0441\u0447\u0435\u0442\u0430 \u043a\u043b\u0438\u0435\u043d\u0442\u0430")
    private String clientAccountName;
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    @JoinColumn(name="operation_type", referencedColumnName="id")
    @FieldDoc(value="\u0422\u0438\u043f \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u0438", required={"id"})
    private OperationType operationType;
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    @JoinColumn(name="service", referencedColumnName="id")
    @FieldDoc(value="\u0421\u0435\u0440\u0432\u0438\u0441", required={"id"})
    private Service service;
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    @JoinColumn(name="currency", referencedColumnName="id")
    @FieldDoc(value="\u0412\u0430\u043b\u044e\u0442\u0430", required={"id"})
    private Currency currency;
    @FieldDoc(value="\u041e\u0431\u043e\u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u0432\u0430\u043b\u044e\u0442\u044b")
    private String currencySign;
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    @JoinColumn(name="cash_source", referencedColumnName="id")
    @FieldDoc(value="\u0418\u0441\u0442\u043e\u0447\u043d\u0438\u043a\u0430 \u043e\u043f\u043b\u0430\u0442\u044b", required={"id"})
    private CashSource cashSource;

    public VHistory() {
    }

    public VHistory(Long id) {
        this.id = id;
    }

    @JsonIgnore
    private static Double getSumReal(Integer sum) {
        return sum != null ? (double)sum.intValue() / 100.0 : 0.0;
    }

    @Override
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getAccount() {
        return this.account;
    }

    public void setAccount(String account) {
        this.account = account;
    }

    public String getAccount2() {
        return this.account2;
    }

    public void setAccount2(String account2) {
        this.account2 = account2;
    }

    public Date getDateAdd() {
        return this.dateAdd;
    }

    public void setDateAdd(Date dateAdd) {
        this.dateAdd = dateAdd;
    }

    public Date getDateUpdate() {
        return this.dateUpdate;
    }

    public void setDateUpdate(Date dateUpdate) {
        this.dateUpdate = dateUpdate;
    }

    public Date getDateWriteoff() {
        return this.dateWriteoff;
    }

    public void setDateWriteoff(Date dateWriteoff) {
        this.dateWriteoff = dateWriteoff;
    }

    public Date getDateChange() {
        return this.dateChange;
    }

    public void setDateChange(Date dateChange) {
        this.dateChange = dateChange;
    }

    public Integer getSumIn() {
        return this.sumIn;
    }

    public void setSumIn(Integer sumIn) {
        this.sumIn = sumIn;
    }

    public Integer getSumComm() {
        return this.sumComm;
    }

    public void setSumComm(Integer sumComm) {
        this.sumComm = sumComm;
    }

    public Integer getSumOut() {
        return this.sumOut;
    }

    public void setSumOut(Integer sumOut) {
        this.sumOut = sumOut;
    }

    @JsonIgnore
    public Double getSumInReal() {
        return VHistory.getSumReal(this.getSumIn());
    }

    @JsonIgnore
    public Double getSumCommReal() {
        return VHistory.getSumReal(this.getSumComm());
    }

    @JsonIgnore
    public Double getSumOutReal() {
        return VHistory.getSumReal(this.getSumOut());
    }

    public Short getState() {
        return this.state;
    }

    public void setState(Short state) {
        this.state = state;
    }

    public Short getSubState() {
        return this.subState;
    }

    public void setSubState(Short subState) {
        this.subState = subState;
    }

    public String getCheckNumber() {
        return this.checkNumber;
    }

    public void setCheckNumber(String checkNumber) {
        this.checkNumber = checkNumber;
    }

    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public Integer getOperationNumber() {
        return this.operationNumber;
    }

    public void setOperationNumber(Integer operationNumber) {
        this.operationNumber = operationNumber;
    }

    public String getCurrencyCode() {
        return this.currencyCode;
    }

    public void setCurrencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
    }

    public String getCurrencyName() {
        return this.currencyName;
    }

    public void setCurrencyName(String currencyName) {
        this.currencyName = currencyName;
    }

    public String getCurrencySmallName() {
        return this.currencySmallName;
    }

    public void setCurrencySmallName(String currencySmallName) {
        this.currencySmallName = currencySmallName;
    }

    public Short getCurrencyDigitalCode() {
        return this.currencyDigitalCode;
    }

    public void setCurrencyDigitalCode(Short currencyDigitalCode) {
        this.currencyDigitalCode = currencyDigitalCode;
    }

    public String getCashSourceCode() {
        return this.cashSourceCode;
    }

    public void setCashSourceCode(String cashSourceCode) {
        this.cashSourceCode = cashSourceCode;
    }

    public String getCashSourceName() {
        return this.cashSourceName;
    }

    public void setCashSourceName(String cashSourceName) {
        this.cashSourceName = cashSourceName;
    }

    public String getClientLogin() {
        return this.clientLogin;
    }

    public void setClientLogin(String clientLogin) {
        this.clientLogin = clientLogin;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getServiceFullName() {
        return this.serviceFullName;
    }

    public void setServiceFullName(String serviceFullName) {
        this.serviceFullName = serviceFullName;
    }

    public String getServiceImage() {
        return this.serviceImage;
    }

    public void setServiceImage(String serviceImage) {
        this.serviceImage = serviceImage;
    }

    public Integer getServiceCode() {
        return this.serviceCode;
    }

    public void setServiceCode(Integer serviceCode) {
        this.serviceCode = serviceCode;
    }

    public MenuItem getMenuItem() {
        return this.menuItem;
    }

    public void setMenuItem(MenuItem menuItem) {
        this.menuItem = menuItem;
    }

    public Client getClient() {
        return this.client;
    }

    public void setClient(Client client) {
        this.client = client;
    }

    public ClientAccount getClientAccount() {
        return this.clientAccount;
    }

    public void setClientAccount(ClientAccount clientAccount) {
        this.clientAccount = clientAccount;
    }

    public String getClientAccountName() {
        return this.clientAccountName;
    }

    public void setClientAccountName(String clientAccountName) {
        this.clientAccountName = clientAccountName;
    }

    public OperationType getOperationType() {
        return this.operationType;
    }

    public void setOperationType(OperationType operationType) {
        this.operationType = operationType;
    }

    public Service getService() {
        return this.service;
    }

    public void setService(Service service) {
        this.service = service;
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public void setCurrency(Currency currency) {
        this.currency = currency;
    }

    public String getCurrencySign() {
        return this.currencySign;
    }

    public void setCurrencySign(String currencySign) {
        this.currencySign = currencySign;
    }

    public CashSource getCashSource() {
        return this.cashSource;
    }

    public void setCashSource(CashSource cashSource) {
        this.cashSource = cashSource;
    }

    public String getServiceInfo() {
        return this.serviceInfo;
    }

    public void setServiceInfo(String serviceInfo) {
        this.serviceInfo = serviceInfo;
    }

    public int hashCode() {
        return this._hashCode();
    }

    public boolean equals(Object object) {
        return this._equals(object, VHistory.class);
    }

    public String toString() {
        return this._toString(VHistory.class);
    }
}

