/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.keeper.db.model;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.Date;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import ru.softlogic.keeper.db.model.Client;
import ru.softlogic.keeper.db.model.ClientAccount;
import ru.softlogic.keeper.db.model.InterfaceType;
import ru.softlogic.keeper.db.model.common.PrimaryKey;

@Entity
@Table(name="transfer")
@JsonSerialize(include=JsonSerialize.Inclusion.NON_DEFAULT)
public class Transfer
extends PrimaryKey {
    private static final long serialVersionUID = 1L;
    @Id
    @Column(name="id")
    @SequenceGenerator(name="transfer_id_seq", sequenceName="transfer_id_seq", allocationSize=1)
    @GeneratedValue(generator="transfer_id_seq", strategy=GenerationType.SEQUENCE)
    private Long id;
    @Basic(optional=false)
    @Column(name="summ")
    private int sum;
    @Basic(optional=false)
    @Column(name="date_add")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date dateAdd;
    @Basic(optional=false)
    @Column(name="state")
    private short state;
    @Column(name="ip")
    private String ip;
    @Basic(optional=false)
    @Column(name="operation_number")
    private int operationNumber;
    @Basic(optional=false)
    @Column(name="device_uid")
    private String deviceUid;
    @JoinColumn(name="interface_type_add", referencedColumnName="id")
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private InterfaceType interfaceTypeAdd;
    @JoinColumn(name="provider_account", referencedColumnName="id")
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private ClientAccount providerAccount;
    @JoinColumn(name="recipient_account", referencedColumnName="id")
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private ClientAccount recipientAccount;
    @JoinColumn(name="provider", referencedColumnName="id")
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private Client provider;
    @JoinColumn(name="recipient", referencedColumnName="id")
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private Client recipient;

    public Transfer() {
    }

    public Transfer(Long id) {
        this.id = id;
    }

    public Transfer(Long id, int sum, Date dateAdd, short state) {
        this.id = id;
        this.sum = sum;
        this.dateAdd = dateAdd;
        this.state = state;
    }

    @Override
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public int getSum() {
        return this.sum;
    }

    public void setSum(int sum) {
        this.sum = sum;
    }

    public Date getDateAdd() {
        return this.dateAdd;
    }

    public void setDateAdd(Date dateAdd) {
        this.dateAdd = dateAdd;
    }

    public short getState() {
        return this.state;
    }

    public void setState(short state) {
        this.state = state;
    }

    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public InterfaceType getInterfaceTypeAdd() {
        return this.interfaceTypeAdd;
    }

    public void setInterfaceTypeAdd(InterfaceType interfaceTypeAdd) {
        this.interfaceTypeAdd = interfaceTypeAdd;
    }

    public ClientAccount getProviderAccount() {
        return this.providerAccount;
    }

    public void setProviderAccount(ClientAccount providerAccount) {
        this.providerAccount = providerAccount;
    }

    public ClientAccount getRecipientAccount() {
        return this.recipientAccount;
    }

    public void setRecipientAccount(ClientAccount recipientAccount) {
        this.recipientAccount = recipientAccount;
    }

    public Client getProvider() {
        return this.provider;
    }

    public void setProvider(Client provider) {
        this.provider = provider;
    }

    public Client getRecipient() {
        return this.recipient;
    }

    public void setRecipient(Client recipient) {
        this.recipient = recipient;
    }

    public int getOperationNumber() {
        return this.operationNumber;
    }

    public void setOperationNumber(int operationNumber) {
        this.operationNumber = operationNumber;
    }

    public String getDeviceUid() {
        return this.deviceUid;
    }

    public void setDeviceUid(String deviceUid) {
        this.deviceUid = deviceUid;
    }

    public int hashCode() {
        return this._hashCode();
    }

    public boolean equals(Object object) {
        return this._equals(object, Transfer.class);
    }

    public String toString() {
        return this._toString(Transfer.class);
    }
}

