/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.keeper.db.model;

import java.util.Date;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.hibernate.annotations.Type;
import ru.softlogic.keeper.db.model.AccessRole;
import ru.softlogic.keeper.db.model.Area;
import ru.softlogic.keeper.db.model.common.PrimaryKey;

@Entity
@Table(name="person")
public class Person
extends PrimaryKey {
    private static final long serialVersionUID = 1L;
    @Id
    @Column(name="id")
    @SequenceGenerator(name="person_id_seq", sequenceName="person_id_seq", allocationSize=1)
    @GeneratedValue(generator="person_id_seq", strategy=GenerationType.SEQUENCE)
    private Integer id;
    @Basic(optional=false)
    @Column(name="login")
    private String login;
    @Basic(optional=false)
    @Column(name="password_hash")
    private String passwordHash;
    @Basic(optional=false)
    @Column(name="name")
    private String name;
    @Basic(optional=false)
    @Column(name="blocked", columnDefinition="smallint")
    @Type(type="numeric_boolean")
    private boolean blocked;
    @Basic(optional=false)
    @Column(name="send_event", columnDefinition="smallint")
    @Type(type="numeric_boolean")
    private boolean sendEvent;
    @Column(name="sms_phone")
    private String smsPhone;
    @Column(name="time_zone")
    private String timeZone;
    @JoinColumn(name="sms_phone_area", referencedColumnName="id")
    @ManyToOne(fetch=FetchType.LAZY)
    private Area smsPhoneArea;
    @Column(name="email")
    private String email;
    @Basic(optional=false)
    @Column(name="send_sms_pin_for_auth", columnDefinition="smallint")
    @Type(type="numeric_boolean")
    private boolean sendSmsPinForAuth;
    @JoinColumn(name="access_role", referencedColumnName="id")
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private AccessRole accessRole;
    @Basic(optional=false)
    @Column(name="allowed_ip")
    private String allowedIp;
    @Basic(optional=false)
    @Column(name="req_pwd_change", columnDefinition="smallint")
    @Type(type="numeric_boolean")
    private boolean requiredPasswordChange;
    @Basic(optional=false)
    @Column(name="last_login")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date lastLogin;
    @Basic(optional=false)
    @Column(name="last_pwd_change")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date lastPasswordChange;
    @Basic(optional=false)
    @Column(name="failed_login_attempts")
    private Integer failedLoginAttempts;
    @Basic(optional=false)
    @Column(name="temporary_blocking_to")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date temporaryBlockingTo;

    public Person() {
        this.requiredPasswordChange = true;
        this.lastLogin = new Date();
        this.lastPasswordChange = new Date();
        this.failedLoginAttempts = 0;
        this.temporaryBlockingTo = new Date();
    }

    public Person(Integer id) {
        this.id = id;
        this.requiredPasswordChange = true;
        this.lastLogin = new Date();
        this.lastPasswordChange = new Date();
        this.failedLoginAttempts = 0;
        this.temporaryBlockingTo = new Date();
    }

    public Person(Integer id, String login, String passwordHash, String name, boolean blocked, boolean sendEvent) {
        this.id = id;
        this.login = login;
        this.passwordHash = passwordHash;
        this.name = name;
        this.blocked = blocked;
        this.sendEvent = sendEvent;
        this.requiredPasswordChange = true;
        this.lastLogin = new Date();
        this.lastPasswordChange = new Date();
        this.failedLoginAttempts = 0;
        this.temporaryBlockingTo = new Date();
    }

    @Override
    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getLogin() {
        return this.login;
    }

    public void setLogin(String login) {
        this.login = login;
    }

    public String getPasswordHash() {
        return this.passwordHash;
    }

    public void setPasswordHash(String passwordHash) {
        this.passwordHash = passwordHash;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isBlocked() {
        return this.blocked;
    }

    public void setBlocked(boolean blocked) {
        this.blocked = blocked;
    }

    public boolean isSendEvent() {
        return this.sendEvent;
    }

    public void setSendEvent(boolean sendEvent) {
        this.sendEvent = sendEvent;
    }

    public String getSmsPhone() {
        return this.smsPhone;
    }

    public void setSmsPhone(String smsPhone) {
        this.smsPhone = smsPhone;
    }

    public String getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(String timeZone) {
        this.timeZone = timeZone;
    }

    public Area getSmsPhoneArea() {
        return this.smsPhoneArea;
    }

    public void setSmsPhoneArea(Area smsPhoneArea) {
        this.smsPhoneArea = smsPhoneArea;
    }

    public AccessRole getAccessRole() {
        return this.accessRole;
    }

    public void setAccessRole(AccessRole accessRole) {
        this.accessRole = accessRole;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public boolean isSendSmsPinForAuth() {
        return this.sendSmsPinForAuth;
    }

    public void setSendSmsPinForAuth(boolean sendSmsPinForAuth) {
        this.sendSmsPinForAuth = sendSmsPinForAuth;
    }

    public String getAllowedIp() {
        return this.allowedIp;
    }

    public void setAllowedIp(String allowedIp) {
        this.allowedIp = allowedIp;
    }

    public boolean isRequiredPasswordChange() {
        return this.requiredPasswordChange;
    }

    public void setRequiredPasswordChange(boolean requiredPasswordChange) {
        this.requiredPasswordChange = requiredPasswordChange;
    }

    public Date getLastLogin() {
        return this.lastLogin;
    }

    public void setLastLogin(Date lastLogin) {
        this.lastLogin = lastLogin;
    }

    public Date getLastPasswordChange() {
        return this.lastPasswordChange;
    }

    public void setLastPasswordChange(Date lastPasswordChange) {
        this.lastPasswordChange = lastPasswordChange;
    }

    public Integer getFailedLoginAttempts() {
        return this.failedLoginAttempts;
    }

    public void setFailedLoginAttempts(Integer failedLoginAttempts) {
        this.failedLoginAttempts = failedLoginAttempts;
    }

    public Date getTemporaryBlockingTo() {
        return this.temporaryBlockingTo;
    }

    public void setTemporaryBlockingTo(Date temporaryBlockingTo) {
        this.temporaryBlockingTo = temporaryBlockingTo;
    }

    public int hashCode() {
        return this._hashCode();
    }

    public boolean equals(Object object) {
        return this._equals(object, Person.class);
    }

    public String toString() {
        return this._toString(Person.class);
    }
}

