/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.keeper.db.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.Date;
import java.util.List;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import ru.softlogic.keeper.annotation.documentation.FieldDoc;
import ru.softlogic.keeper.db.model.Merchant;
import ru.softlogic.keeper.db.model.MerchantReqState;
import ru.softlogic.keeper.db.model.MerchantRequestAttr;
import ru.softlogic.keeper.db.model.Operation;
import ru.softlogic.keeper.db.model.Service;
import ru.softlogic.keeper.db.model.common.PrimaryKey;

@Entity
@Table(name="merchant_request")
@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
public class MerchantRequest
extends PrimaryKey {
    private static final long serialVersionUID = 1L;
    @Id
    @Column(name="id")
    @SequenceGenerator(name="merchant_request_id_seq", sequenceName="merchant_request_id_seq", allocationSize=1)
    @GeneratedValue(generator="merchant_request_id_seq", strategy=GenerationType.SEQUENCE)
    @FieldDoc(value="\u0423\u043d\u0438\u043a\u0430\u043b\u044c\u043d\u044b\u0439 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440")
    private Long id;
    @JoinColumn(name="merchant", referencedColumnName="id")
    @OneToOne(optional=false, fetch=FetchType.LAZY)
    @FieldDoc(value="\u041c\u0435\u0440\u0447\u0430\u043d\u0442", required={"id"})
    private Merchant merchant;
    @JoinColumn(name="service", referencedColumnName="id")
    @ManyToOne(optional=true, fetch=FetchType.LAZY)
    @FieldDoc(value="\u0421\u0435\u0440\u0432\u0438\u0441", required={"id"})
    private Service service;
    @JoinColumn(name="merchant_state", referencedColumnName="id")
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    @FieldDoc(value="\u0421\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u0435 \u0437\u0430\u043f\u0440\u043e\u0441\u0430 \u043c\u0435\u0440\u0447\u0430\u043d\u0442\u0430")
    private MerchantReqState merchantState;
    @Basic(optional=false)
    @Column(name="sum_in")
    @FieldDoc(value="\u0421\u0443\u043c\u043c\u0430 \u0432\u043b\u043e\u0436\u0435\u043d\u043d\u0430\u044f(\u0441\u043f\u0438\u0441\u0430\u043d\u0438\u044f)")
    private int sumIn;
    @Basic(optional=false)
    @Column(name="date_add")
    @Temporal(value=TemporalType.TIMESTAMP)
    @FieldDoc(value="\u0414\u0430\u0442\u0430 \u0438 \u0432\u0440\u0435\u043c\u044f \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u044f")
    private Date dateAdd;
    @Basic(optional=false)
    @Column(name="date_update")
    @Temporal(value=TemporalType.TIMESTAMP)
    @FieldDoc(value="\u0414\u0430\u0442\u0430 \u0438 \u0432\u0440\u0435\u043c\u044f \u043f\u043e\u0441\u043b\u0435\u0434\u043d\u0435\u0433\u043e \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u044f")
    private Date dateUpdate;
    @Basic(optional=false)
    @Column(name="external_transaction")
    @FieldDoc(value="\u0412\u043d\u0435\u0448\u043d\u0438\u0439 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440")
    private String externalTransaction;
    @Column(name="ip")
    @FieldDoc(value="IP \u0430\u0434\u0440\u0435\u0441")
    private String ip;
    @JoinColumn(name="operation", referencedColumnName="id")
    @ManyToOne(optional=true, fetch=FetchType.LAZY)
    @FieldDoc(value="\u041e\u043f\u0435\u0440\u0430\u0446\u0438\u044f", required={"id"})
    private Operation operation;
    @Column(name="signature")
    @FieldDoc(value="\u041f\u043e\u0434\u043f\u0438\u0441\u044c \u0437\u0430\u043f\u0440\u043e\u0441\u0430")
    @JsonIgnore
    private String signature;
    @Transient
    private List<MerchantRequestAttr> merchantRequestAttrs;

    public MerchantRequest() {
    }

    public MerchantRequest(Long id) {
        this.id = id;
    }

    public MerchantRequest(Long id, Merchant merchant, Service service, MerchantReqState merchantState, int sumIn, Date dateAdd, Date dateUpdate, String externalTransaction, String ip, Operation operation, String signature) {
        this.id = id;
        this.merchant = merchant;
        this.service = service;
        this.merchantState = merchantState;
        this.sumIn = sumIn;
        this.dateAdd = dateAdd;
        this.dateUpdate = dateUpdate;
        this.externalTransaction = externalTransaction;
        this.ip = ip;
        this.operation = operation;
        this.signature = signature;
    }

    @Override
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Merchant getMerchant() {
        return this.merchant;
    }

    public void setMerchant(Merchant merchant) {
        this.merchant = merchant;
    }

    public Service getService() {
        return this.service;
    }

    public void setService(Service service) {
        this.service = service;
    }

    public MerchantReqState getMerchantState() {
        return this.merchantState;
    }

    public void setMerchantState(MerchantReqState merchantState) {
        this.merchantState = merchantState;
    }

    public int getSumIn() {
        return this.sumIn;
    }

    public void setSumIn(int sumIn) {
        this.sumIn = sumIn;
    }

    public Date getDateAdd() {
        return this.dateAdd;
    }

    public void setDateAdd(Date dateAdd) {
        this.dateAdd = dateAdd;
    }

    public Date getDateUpdate() {
        return this.dateUpdate;
    }

    public void setDateUpdate(Date dateUpdate) {
        this.dateUpdate = dateUpdate;
    }

    public String getExternalTransaction() {
        return this.externalTransaction;
    }

    public void setExternalTransaction(String externalTransaction) {
        this.externalTransaction = externalTransaction;
    }

    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public Operation getOperation() {
        return this.operation;
    }

    public void setOperation(Operation operation) {
        this.operation = operation;
    }

    public String getSignature() {
        return this.signature;
    }

    public void setSignature(String signature) {
        this.signature = signature;
    }

    public List<MerchantRequestAttr> getMerchantRequestAttrs() {
        return this.merchantRequestAttrs;
    }

    public void setMerchantRequestAttrs(List<MerchantRequestAttr> merchantRequestAttrs) {
        this.merchantRequestAttrs = merchantRequestAttrs;
    }

    public int hashCode() {
        return this._hashCode();
    }

    public boolean equals(Object object) {
        return this._equals(object, MerchantRequest.class);
    }

    public String toString() {
        return "MerchantRequest{id=" + this.id + ", merchant=" + this.merchant + ", service=" + this.service + ", merchantState=" + this.merchantState + ", sumIn=" + this.sumIn + ", dateAdd=" + this.dateAdd + ", dateUpdate=" + this.dateUpdate + ", externalTransaction='" + this.externalTransaction + '\'' + ", ip='" + this.ip + '\'' + ", operation=" + this.operation + ", signature='" + this.signature + '\'' + ", merchantRequestAttrs=" + this.merchantRequestAttrs + '}';
    }
}

