/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.keeper.db.model;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.Date;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import ru.softlogic.keeper.db.model.InterfaceType;
import ru.softlogic.keeper.db.model.MessageTransport;
import ru.softlogic.keeper.db.model.MessageType;
import ru.softlogic.keeper.db.model.common.PrimaryKey;

@Entity
@Table(name="event_message")
@JsonSerialize(include=JsonSerialize.Inclusion.NON_DEFAULT)
public class EventMessage
extends PrimaryKey {
    private static final long serialVersionUID = 1L;
    @Id
    @Column(name="id")
    @SequenceGenerator(name="event_message_id_seq", sequenceName="event_message_id_seq", allocationSize=1)
    @GeneratedValue(generator="event_message_id_seq", strategy=GenerationType.SEQUENCE)
    private Long id;
    @Column(name="event")
    private Long event;
    @Basic(optional=false)
    @Column(name="destination")
    private String destination;
    @Column(name="destination_code")
    private String destinationCode;
    @Column(name="title")
    private String title;
    @Column(name="message")
    private String message;
    @Basic(optional=false)
    @Column(name="date_add")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date dateAdd;
    @Column(name="date_process")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date dateProcess;
    @Basic(optional=false)
    @Column(name="state")
    private short state;
    @JoinColumn(name="message_type", referencedColumnName="id")
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private MessageType messageType;
    @JoinColumn(name="interface_type_add", referencedColumnName="id")
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private InterfaceType interfaceTypeAdd;
    @JoinColumn(name="message_transport", referencedColumnName="id")
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private MessageTransport messageTransport;
    @Column(name="mime")
    private String mime;

    public EventMessage() {
    }

    public EventMessage(Long id) {
        this.id = id;
    }

    public EventMessage(Long id, String destination, Date dateAdd, Date dateProcess, short state) {
        this.id = id;
        this.destination = destination;
        this.dateAdd = dateAdd;
        this.dateProcess = dateProcess;
        this.state = state;
    }

    public String getMime() {
        return this.mime;
    }

    public void setMime(String mime) {
        this.mime = mime;
    }

    @Override
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getEvent() {
        return this.event;
    }

    public void setEvent(Long event) {
        this.event = event;
    }

    public String getDestination() {
        return this.destination;
    }

    public void setDestination(String destination) {
        this.destination = destination;
    }

    public String getDestinationCode() {
        return this.destinationCode;
    }

    public void setDestinationCode(String destinationCode) {
        this.destinationCode = destinationCode;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public Date getDateAdd() {
        return this.dateAdd;
    }

    public void setDateAdd(Date dateAdd) {
        this.dateAdd = dateAdd;
    }

    public Date getDateProcess() {
        return this.dateProcess;
    }

    public void setDateProcess(Date dateProcess) {
        this.dateProcess = dateProcess;
    }

    public short getState() {
        return this.state;
    }

    public void setState(short state) {
        this.state = state;
    }

    public MessageType getMessageType() {
        return this.messageType;
    }

    public void setMessageType(MessageType messageType) {
        this.messageType = messageType;
    }

    public InterfaceType getInterfaceTypeAdd() {
        return this.interfaceTypeAdd;
    }

    public void setInterfaceTypeAdd(InterfaceType interfaceTypeAdd) {
        this.interfaceTypeAdd = interfaceTypeAdd;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public MessageTransport getMessageTransport() {
        return this.messageTransport;
    }

    public void setMessageTransport(MessageTransport messageTransport) {
        this.messageTransport = messageTransport;
    }

    public int hashCode() {
        return this._hashCode();
    }

    public boolean equals(Object object) {
        return this._equals(object, EventMessage.class);
    }

    public String toString() {
        return this._toString(EventMessage.class);
    }
}

