/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.keeper.db.model;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.Date;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.hibernate.annotations.Type;
import ru.softlogic.keeper.annotation.documentation.FieldDoc;
import ru.softlogic.keeper.annotation.documentation.TypeDoc;
import ru.softlogic.keeper.db.model.Area;
import ru.softlogic.keeper.db.model.ClientLocale;
import ru.softlogic.keeper.db.model.InterfaceType;
import ru.softlogic.keeper.db.model.LoginType;
import ru.softlogic.keeper.db.model.common.PhoneNumber;
import ru.softlogic.keeper.db.model.common.PrimaryKey;

@Entity
@Table(name="client")
@JsonSerialize(include=JsonSerialize.Inclusion.NON_DEFAULT)
@TypeDoc(value="\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c (\u043a\u043b\u0438\u0435\u043d\u0442)")
public class Client
extends PrimaryKey {
    public static final short PAY_PASSWORD_TYPE_NOT_DEFINED = 0;
    public static final short PAY_PASSWORD_TYPE_STATIC = 1;
    public static final short PAY_PASSWORD_TYPE_DYNAMIC = 2;
    public static final short SEX_NOT_DEFINED = 0;
    public static final short SEX_FEMALE = 1;
    public static final short SEX_MALE = 2;
    private static final long serialVersionUID = 1L;
    @Id
    @Column(name="id")
    @SequenceGenerator(name="client_id_seq", sequenceName="client_id_seq", allocationSize=1)
    @GeneratedValue(generator="client_id_seq", strategy=GenerationType.SEQUENCE)
    private Long id;
    @Basic(optional=false)
    @Column(name="login")
    @FieldDoc(value="\u0418\u043c\u044f \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f (\u043d\u043e\u043c\u0435\u0440 \u0442\u0435\u043b\u0435\u0444\u043e\u043d\u0430 \u0441 \u043a\u043e\u0434\u043e\u043c \u0441\u0442\u0440\u0430\u043d\u044b)")
    private String login;
    @Basic(optional=false)
    @Column(name="login_number")
    @FieldDoc(value="\u0418\u043c\u044f \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f (\u043d\u043e\u043c\u0435\u0440 \u0442\u0435\u043b\u0435\u0444\u043e\u043d\u0430 \u0431\u0435\u0437 \u043a\u043e\u0434\u0430 \u0441\u0442\u0440\u0430\u043d\u044b)")
    private String loginNumber;
    @Basic(optional=false)
    @Column(name="login_code")
    @FieldDoc(value="\u041a\u043e\u0434 \u0441\u0442\u0440\u0430\u043d\u044b \u043d\u043e\u043c\u0435\u0440\u0430 \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f")
    private String loginCode;
    @Basic(optional=false)
    @Column(name="password_hash")
    @FieldDoc(value="\u0425\u044d\u0448 \u043f\u0430\u0440\u043e\u043b\u044f")
    @JsonIgnore
    private String passwordHash;
    @Basic(optional=false)
    @Column(name="salt")
    @FieldDoc(value="\u0421\u043e\u043b\u044c \u0434\u043b\u044f \u0433\u0435\u043d\u0435\u0440\u0430\u0446\u0438\u0438 \u043f\u0430\u0440\u043e\u043b\u044f")
    @JsonIgnore
    private String salt;
    @Basic(optional=false)
    @Column(name="date_add")
    @Temporal(value=TemporalType.TIMESTAMP)
    @FieldDoc(value="\u0414\u0430\u0442\u0430 \u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u044f")
    private Date dateAdd;
    @Basic(optional=false)
    @Column(name="date_register")
    @Temporal(value=TemporalType.TIMESTAMP)
    @FieldDoc(value="\u0414\u0430\u0442\u0430 \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0438")
    private Date dateRegister;
    @Basic(optional=false)
    @Column(name="date_update")
    @Temporal(value=TemporalType.TIMESTAMP)
    @FieldDoc(value="\u0414\u0430\u0442\u0430 \u043f\u043e\u0441\u043b\u0435\u0434\u043d\u0435\u0433\u043e \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f")
    private Date dateUpdate;
    @Basic(optional=false)
    @Column(name="blocked", columnDefinition="smallint")
    @Type(type="numeric_boolean")
    @FieldDoc(value="\u0411\u043b\u043e\u043a\u0438\u0440\u043e\u0432\u0430\u043d")
    private boolean blocked;
    @Basic(optional=false)
    @Column(name="incorrect_login_count")
    @FieldDoc(value="\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u043d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u044b\u0445 \u0432\u0432\u043e\u0434\u043e\u0432 \u043f\u0430\u0440\u043e\u043b\u0435\u0439")
    private short incorrectLoginCount;
    @Basic(optional=false)
    @Column(name="admin_blocked", columnDefinition="smallint")
    @Type(type="numeric_boolean")
    @FieldDoc(value="\u0410\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0442\u0438\u0432\u043d\u0430\u044f \u0431\u043b\u043e\u043a\u0438\u0440\u043e\u0432\u043a\u0430 \u043a\u043b\u0438\u0435\u043d\u0442\u0430 (\u0441\u043d\u0438\u043c\u0430\u0435\u0442\u0441\u044f \u0442\u043e\u043b\u044c\u043a\u043e \u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0442\u043e\u0440\u043e\u043c \u0441\u0438\u0441\u0442\u0435\u043c\u044b)")
    private boolean adminBlocked;
    @Basic(optional=false)
    @Column(name="deleted", columnDefinition="smallint")
    @Type(type="numeric_boolean")
    private boolean deleted;
    @Basic(optional=false)
    @Column(name="anonymous", columnDefinition="smallint")
    @Type(type="numeric_boolean")
    @FieldDoc(value="\u041f\u0440\u0438\u0437\u043d\u0430\u043a \u0430\u043d\u043e\u043d\u0438\u043c\u043d\u043e\u0433\u043e \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f")
    private boolean anonymous;
    @Column(name="first_name")
    @FieldDoc(value="\u0418\u043c\u044f")
    private String firstName;
    @Column(name="middle_name")
    @FieldDoc(value="\u041e\u0442\u0447\u0435\u0441\u0442\u0432\u043e")
    private String middleName;
    @Column(name="last_name")
    @FieldDoc(value="\u0424\u0430\u043c\u0438\u043b\u0438\u044f")
    private String lastName;
    @Column(name="birth_date")
    @Temporal(value=TemporalType.DATE)
    @FieldDoc(value="\u0414\u0430\u0442\u0430 \u0440\u043e\u0436\u0434\u0435\u043d\u0438\u044f \u0432 \u0444\u043e\u0440\u043c\u0430\u0442\u0435: yyyy-MM-dd")
    @JsonFormat(pattern="yyyy-MM-dd")
    private Date birthDate;
    @Basic(optional=false)
    @Column(name="sex")
    @FieldDoc(value="\u041f\u043e\u043b: 0 - \u043d\u0435 \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d\u043e, 1 - \u0436\u0435\u043d\u0449\u0438\u043d\u0430, 2 - \u043c\u0443\u0436\u0447\u0438\u043d\u0430")
    private short sex;
    @Column(name="time_zone")
    @FieldDoc(value="\u0427\u0430\u0441\u043e\u0432\u043e\u0439 \u043f\u043e\u044f\u0441")
    private String timeZone;
    @Column(name="email")
    @FieldDoc(value="\u042d\u043b\u0435\u043a\u0442\u0440\u043e\u043d\u043d\u044b\u0439 \u0430\u0434\u0440\u0435\u0441")
    private String email;
    @Column(name="sms_phone")
    @FieldDoc(value="\u041d\u043e\u043c\u0435\u0440 \u0442\u0435\u043b\u0435\u0444\u043e\u043d\u0430 \u0434\u043b\u044f \u0421\u041c\u0421 \u0441 \u043a\u043e\u0434\u043e\u043c \u0441\u0442\u0440\u0430\u043d\u044b")
    private String smsPhone;
    @Column(name="sms_phone_number")
    @FieldDoc(value="\u041d\u043e\u043c\u0435\u0440 \u0442\u0435\u043b\u0435\u0444\u043e\u043d\u0430 \u0434\u043b\u044f \u0421\u041c\u0421 \u0441 \u0431\u0435\u0437 \u043a\u043e\u0434\u0430 \u0441\u0442\u0440\u0430\u043d\u044b")
    private String smsPhoneNumber;
    @Column(name="sms_phone_code")
    @FieldDoc(value="\u041a\u043e\u0434 \u0441\u0442\u0440\u0430\u043d\u044b \u043d\u043e\u043c\u0435\u0440\u0430 \u0442\u0435\u043b\u0435\u0444\u043e\u043d\u0430 \u0434\u043b\u044f \u0421\u041c\u0421")
    private String smsPhoneCode;
    @Basic(optional=false)
    @Column(name="pay_password_type")
    @FieldDoc(value="0 - \u043d\u0438\u0447\u0435\u0433\u043e, 1 -\u0441\u0442\u0430\u0442\u0438\u0447\u0435\u0441\u043a\u0438\u0439, 2 - \u0434\u0438\u043d\u0430\u043c\u0438\u0447\u0435\u0441\u043a\u0438\u0439")
    private short payPasswordType;
    @Column(name="static_pay_password_hash")
    @FieldDoc(value="\u0425\u0435\u0448 \u0441\u0442\u0430\u0442\u0438\u0447\u0435\u0441\u043a\u043e\u0433\u043e \u043f\u0430\u0440\u043e\u043b\u044f \u043e\u043f\u043b\u0430\u0442\u044b")
    private String staticPayPasswordHash;
    @Basic(optional=false)
    @Column(name="operation_count")
    @FieldDoc(value="\u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u043f\u043e\u0441\u043b\u0435\u0434\u043d\u0438\u0445 \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u0439 \u0432\u044b\u0432\u043e\u0434\u0438\u043c\u044b\u0445 \u043d\u0430 \u043f\u0435\u0440\u0432\u043e\u0439 \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u0435 \u0432 \u0432\u044d\u0431")
    private short operationCount;
    @Basic(optional=false)
    @Column(name="receipt_count")
    @FieldDoc(value="\u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u043f\u043e\u0441\u043b\u0435\u0434\u043d\u0438\u0445  \u043f\u043e\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0439 \u0432\u044b\u0432\u043e\u0434\u0438\u043c\u044b\u0445 \u043d\u0430 \u043f\u0435\u0440\u0432\u043e\u0439 \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u0435 \u0432 \u0432\u044d\u0431")
    private short receiptCount;
    @Basic(optional=false)
    @Column(name="template_count")
    @FieldDoc(value="\u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u043f\u043e\u0441\u043b\u0435\u0434\u043d\u0438\u0445 \u0448\u0430\u0431\u043b\u043e\u043d\u043e\u0432 \u0432\u044b\u0432\u043e\u0434\u0438\u043c\u044b\u0445 \u043d\u0430 \u043f\u0435\u0440\u0432\u043e\u0439 \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u0435 \u0432 \u0432\u044d\u0431")
    private short templateCount;
    @Column(name="secret_key")
    @FieldDoc(value="\u0441\u0435\u043a\u0440\u0435\u0442\u043d\u044b\u0439 \u043a\u043b\u044e\u0447")
    @JsonIgnore
    private String secretKey;
    @Basic(optional=false)
    @Column(name="accept_oferta", columnDefinition="smallint")
    @Type(type="numeric_boolean")
    @FieldDoc(value="\u0441\u043e\u0433\u043b\u0430\u0441\u0438\u0435 \u0441 \u043e\u0444\u0435\u0440\u0442\u043e\u0439")
    private boolean acceptOferta;
    @JoinColumn(name="interface_type_update", referencedColumnName="id")
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    @FieldDoc(value="\u0422\u0438\u043f \u0438\u043d\u0442\u0435\u0440\u0444\u0435\u0439\u0441\u0430 \u043f\u0440\u0438 \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0438", required={"id"})
    private InterfaceType interfaceTypeUpdate;
    @JoinColumn(name="interface_type_register", referencedColumnName="id")
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    @FieldDoc(value="\u0422\u0438\u043f \u0438\u043d\u0442\u0435\u0440\u0444\u0435\u0439\u0441\u0430 \u043f\u0440\u0438 \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0438", required={"id"})
    private InterfaceType interfaceTypeRegister;
    @JoinColumn(name="interface_type_add", referencedColumnName="id")
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    @FieldDoc(value="\u0422\u0438\u043f \u0438\u043d\u0442\u0435\u0440\u0444\u0435\u0439\u0441\u0430 \u043f\u0440\u0438 \u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u0438", required={"id"})
    private InterfaceType interfaceTypeAdd;
    @JoinColumn(name="sms_phone_area", referencedColumnName="id")
    @ManyToOne(fetch=FetchType.LAZY)
    @FieldDoc(value="\u0421\u0442\u0440\u0430\u043d\u0430 \u043f\u0440\u0438 \u043e\u0442\u043f\u0440\u0430\u0432\u043a\u0435 \u0421\u041c\u0421", required={"id"})
    private Area smsPhoneArea;
    @JoinColumn(name="area", referencedColumnName="id")
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    @FieldDoc(value="\u0421\u0442\u0440\u0430\u043d\u0430", required={"id"})
    private Area area;
    @JoinColumn(name="client_locale", referencedColumnName="id")
    @ManyToOne(fetch=FetchType.LAZY)
    @FieldDoc(value="\u041b\u043e\u043a\u0430\u043b\u044c (\u044f\u0437\u044b\u043a)", required={"id"})
    private ClientLocale clientLocale;
    @Column(name="ip_register")
    @FieldDoc(value="IP-\u0430\u0434\u0440\u0435\u0441 \u043f\u0440\u0438 \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0438")
    private String ipRegister;
    @Basic(optional=true)
    @Column(name="external_identifier")
    private String externalIdentifier;
    @Basic(optional=false)
    @Column(name="incorrect_recovery_count")
    @FieldDoc(value="\u0427\u0438\u0441\u043b\u043e \u043f\u043e\u043f\u044b\u0442\u043e\u043a \u0432\u043e\u0441\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u044f \u043f\u0430\u0440\u043e\u043b\u044f")
    private short incorrectRecoveryCount;
    @Basic(optional=false)
    @Column(name="date_recovery")
    @Temporal(value=TemporalType.TIMESTAMP)
    @FieldDoc(value="\u0414\u0430\u0442\u0430 \u043f\u0435\u0440\u0432\u043e\u0439 \u043f\u043e\u043f\u044b\u0442\u043a\u0438 \u0432\u043e\u0441\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u044f \u0437\u0430 \u043f\u043e\u0441\u043b\u0435\u0434\u043d\u0438\u0435 \u0441\u0443\u0442\u043a\u0438")
    private Date dateRecovery;
    @Basic(optional=true)
    @Column(name="passport_serie")
    @FieldDoc(value="\u0421\u0435\u0440\u0438\u044f \u043f\u0430\u0441\u043f\u043e\u0440\u0442\u0430")
    private String passportSerie;
    @Basic(optional=true)
    @Column(name="passport_number")
    @FieldDoc(value="\u041d\u043e\u043c\u0435\u0440 \u043f\u0430\u0441\u043f\u043e\u0440\u0442\u0430")
    private String passportNumber;
    @Basic(optional=true)
    @Column(name="passport_issue_date")
    @Temporal(value=TemporalType.DATE)
    @FieldDoc(value="\u0414\u0430\u0442\u0430 \u0432\u044b\u0434\u0430\u0447\u0438 \u043f\u0430\u0441\u043f\u043e\u0440\u0442\u0430 \u0432 \u0444\u043e\u0440\u043c\u0430\u0442\u0435: yyyy-MM-dd")
    @JsonFormat(pattern="yyyy-MM-dd")
    private Date passportIssueDate;
    @Basic(optional=true)
    @Column(name="passport_issued_by")
    @FieldDoc(value="\u041a\u0435\u043c \u0432\u044b\u0434\u0430\u043d \u043f\u0430\u0441\u043f\u043e\u0440\u0442")
    private String passportIssuedBy;
    @Basic(optional=true)
    @Column(name="registration_address")
    @FieldDoc(value="\u0410\u0434\u0440\u0435\u0441 \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0438/\u043f\u0440\u043e\u043f\u0438\u0441\u043a\u0438")
    private String registrationAddress;
    @JoinColumn(name="login_type", referencedColumnName="id")
    @ManyToOne(fetch=FetchType.LAZY)
    @FieldDoc(value="\u0422\u0438\u043f \u0430\u0432\u0442\u043e\u0440\u0438\u0437\u0430\u0446\u0438\u0438", required={"id"})
    private LoginType loginType;
    @Column(name="password_changed_date")
    @Temporal(value=TemporalType.TIMESTAMP)
    @FieldDoc(value="\u0414\u0430\u0442\u0430 \u0441\u043c\u0435\u043d\u044b \u043f\u0430\u0440\u043e\u043b\u044f")
    private Date passwordChangedDate;
    @Column(name="referer")
    @FieldDoc(value="\u041e\u0442\u043a\u0443\u0434\u0430 \u0437\u0430\u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0438\u0440\u043e\u0432\u0430\u0434\u0441\u044f \u043a\u043b\u0438\u0435\u043d\u0442")
    private String referer;
    @Column(name="city")
    @FieldDoc(value="\u0413\u043e\u0440\u043e\u0434")
    private String city;
    @Column(name="street")
    @FieldDoc(value="\u0423\u043b\u0438\u0446\u0430")
    private String street;
    @Column(name="building")
    @FieldDoc(value="\u0414\u043e\u043c")
    private String building;
    @Column(name="room")
    @FieldDoc(value="\u041a\u0432\u0430\u0440\u0442\u0438\u0440\u0430")
    private String room;

    public Client() {
    }

    public Client(Long id) {
        this.id = id;
    }

    public Client(Long id, String login, String loginNumber, String loginCode, String passwordHash, Date dateAdd, Date dateRegister, Date dateUpdate, boolean blocked, boolean adminBlocked, boolean deleted, boolean anonymous, short sex, short payPasswordType, short operationCount, short receiptCount, short templateCount, boolean acceptOferta, Date passwordChangedDate) {
        this.id = id;
        this.login = login;
        this.loginNumber = loginNumber;
        this.loginCode = loginCode;
        this.passwordHash = passwordHash;
        this.dateAdd = new Date(dateAdd.getTime());
        this.dateRegister = dateRegister;
        this.dateUpdate = dateUpdate;
        this.blocked = blocked;
        this.adminBlocked = adminBlocked;
        this.deleted = deleted;
        this.anonymous = anonymous;
        this.sex = sex;
        this.payPasswordType = payPasswordType;
        this.operationCount = operationCount;
        this.receiptCount = receiptCount;
        this.templateCount = templateCount;
        this.acceptOferta = acceptOferta;
        this.passwordChangedDate = passwordChangedDate;
    }

    public String getCity() {
        return this.city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public String getStreet() {
        return this.street;
    }

    public void setStreet(String street) {
        this.street = street;
    }

    public String getBuilding() {
        return this.building;
    }

    public void setBuilding(String building) {
        this.building = building;
    }

    public String getRoom() {
        return this.room;
    }

    public void setRoom(String room) {
        this.room = room;
    }

    public String toString() {
        return "Client{id=" + this.id + ", login='" + this.login + '\'' + ", loginNumber='" + this.loginNumber + '\'' + ", loginCode='" + this.loginCode + '\'' + ", passwordHash='" + this.passwordHash + '\'' + ", salt='" + this.salt + '\'' + ", dateAdd=" + this.dateAdd + ", dateRegister=" + this.dateRegister + ", dateUpdate=" + this.dateUpdate + ", blocked=" + this.blocked + ", incorrectLoginCount=" + this.incorrectLoginCount + ", adminBlocked=" + this.adminBlocked + ", deleted=" + this.deleted + ", anonymous=" + this.anonymous + ", firstName='" + this.firstName + '\'' + ", middleName='" + this.middleName + '\'' + ", lastName='" + this.lastName + '\'' + ", birthDate=" + this.birthDate + ", sex=" + this.sex + ", timeZone='" + this.timeZone + '\'' + ", email='" + this.email + '\'' + ", smsPhone='" + this.smsPhone + '\'' + ", smsPhoneNumber='" + this.smsPhoneNumber + '\'' + ", smsPhoneCode='" + this.smsPhoneCode + '\'' + ", payPasswordType=" + this.payPasswordType + ", staticPayPasswordHash='" + this.staticPayPasswordHash + '\'' + ", operationCount=" + this.operationCount + ", receiptCount=" + this.receiptCount + ", templateCount=" + this.templateCount + ", secretKey='" + this.secretKey + '\'' + ", acceptOferta=" + this.acceptOferta + ", interfaceTypeUpdate=" + this.interfaceTypeUpdate + ", interfaceTypeRegister=" + this.interfaceTypeRegister + ", interfaceTypeAdd=" + this.interfaceTypeAdd + ", smsPhoneArea=" + this.smsPhoneArea + ", area=" + this.area + ", clientLocale=" + this.clientLocale + ", ipRegister='" + this.ipRegister + '\'' + ", externalIdentifier='" + this.externalIdentifier + '\'' + ", incorrectRecoveryCount=" + this.incorrectRecoveryCount + ", dateRecovery=" + this.dateRecovery + ", passportSerie='" + this.passportSerie + '\'' + ", passportNumber='" + this.passportNumber + '\'' + ", passportIssueDate=" + this.passportIssueDate + ", passportIssuedBy='" + this.passportIssuedBy + '\'' + ", registrationAddress='" + this.registrationAddress + '\'' + ", loginType=" + this.loginType + ", passwordChangedDate=" + this.passwordChangedDate + ", referer='" + this.referer + '\'' + '}';
    }

    public LoginType getLoginType() {
        return this.loginType;
    }

    public void setLoginType(LoginType loginType) {
        this.loginType = loginType;
    }

    public short getIncorrectRecoveryCount() {
        return this.incorrectRecoveryCount;
    }

    public void setIncorrectRecoveryCount(short incorrectRecoveryCount) {
        this.incorrectRecoveryCount = incorrectRecoveryCount;
    }

    public Date getDateRecovery() {
        return this.dateRecovery;
    }

    public void setDateRecovery(Date dateRecovery) {
        this.dateRecovery = dateRecovery;
    }

    @Override
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @JsonIgnore
    public PhoneNumber getLoginObject() {
        return PhoneNumber.create(this.getLoginNumber(), this.getLoginCode());
    }

    public String getLogin() {
        return this.login;
    }

    public void setLogin(String login) {
        this.login = login;
    }

    public String getLoginNumber() {
        return this.loginNumber;
    }

    public void setLoginNumber(String loginNumber) {
        this.loginNumber = loginNumber;
    }

    public String getLoginCode() {
        return this.loginCode;
    }

    public void setLoginCode(String loginCode) {
        this.loginCode = loginCode;
    }

    public String getPasswordHash() {
        return this.passwordHash;
    }

    public void setPasswordHash(String passwordHash) {
        this.passwordHash = passwordHash;
    }

    public String getSalt() {
        return this.salt;
    }

    public void setSalt(String salt) {
        this.salt = salt;
    }

    public Date getDateAdd() {
        return this.dateAdd;
    }

    public void setDateAdd(Date dateAdd) {
        this.dateAdd = dateAdd;
    }

    public Date getDateRegister() {
        return this.dateRegister;
    }

    public void setDateRegister(Date dateRegister) {
        this.dateRegister = dateRegister;
    }

    public Date getDateUpdate() {
        return this.dateUpdate;
    }

    public void setDateUpdate(Date dateUpdate) {
        this.dateUpdate = dateUpdate;
    }

    public boolean isBlocked() {
        return this.blocked;
    }

    public void setBlocked(boolean blocked) {
        this.blocked = blocked;
    }

    public short getIncorrectLoginCount() {
        return this.incorrectLoginCount;
    }

    public void setIncorrectLoginCount(short incorrectLoginCount) {
        this.incorrectLoginCount = incorrectLoginCount;
    }

    public boolean isAdminBlocked() {
        return this.adminBlocked;
    }

    public void setAdminBlocked(boolean adminBlocked) {
        this.adminBlocked = adminBlocked;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    public boolean isAnonymous() {
        return this.anonymous;
    }

    public void setAnonymous(boolean anonymous) {
        this.anonymous = anonymous;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public String getMiddleName() {
        return this.middleName;
    }

    public void setMiddleName(String middleName) {
        this.middleName = middleName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public Date getBirthDate() {
        return this.birthDate;
    }

    public void setBirthDate(Date birthDate) {
        this.birthDate = birthDate;
    }

    public short getSex() {
        return this.sex;
    }

    public void setSex(short sex) {
        this.sex = sex;
    }

    public String getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(String timeZone) {
        this.timeZone = timeZone;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getSmsPhone() {
        return this.smsPhone;
    }

    public void setSmsPhone(String smsPhone) {
        this.smsPhone = smsPhone;
    }

    public String getSmsPhoneNumber() {
        return this.smsPhoneNumber;
    }

    public void setSmsPhoneNumber(String smsPhoneNumber) {
        this.smsPhoneNumber = smsPhoneNumber;
    }

    public String getSmsPhoneCode() {
        return this.smsPhoneCode;
    }

    public void setSmsPhoneCode(String smsPhoneCode) {
        this.smsPhoneCode = smsPhoneCode;
    }

    @JsonIgnore
    public PhoneNumber getSmsPhoneObject() {
        return PhoneNumber.create(this.getSmsPhoneNumber(), this.getSmsPhoneCode());
    }

    public short getPayPasswordType() {
        return this.payPasswordType;
    }

    public void setPayPasswordType(short payPasswordType) {
        this.payPasswordType = payPasswordType;
    }

    public String getStaticPayPasswordHash() {
        return this.staticPayPasswordHash;
    }

    public void setStaticPayPasswordHash(String staticPayPasswordHash) {
        this.staticPayPasswordHash = staticPayPasswordHash;
    }

    public short getOperationCount() {
        return this.operationCount;
    }

    public void setOperationCount(short operationCount) {
        this.operationCount = operationCount;
    }

    public short getReceiptCount() {
        return this.receiptCount;
    }

    public void setReceiptCount(short receiptCount) {
        this.receiptCount = receiptCount;
    }

    public short getTemplateCount() {
        return this.templateCount;
    }

    public void setTemplateCount(short templateCount) {
        this.templateCount = templateCount;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public boolean isAcceptOferta() {
        return this.acceptOferta;
    }

    public void setAcceptOferta(boolean acceptOferta) {
        this.acceptOferta = acceptOferta;
    }

    public InterfaceType getInterfaceTypeUpdate() {
        return this.interfaceTypeUpdate;
    }

    public void setInterfaceTypeUpdate(InterfaceType interfaceTypeUpdate) {
        this.interfaceTypeUpdate = interfaceTypeUpdate;
    }

    public InterfaceType getInterfaceTypeRegister() {
        return this.interfaceTypeRegister;
    }

    public void setInterfaceTypeRegister(InterfaceType interfaceTypeRegister) {
        this.interfaceTypeRegister = interfaceTypeRegister;
    }

    public InterfaceType getInterfaceTypeAdd() {
        return this.interfaceTypeAdd;
    }

    public void setInterfaceTypeAdd(InterfaceType interfaceTypeAdd) {
        this.interfaceTypeAdd = interfaceTypeAdd;
    }

    public Area getSmsPhoneArea() {
        return this.smsPhoneArea;
    }

    public void setSmsPhoneArea(Area smsPhoneArea) {
        this.smsPhoneArea = smsPhoneArea;
    }

    public Area getArea() {
        return this.area;
    }

    public void setArea(Area area) {
        this.area = area;
    }

    public ClientLocale getClientLocale() {
        return this.clientLocale;
    }

    public void setClientLocale(ClientLocale clientLocale) {
        this.clientLocale = clientLocale;
    }

    public String getIpRegister() {
        return this.ipRegister;
    }

    public void setIpRegister(String ipRegister) {
        this.ipRegister = ipRegister;
    }

    public String getExternalIdentifier() {
        return this.externalIdentifier;
    }

    public void setExternalIdentifier(String externalIdentifier) {
        this.externalIdentifier = externalIdentifier;
    }

    public String getPassportSerie() {
        return this.passportSerie;
    }

    public void setPassportSerie(String passportSerie) {
        this.passportSerie = passportSerie;
    }

    public String getPassportNumber() {
        return this.passportNumber;
    }

    public void setPassportNumber(String passportNumber) {
        this.passportNumber = passportNumber;
    }

    public Date getPassportIssueDate() {
        return this.passportIssueDate;
    }

    public void setPassportIssueDate(Date passportIssueDate) {
        this.passportIssueDate = passportIssueDate;
    }

    public String getPassportIssuedBy() {
        return this.passportIssuedBy;
    }

    public void setPassportIssuedBy(String passportIssuedBy) {
        this.passportIssuedBy = passportIssuedBy;
    }

    public String getRegistrationAddress() {
        return this.registrationAddress;
    }

    public void setRegistrationAddress(String registrationAddress) {
        this.registrationAddress = registrationAddress;
    }

    public Date getPasswordChangeDate() {
        return this.passwordChangedDate;
    }

    public void setPasswordChangeDate(Date passwordChangeDate) {
        this.passwordChangedDate = passwordChangeDate;
    }

    public int hashCode() {
        return this._hashCode();
    }

    public boolean equals(Object object) {
        return this._equals(object, Client.class);
    }

    public String getReferer() {
        return this.referer;
    }

    public void setReferer(String referer) {
        this.referer = referer;
    }
}

