/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.keeper.db.model;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.Date;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import ru.softlogic.keeper.annotation.documentation.FieldDoc;
import ru.softlogic.keeper.db.model.AutoPaymentInterval;
import ru.softlogic.keeper.db.model.CashSource;
import ru.softlogic.keeper.db.model.Template;
import ru.softlogic.keeper.db.model.common.PrimaryKey;

@Entity
@Table(name="auto_payment")
@JsonSerialize(include=JsonSerialize.Inclusion.NON_DEFAULT)
public class AutoPayment
extends PrimaryKey {
    private static final long serialVersionUID = 1L;
    @Id
    @Column(name="id")
    private Long id;
    @Basic(optional=false)
    @Column(name="dbegin")
    @Temporal(value=TemporalType.DATE)
    @JsonFormat(pattern="yyyy-MM-dd")
    private Date dbegin;
    @Column(name="dend")
    @Temporal(value=TemporalType.DATE)
    @JsonFormat(pattern="yyyy-MM-dd")
    private Date dend;
    @JoinColumn(name="id", referencedColumnName="id", insertable=false, updatable=false)
    @OneToOne(optional=false, fetch=FetchType.LAZY)
    private Template template;
    @JoinColumn(name="auto_payment_interval", referencedColumnName="id")
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private AutoPaymentInterval autoPaymentInterval;
    @Basic(optional=false)
    @Column(name="execute_hour")
    private short executeHour;
    @Column(name="last_execution_date")
    @Temporal(value=TemporalType.DATE)
    @JsonFormat(pattern="yyyy-MM-dd")
    private Date lastExecutionDate;
    @Basic(optional=false)
    @Column(name="date_add", insertable=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date dateAdd;
    @Basic(optional=false)
    @Column(name="execute_today")
    private boolean executeToday;
    @JoinColumn(name="cash_source", referencedColumnName="id")
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    @FieldDoc(value="\u0418\u0441\u0442\u043e\u0447\u043d\u0438\u043a \u043f\u043b\u0430\u0442\u0435\u0436\u0430", required={"id"})
    private CashSource cashSource;
    @Column(name="state")
    @FieldDoc(value="\u0421\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u0435 \u0430\u0432\u0442\u043e\u043f\u043b\u0430\u0442\u0435\u0436\u0430", constraints={"0 - \u0413\u043e\u0442\u043e\u0432 \u043a \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0435", "1 - \u0422\u0440\u0435\u0431\u0443\u0435\u0442 \u043f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u0438\u044f \u043f\u0430\u0440\u043e\u043b\u0435\u043c"})
    private short state;

    public AutoPayment() {
    }

    public AutoPayment(Long id) {
        this.id = id;
    }

    public AutoPayment(Long id, Date dbegin) {
        this.id = id;
        this.dbegin = dbegin;
    }

    @Override
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Date getDbegin() {
        return this.dbegin;
    }

    public void setDbegin(Date dbegin) {
        this.dbegin = dbegin;
    }

    public Date getDend() {
        return this.dend;
    }

    public void setDend(Date dend) {
        this.dend = dend;
    }

    public Template getTemplate() {
        return this.template;
    }

    public void setTemplate(Template template) {
        this.template = template;
    }

    public AutoPaymentInterval getAutoPaymentInterval() {
        return this.autoPaymentInterval;
    }

    public void setAutoPaymentInterval(AutoPaymentInterval autoPaymentInterval) {
        this.autoPaymentInterval = autoPaymentInterval;
    }

    public short getExecuteHour() {
        return this.executeHour;
    }

    public void setExecuteHour(short executeHour) {
        this.executeHour = executeHour;
    }

    public Date getLastExecutionDate() {
        return this.lastExecutionDate;
    }

    public void setLastExecutionDate(Date lastExecutionDate) {
        this.lastExecutionDate = lastExecutionDate;
    }

    public Date getDateAdd() {
        return this.dateAdd;
    }

    public void setDateAdd(Date dateAdd) {
        this.dateAdd = dateAdd;
    }

    public boolean isExecuteToday() {
        return this.executeToday;
    }

    public void setExecuteToday(boolean executeToday) {
        this.executeToday = executeToday;
    }

    public CashSource getCashSource() {
        return this.cashSource;
    }

    public void setCashSource(CashSource cashSource) {
        this.cashSource = cashSource;
    }

    public short getState() {
        return this.state;
    }

    public void setState(short state) {
        this.state = state;
    }

    public int hashCode() {
        return this._hashCode();
    }

    public boolean equals(Object object) {
        return this._equals(object, AutoPayment.class);
    }

    public String toString() {
        return "AutoPayment{id=" + this.id + ", dbegin=" + this.dbegin + ", dend=" + this.dend + ", template=" + this.template + ", autoPaymentInterval=" + this.autoPaymentInterval + ", executeHour=" + this.executeHour + ", lastExecutionDate=" + this.lastExecutionDate + ", dateAdd=" + this.dateAdd + ", executeToday=" + this.executeToday + ", cashSource=" + this.cashSource + ", state=" + this.state + '}';
    }
}

