/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.keeper.api.model.commission;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.util.Collection;
import java.util.Set;
import ru.softlogic.keeper.db.model.Commission;
import ru.softlogic.keeper.db.model.CommissionProfile;

public class CommissionInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final double EPSILON = 1.0E-5;
    private final CommissionProfile commissionProfile;
    private final Set<Commission> steps;

    public CommissionInfo(CommissionProfile commissionProfile, Set<Commission> steps) {
        this.commissionProfile = commissionProfile;
        this.steps = steps;
    }

    public static boolean isZeroCommission(CommissionProfile commissionProfile, Collection<Commission> steps) {
        boolean result;
        boolean bl = result = commissionProfile == null && (steps == null || steps.isEmpty());
        if (result) {
            return result;
        }
        boolean bl2 = result = Math.abs(commissionProfile.getValue()) < 1.0E-5 && commissionProfile.getFixValue() == 0 && commissionProfile.getMinComm() == null && steps.isEmpty();
        if (result) {
            return result;
        }
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CommissionInfo that = (CommissionInfo)o;
        if (this.commissionProfile != null ? !this.commissionProfile.equals(that.commissionProfile) : that.commissionProfile != null) {
            return false;
        }
        return !(this.steps != null ? !this.steps.equals(that.steps) : that.steps != null);
    }

    public int hashCode() {
        int result = this.commissionProfile != null ? this.commissionProfile.hashCode() : 0;
        return 31 * result + (this.steps != null ? this.steps.hashCode() : 0);
    }

    public CommissionProfile getCommissionProfile() {
        return this.commissionProfile;
    }

    public Set<Commission> getSteps() {
        return this.steps;
    }

    @JsonIgnore
    public Set<Commission> getDescendingSteps(DescendingConverter converter) {
        return converter.convert(this.steps);
    }

    @JsonIgnore
    public CommissionType getType() {
        return this.getCommissionProfile().getType() == 0 ? CommissionType.DIRECT : CommissionType.INVERSE;
    }

    @JsonIgnore
    public boolean isZero() {
        return CommissionInfo.isZeroCommission(this.commissionProfile, this.steps);
    }

    public String toString() {
        return "CommissionInfo [commissionProfile=" + this.commissionProfile + ", steps=" + this.steps + ']';
    }

    public static interface DescendingConverter {
        public Set<Commission> convert(Set<Commission> var1);
    }

    public static enum CommissionType {
        DIRECT,
        INVERSE;

    }
}

