/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.keeper.api.model.commission;

import java.util.Set;
import java.util.TreeSet;
import ru.softlogic.keeper.api.model.commission.CommissionInfo;
import ru.softlogic.keeper.api.model.commission.SumResult;
import ru.softlogic.keeper.db.model.Commission;

public class CommissionCalculator {
    private final CommissionInfo.DescendingConverter descendingConverter;

    public CommissionCalculator() {
        this.descendingConverter = new CommissionInfo.DescendingConverter(){

            @Override
            public Set<Commission> convert(Set<Commission> values) {
                return new TreeSet<Commission>(values).descendingSet();
            }
        };
    }

    public CommissionCalculator(CommissionInfo.DescendingConverter descendingConverter) {
        this.descendingConverter = descendingConverter;
    }

    public SumResult calculate(int sumIn, CommissionInfo commission, CommissionInfo minCommission, CommissionInfo maxCommission, Integer trade, short processingPaymentSourceId) {
        SumResult serviceResult;
        SumResult dealerResult = this.calculate(sumIn, commission, trade, processingPaymentSourceId);
        if (maxCommission != null && (serviceResult = this.calculate(sumIn, maxCommission, trade, processingPaymentSourceId)).getCommission() < dealerResult.getCommission()) {
            dealerResult = serviceResult;
        }
        if (minCommission != null && (serviceResult = this.calculate(sumIn, minCommission, trade, processingPaymentSourceId)).getCommission() > dealerResult.getCommission()) {
            dealerResult = serviceResult;
        }
        return dealerResult;
    }

    private SumResult calculate(int sumIn, CommissionInfo commission, Integer trade, short processingPaymentSourceId) {
        int rest;
        if (sumIn < 0) {
            throw new IllegalArgumentException("\u0421\u0443\u043c\u043c\u0430 \u043f\u043b\u0430\u0442\u0435\u0436\u0430 \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043e\u0442\u0440\u0438\u0446\u0430\u0442\u0435\u043b\u044c\u043d\u043e\u0439");
        }
        if (commission == null) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u043a\u043e\u043c\u0438\u0441\u0441\u0438\u0438 \u043d\u0435 \u0434\u043e\u043b\u0436\u043d\u044b \u0431\u044b\u0442\u044c \u043f\u0443\u0441\u0442\u044b\u043c\u0438");
        }
        int baseSum = trade != null && trade != 0 ? trade : sumIn;
        double percentValue = commission.getCommissionProfile().getValue();
        int fixedValue = commission.getCommissionProfile().getFixValue();
        Boolean usePaymentSources = commission.getCommissionProfile().getUsePaymentSources();
        Commission cs = null;
        if (commission.getSteps() != null && !commission.getSteps().isEmpty()) {
            Set<Commission> descSet = commission.getDescendingSteps(this.descendingConverter);
            for (Commission step : descSet) {
                if (step.getProcessingPaymentSource() == null || step.getProcessingPaymentSource().getId() == null) {
                    throw new IllegalArgumentException(String.format("Step with id = '%s', processingPaymentSource is null", step.getId()));
                }
                if (step.getSumComm() > (long)baseSum || (!usePaymentSources.booleanValue() || !step.getProcessingPaymentSource().getId().equals(processingPaymentSourceId)) && (usePaymentSources.booleanValue() || !step.getProcessingPaymentSource().getId().equals((short)0))) continue;
                cs = step;
                percentValue = step.getValue();
                fixedValue = step.getFixValue();
                break;
            }
        }
        int sumCommission = 0;
        switch (commission.getType()) {
            case DIRECT: {
                sumCommission = Math.round((float)((double)baseSum * percentValue / 100.0));
                break;
            }
            case INVERSE: {
                sumCommission = Math.round((float)((double)baseSum * percentValue / (100.0 + percentValue)));
                break;
            }
        }
        if (cs != null && cs.getMinComm() != null && (sumCommission += fixedValue) < cs.getMinComm()) {
            sumCommission = cs.getMinComm();
        } else if (commission.getCommissionProfile().getMinComm() != null && commission.getCommissionProfile().getMinComm() != 0 && sumCommission < commission.getCommissionProfile().getMinComm()) {
            sumCommission = commission.getCommissionProfile().getMinComm();
        }
        if (cs != null && cs.getMaxComm() != null && sumCommission > cs.getMaxComm()) {
            sumCommission = cs.getMaxComm();
        } else if (commission.getCommissionProfile().getMaxComm() != null && commission.getCommissionProfile().getMaxComm() != 0 && sumCommission > commission.getCommissionProfile().getMaxComm()) {
            sumCommission = commission.getCommissionProfile().getMaxComm();
        }
        if (commission.getCommissionProfile().getRoundOrder() != null && commission.getCommissionProfile().getRoundOrder() > 0 && (rest = sumCommission % commission.getCommissionProfile().getRoundOrder()) != 0) {
            sumCommission = sumCommission + commission.getCommissionProfile().getRoundOrder() - rest;
        }
        if (sumCommission > sumIn) {
            return new SumResult(0, 0, sumIn);
        }
        int sumOut = sumIn - sumCommission;
        if (trade != null && trade != 0) {
            if (sumOut < trade) {
                return new SumResult(0, 0, sumIn);
            }
            return new SumResult(sumOut, sumCommission, sumOut - trade);
        }
        return new SumResult(sumOut, sumCommission, 0);
    }

    public int calculateIncome(int sumOut, CommissionInfo commission, CommissionInfo minCommission, CommissionInfo maxCommission, Integer trade, short processingPaymentSourceId) {
        int serviceResult;
        int dealerResult = this.calculateIncome(sumOut, commission, trade, processingPaymentSourceId);
        if (maxCommission != null && (serviceResult = this.calculateIncome(sumOut, maxCommission, trade, processingPaymentSourceId)) < dealerResult) {
            dealerResult = serviceResult;
        }
        if (minCommission != null && (serviceResult = this.calculateIncome(sumOut, minCommission, trade, processingPaymentSourceId)) > dealerResult) {
            dealerResult = serviceResult;
        }
        return dealerResult;
    }

    private int calculateIncome(int sumOut, CommissionInfo commission, Integer trade, short processingPaymentSourceId) {
        int in;
        int lastSuccessfulIncome = in = sumOut;
        int step = 1;
        SumResult res = this.calculate(in, commission, trade, processingPaymentSourceId);
        while (res.getOut() <= sumOut) {
            res = this.calculate(in += step, commission, trade, processingPaymentSourceId);
            if (res.getOut() > sumOut) continue;
            lastSuccessfulIncome = in;
        }
        return lastSuccessfulIncome;
    }
}

