/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.keeper.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedList;
import ru.softlogic.keeper.annotation.documentation.FieldDoc;
import ru.softlogic.keeper.annotation.documentation.TypeDoc;

@JsonSerialize(include=JsonSerialize.Inclusion.NON_DEFAULT)
@JsonPropertyOrder(value={"pageSize", "page", "total", "numberOfPages", "pages", "values"})
@TypeDoc(value="\u041f\u0435\u0439\u0434\u0436\u0435\u0440")
public class DTOPager<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="values")
    @FieldDoc(value="\u0421\u043f\u0438\u0441\u043e\u043a \u0434\u0430\u043d\u043d\u044b\u0445 \u0434\u043b\u044f \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u043e\u0439 \u0441\u0442\u0430\u0440\u043d\u0438\u0446\u044b")
    protected Collection<T> values;
    @JsonProperty(value="pageSize")
    @FieldDoc(value="\u0420\u0430\u0437\u043c\u0435\u0440 \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u044b")
    protected short pageSize;
    @JsonProperty(value="total")
    @FieldDoc(value="\u0412\u0441\u0435\u0433\u043e \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u043e\u0432, \u043d\u0430 \u0432\u0441\u0435\u0445 \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u0430\u0445")
    protected long total;
    @JsonProperty(value="page")
    @FieldDoc(value="\u0422\u0435\u043a\u0443\u0449\u0430\u044f \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u0430")
    protected int page;
    @JsonProperty(value="numberOfPages")
    @FieldDoc(value="\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u0441\u0442\u0440\u0430\u043d\u0438\u0446")
    protected int numberOfPages;
    @JsonIgnore
    @FieldDoc(value="\u0421\u043f\u0438\u0441\u043e\u043a \u043d\u043e\u043c\u0435\u0440\u043e\u0432 \u0441\u0442\u0440\u0430\u043d\u0438\u0446 \u0434\u043b\u044f \u0432\u044b\u0432\u043e\u0434\u0430")
    protected Collection<Integer> pages;

    public DTOPager() {
        this.pages = new LinkedList<Integer>();
    }

    public DTOPager(short pageSize, int page, long total, Collection<T> values) {
        this.pageSize = pageSize;
        this.page = page;
        this.total = total;
        this.pages = new LinkedList<Integer>();
        this.setValues(values);
    }

    public int getPage() {
        return this.page;
    }

    public short getPageSize() {
        return this.pageSize;
    }

    @JsonIgnore
    public Collection<Integer> getPages() {
        return this.pages;
    }

    public long getTotal() {
        return this.total;
    }

    public int getNumberOfPages() {
        return this.numberOfPages;
    }

    public Collection<T> getValues() {
        return this.values;
    }

    private void setValues(Collection<T> values) {
        this.values = values;
        this.numberOfPages = (int)(this.total / (long)this.pageSize + (long)(this.total % (long)this.pageSize > 0L ? 1 : 0));
        if (this.numberOfPages > 1) {
            int to;
            int from;
            if (this.numberOfPages <= 8) {
                from = 1;
                to = this.numberOfPages;
            } else {
                int currentPage = this.page;
                from = currentPage - 3;
                if (from <= 0) {
                    from = 1;
                }
                if ((to = from + 7) > this.numberOfPages) {
                    to = this.numberOfPages;
                    from = to - 7;
                }
            }
            if (from > 1) {
                this.pages.add(1);
            }
            if (from > 2) {
                this.pages.add(-1);
            }
            for (int i = from; i <= to; ++i) {
                this.pages.add(i);
            }
            if (to < this.numberOfPages - 1) {
                this.pages.add(-1);
            }
            if (to < this.numberOfPages) {
                this.pages.add(this.numberOfPages);
            }
        }
    }

    public String toString() {
        return "DTOPager [values=" + this.values + ", pageSize=" + this.pageSize + ", total=" + this.total + ", page=" + this.page + ", numberOfPages=" + this.numberOfPages + ", pages=" + this.pages + ']';
    }
}

