/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.input.model.field.text;

import com.fasterxml.jackson.annotation.JsonInclude;
import ru.softlogic.input.model.field.numeric.Range;
import ru.softlogic.input.model.field.text.Validator;

@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
public class NumericExternalValidator
implements Validator {
    private static final long serialVersionUID = 1L;
    private static Range range;

    public static void setRange(Range range) {
        NumericExternalValidator.range = range;
    }

    public static Range getRange() {
        return range;
    }

    @Override
    public boolean validate(String data) {
        if (data == null || data.isEmpty() || range == null) {
            return false;
        }
        try {
            float val = Float.parseFloat(data.replace(",", "."));
            if (val >= range.getBegin() && val <= range.getEnd()) {
                return true;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return false;
    }

    public String toString() {
        return "NumericPurchaseValidator{range=" + range + '}';
    }
}

