/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.input.model.field.selector.custom;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import ru.softlogic.input.model.field.selector.custom.CustomData;
import ru.softlogic.input.model.field.selector.custom.RedirectCustomData;
import ru.softlogic.input.model.field.selector.custom.SequenceCustomData;

class CustomDataSerializer
extends JsonSerializer<CustomData> {
    CustomDataSerializer() {
    }

    public void serialize(CustomData data, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        jsonGenerator.writeStartObject();
        if (data.isRedirect()) {
            jsonGenerator.writeStringField("@cls", "cd-redirect");
            RedirectCustomData rcd = (RedirectCustomData)data;
            jsonGenerator.writeNumberField("service", (int)rcd.getService().shortValue());
            if (rcd.getParams() != null) {
                jsonGenerator.writeObjectField("params", rcd.getParams());
            }
        } else if (data.isSequence()) {
            jsonGenerator.writeStringField("@cls", "cd-sequence");
            SequenceCustomData scd = (SequenceCustomData)data;
            jsonGenerator.writeObjectField("screenSequence", (Object)scd.getScreenSequence());
        }
        jsonGenerator.writeEndObject();
    }
}

