/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.input.model.field.barcode;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.input.model.field.barcode.BarcodeData;
import ru.softlogic.input.model.field.barcode.BarcodeException;
import ru.softlogic.input.model.field.barcode.BarcodeParser;
import ru.softlogic.input.model.field.barcode.RegexInit;
import ru.softlogic.input.model.field.barcode.RegexRule;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class RegexParser
implements BarcodeParser {
    public static final long serialVersionUID = 0L;
    private RegexInit init;

    @JsonCreator
    public RegexParser(@JsonProperty(value="init") RegexInit init) {
        if (init == null) {
            throw new IllegalArgumentException();
        }
        this.init = init;
    }

    @Override
    public BarcodeData parse(String data) throws BarcodeException {
        ArrayList<InputElement> result = new ArrayList<InputElement>();
        if (this.init.getRules() != null && data != null) {
            if (this.init.getValidateRule() != null && !data.matches(this.init.getValidateRule())) {
                throw new BarcodeException("Validation failed");
            }
            for (RegexRule rule : this.init.getRules()) {
                if (rule.getKey() == null || rule.getRegex() == null) {
                    throw new BarcodeException("Key or regex are empty");
                }
                try {
                    Pattern pattern = Pattern.compile(rule.getRegex());
                    Matcher matcher = pattern.matcher(data);
                    if (matcher.find()) {
                        String value;
                        String string = value = matcher.groupCount() >= 1 ? matcher.group(1) : matcher.group(0);
                        if (rule.getConvertFrom() != null && rule.getConvertTo() != null) {
                            Integer convertFrom = rule.getConvertFrom();
                            Integer convertTo = rule.getConvertTo();
                            value = Long.toString(Long.parseLong(value, convertFrom), convertTo);
                        }
                        InputElement ie = new InputElement(rule.getKey(), rule.getTitle(), value, value, rule.getFlags());
                        ie.setOriginalValue(value);
                        result.add(ie);
                        continue;
                    }
                    if (!rule.isBind()) continue;
                    throw new BarcodeException("Rule parsing error");
                }
                catch (NumberFormatException ex) {
                    throw new BarcodeException(ex);
                }
            }
        }
        BarcodeData bd = new BarcodeData();
        bd.setElements(result);
        return bd;
    }

    public RegexInit getInit() {
        return this.init;
    }

    public String toString() {
        return "RegexParser{init=" + this.init + '}';
    }
}

