/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.input.model.advanced.actions.validator;

import com.fasterxml.jackson.annotation.JsonInclude;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.input.model.advanced.actions.Action;
import ru.softlogic.input.model.advanced.actions.ActionContext;
import ru.softlogic.input.model.advanced.actions.ContextHelper;
import ru.softlogic.input.model.advanced.actions.ExecuteException;
import ru.softlogic.input.model.advanced.actions.validator.ComplexValidator;
import ru.softlogic.input.model.field.numeric.Range;
import ru.softlogic.input.model.field.text.NumericExternalValidator;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class PurchaseValidator
extends ComplexValidator {
    public static final long serialVersionUID = 0L;
    private static final String KEY_NAME = "max_purchase";
    private String id;
    private boolean minValidate;

    public void setSumElement(String id) {
        this.id = id;
    }

    public void setMinValidate(boolean minValidate) {
        this.minValidate = minValidate;
    }

    @Override
    public void execute(ActionContext context) throws ExecuteException {
        Action act;
        NumericExternalValidator validator;
        String sum = ContextHelper.getStringParam(this.id, context);
        Range range = NumericExternalValidator.getRange();
        String action = this.minValidate ? ((validator = new NumericExternalValidator()).validate(sum) ? "success" : "error") : (this.validate(sum, range) ? "success" : "error");
        Action action2 = act = this.actionMap == null ? null : this.actionMap.getActionByType(action);
        if (act != null) {
            ActionContext local = new ActionContext("PurchaseValidator", context, act.getSequence());
            local.put(KEY_NAME, new InputElement(KEY_NAME, KEY_NAME, range != null ? Float.toString(range.getEnd()) : "0.0"));
            local.execute();
        } else {
            context.execute();
            context.cancelScript();
        }
    }

    public boolean validate(String data, Range range) {
        if (data == null || data.isEmpty() || range == null) {
            return false;
        }
        try {
            float val = Float.parseFloat(data.replace(",", "."));
            if (val <= range.getEnd()) {
                return true;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return false;
    }
}

