/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.input.model.advanced.actions.simple;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.input.model.advanced.actions.ActionContext;
import ru.softlogic.input.model.advanced.actions.ContextHelper;
import ru.softlogic.input.model.advanced.actions.ExecuteException;
import ru.softlogic.input.model.advanced.actions.simple.BiArgumentsAction;
import ru.softlogic.input.model.advanced.expression.calculator.CalculateException;
import ru.softlogic.input.model.advanced.expression.calculator.ExpressionCalculator;
import ru.softlogic.input.model.utils.MathUtils;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Math
extends BiArgumentsAction {
    public static final long serialVersionUID = 0L;
    private String expression;

    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public String toString() {
        return "Math{arg1=" + this.arg1 + ", arg2=" + this.arg2 + ", operation=" + this.operation + ", resultKey=" + this.resultKey + ", expression=" + this.expression + '}';
    }

    @Override
    public void execute(ActionContext context) throws ExecuteException {
        String result;
        if (this.expression != null) {
            try {
                Object calcResult = ExpressionCalculator.calculate(this.expression, context.getData());
                if (calcResult instanceof Double) {
                    result = Math.format((Double)calcResult);
                }
                if (calcResult instanceof Integer) {
                    result = Math.format(((Integer)calcResult).intValue());
                }
                if (calcResult instanceof String) {
                    result = (String)calcResult;
                }
                throw new ExecuteException("Incorrect result type: " + calcResult.getClass().getName());
            }
            catch (CalculateException ex) {
                throw new ExecuteException(ex.getMessage(), ex);
            }
        } else {
            double val1 = ContextHelper.getFloatParam(this.arg1, context);
            double val2 = ContextHelper.getFloatParam(this.arg2, context);
            double value = 0.0;
            if ("+".equals(this.operation)) {
                value = val1 + val2;
            } else if ("-".equals(this.operation)) {
                value = val1 - val2;
            } else if ("/".equals(this.operation)) {
                if (MathUtils.equalsDouble(val2, 0.0)) {
                    throw new ExecuteException("Math. Devide by zero");
                }
                value = val1 / val2;
            } else if ("*".equals(this.operation)) {
                value = val1 * val2;
            }
            result = Math.format(value);
        }
        InputElement ie = new InputElement();
        ie.setKey(this.resultKey);
        ie.setKeyTitle(this.resultTitle);
        ie.setFlags(this.flags);
        ie.setOriginalValue(result);
        ie.setValue(result);
        ie.setValueTitle(result);
        ie = ContextHelper.inheritFlagReceivedFromServer(ie, this.arg1, context);
        ie = ContextHelper.inheritFlagReceivedFromServer(ie, this.arg2, context);
        context.put(this.resultKey, ie);
        context.execute();
    }

    public static String format(double sum) {
        DecimalFormat df = new DecimalFormat();
        df.setMaximumFractionDigits(2);
        df.setMinimumFractionDigits(0);
        DecimalFormatSymbols dfs = df.getDecimalFormatSymbols();
        dfs.setDecimalSeparator('.');
        df.setDecimalFormatSymbols(dfs);
        df.setGroupingUsed(false);
        return df.format(sum);
    }
}

