/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.input.model.advanced.actions.simple;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.input.model.advanced.actions.ActionContext;
import ru.softlogic.input.model.advanced.actions.ActionElement;
import ru.softlogic.input.model.advanced.actions.ExecuteException;
import ru.softlogic.input.model.advanced.configuration.RuntimeConfiguration;
import ru.softlogic.input.model.utils.FileUtil;

public class Encode
implements ActionElement {
    public static final long serialVersionUID = 0L;
    private String[] keys;
    private String map;

    public String[] getKeys() {
        return this.keys;
    }

    public String getMap() {
        return this.map;
    }

    public void setKey(String[] keys) {
        this.keys = keys;
    }

    public void setMap(String map) {
        this.map = map;
    }

    @Override
    public void execute(ActionContext context) throws ExecuteException {
        if (this.keys == null) {
            throw new ExecuteException("Field 'keys' not set");
        }
        if (this.map == null) {
            throw new ExecuteException("Field 'map' not set");
        }
        Properties properties = this.loadPropFile(this.map);
        for (String key : this.keys) {
            InputElement ie = this.handleInputEement(context, properties, key);
            if (ie == null) continue;
            context.put(ie.getKey(), ie);
        }
        context.execute();
    }

    private InputElement handleInputEement(ActionContext context, Properties encode, String key) throws ExecuteException {
        Object obj = context.get(key);
        if (obj == null) {
            return null;
        }
        if (!(obj instanceof InputElement)) {
            throw new ExecuteException("Can not convert " + key + " to InputElement");
        }
        InputElement ie = (InputElement)obj;
        if (ie.getValue() == null) {
            return ie;
        }
        StringBuilder sb = new StringBuilder();
        for (char c : ie.getValue().toCharArray()) {
            String character = String.valueOf(c);
            if (encode.containsKey(character)) {
                sb.append(encode.getProperty(character));
                continue;
            }
            sb.append(character);
        }
        ie.setValue(sb.toString());
        ie.setValueTitle(sb.toString());
        return ie;
    }

    private Properties loadPropFile(String mapFile) throws ExecuteException {
        File encodePath = RuntimeConfiguration.getInstance().getEncodePath();
        if (encodePath == null) {
            throw new ExecuteException(" RuntimeConfiguration.getInstance().getEncodePath() return NULL. You need set encoding path.");
        }
        Properties encode = new Properties();
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(new File(encodePath, mapFile + ".properties"));
            encode.load(fis);
        }
        catch (IOException ex) {
            try {
                throw new ExecuteException(ex);
            }
            catch (Throwable throwable) {
                FileUtil.close(fis);
                throw throwable;
            }
        }
        FileUtil.close(fis);
        return encode;
    }
}

