/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.input.model.advanced.actions.simple;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ru.softlogic.input.model.Data;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.input.model.StoreHelper;
import ru.softlogic.input.model.advanced.actions.ActionContext;
import ru.softlogic.input.model.advanced.actions.ActionElement;
import ru.softlogic.input.model.advanced.actions.ExecuteException;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class CommunalPrepare
implements ActionElement {
    public static final long serialVersionUID = 0L;
    private static final String DATA_COUNT = "\\$\\{data-count\\}";
    private static final String REAL_DATA_COUNT = "\\$\\{real-data-count\\}";
    private int startCounterIndex = 0;
    private String inputData;
    private String filter;
    private List<InputElement> elements;

    public List<InputElement> getElements() {
        return this.elements;
    }

    public String getFilter() {
        return this.filter;
    }

    public String getInputData() {
        return this.inputData;
    }

    public void setElements(List<InputElement> elements) {
        this.elements = elements;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public void setInputData(String inputData) {
        this.inputData = inputData;
    }

    public int getStartCounterIndex() {
        return this.startCounterIndex;
    }

    public void setStartCounterIndex(int startCounterIndex) {
        this.startCounterIndex = startCounterIndex;
    }

    @Override
    public void execute(ActionContext context) throws ExecuteException {
        if (this.elements == null) {
            throw new ExecuteException("Template not set");
        }
        if (this.inputData == null) {
            throw new ExecuteException("InputData not set");
        }
        Object data = context.getData().get(this.inputData);
        if (!(data instanceof List)) {
            throw new ExecuteException("" + data + " is not NestedData");
        }
        int dataCount = this.startCounterIndex;
        int realDataCount = this.startCounterIndex;
        List nd = (List)data;
        for (Data d : nd) {
            Map<String, InputElement> map = StoreHelper.convert(d.getElements());
            if (this.isFilterCorrect(map) && this.elements != null) {
                for (InputElement ie : this.elements) {
                    String value;
                    InputElement ieByKey;
                    String value2;
                    InputElement ieByKey2;
                    InputElement nie = new InputElement();
                    String strDataCount = String.valueOf(dataCount);
                    String strRealDataCount = String.valueOf(realDataCount);
                    if (ie.getKey() == null) {
                        ie.setKey("");
                    }
                    nie.setKey(ie.getKey().replaceAll(DATA_COUNT, strDataCount));
                    nie.setKey(nie.getKey().replaceAll(REAL_DATA_COUNT, strRealDataCount));
                    Set<String> keys = StoreHelper.parceTemplate(nie.getKey());
                    for (String key : keys) {
                        ieByKey2 = map.get(key);
                        if (ieByKey2 == null) continue;
                        value2 = this.getValueFromIe(map, ieByKey2);
                        nie.setKey(nie.getKey().replaceAll("\\$\\{" + key + "\\}", value2));
                    }
                    if (ie.getKeyTitle() == null) {
                        ie.setKeyTitle("");
                    }
                    nie.setKeyTitle(ie.getKeyTitle().replaceAll(DATA_COUNT, strDataCount));
                    nie.setKeyTitle(nie.getKeyTitle().replaceAll(REAL_DATA_COUNT, strRealDataCount));
                    keys = StoreHelper.parceTemplate(nie.getKeyTitle());
                    for (String key : keys) {
                        ieByKey2 = map.get(key);
                        if (ieByKey2 == null) continue;
                        value2 = this.getValueFromIe(map, ieByKey2);
                        nie.setKeyTitle(nie.getKeyTitle().replaceAll("\\$\\{" + key + "\\}", value2));
                    }
                    if (ie.getValue() == null) {
                        ie.setValue("");
                    }
                    nie.setValue(ie.getValue().replaceAll(DATA_COUNT, strDataCount));
                    nie.setValue(nie.getValue().replaceAll(REAL_DATA_COUNT, strRealDataCount));
                    keys = StoreHelper.parceTemplate(nie.getValue());
                    boolean replaced = false;
                    for (String key : keys) {
                        ieByKey = map.get(key);
                        if (ieByKey == null) continue;
                        replaced = true;
                        value = this.getValueFromIe(map, ieByKey);
                        nie.setValue(nie.getValue().replaceAll("\\$\\{" + key + "\\}", value));
                    }
                    if (!replaced) continue;
                    if (ie.getValueTitle() == null) {
                        ie.setValueTitle("");
                    }
                    nie.setValueTitle(ie.getValueTitle().replaceAll(DATA_COUNT, strDataCount));
                    nie.setValueTitle(nie.getValueTitle().replaceAll(REAL_DATA_COUNT, strRealDataCount));
                    keys = StoreHelper.parceTemplate(nie.getValueTitle());
                    for (String key : keys) {
                        ieByKey = map.get(key);
                        if (ieByKey == null) continue;
                        value = this.getValueFromIe(map, ieByKey);
                        nie.setValueTitle(nie.getValueTitle().replaceAll("\\$\\{" + key + "\\}", value));
                    }
                    if (ie.getOriginalValue() == null) {
                        ie.setOriginalValue("");
                    }
                    nie.setOriginalValue(ie.getOriginalValue().replaceAll(DATA_COUNT, Integer.toString(dataCount)));
                    nie.setOriginalValue(nie.getOriginalValue().replaceAll(REAL_DATA_COUNT, Integer.toString(realDataCount)));
                    keys = StoreHelper.parceTemplate(nie.getOriginalValue());
                    for (String key : keys) {
                        if (map.get(key) == null) continue;
                        InputElement sie = map.get(key);
                        value = sie.getOriginalValue() == null || sie.getOriginalValue().trim().isEmpty() ? "" + sie.getValue() : "" + sie.getOriginalValue();
                        nie.setOriginalValue(nie.getOriginalValue().replaceAll("\\$\\{" + key + "\\}", value));
                    }
                    context.put(nie.getKey(), nie);
                }
                ++realDataCount;
            }
            ++dataCount;
        }
        context.execute();
    }

    private String getValueFromIe(Map<String, InputElement> map, InputElement sie) {
        String valueTitle = sie.getValueTitle();
        return valueTitle == null || valueTitle.trim().isEmpty() ? sie.getValue() : valueTitle;
    }

    private boolean isFilterCorrect(Map<String, InputElement> map) {
        String[] split;
        String localFilter = this.filter;
        if (localFilter == null || localFilter.trim().isEmpty()) {
            return true;
        }
        for (String s : split = localFilter.split("\\;")) {
            String[] split1 = s.split("=|(!=)");
            if (map.get(split1[0]) == null) {
                return false;
            }
            if (!(split1.length == 1 ? (s.contains("!=") ? map.get(split1[0]).getValue() == null || map.get(split1[0]).getValue().trim().isEmpty() : map.get(split1[0]).getValue() == null || !map.get(split1[0]).getValue().trim().isEmpty()) : split1.length == 2 && (s.contains("!=") ? split1[1].equals(map.get(split1[0]).getValue()) : !split1[1].equals(map.get(split1[0]).getValue())))) continue;
            return false;
        }
        return true;
    }
}

