/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.input.model;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.input.model.advanced.configuration.SoftwareType;

public class StoreHelper {
    private StoreHelper() {
    }

    public static List<InputElement> convert(Map<String, Object> data) {
        LinkedList<InputElement> result = new LinkedList<InputElement>();
        for (Map.Entry<String, Object> e : data.entrySet()) {
            if (e.getKey().startsWith("#") || e.getValue() == null || !(e.getValue() instanceof InputElement)) continue;
            result.add((InputElement)e.getValue());
        }
        return result;
    }

    public static Map<String, String> convertDep(Map<String, Object> data) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry<String, Object> e : data.entrySet()) {
            if (e.getKey().startsWith("#") || e.getValue() == null || !(e.getValue() instanceof InputElement)) continue;
            result.put(e.getKey(), ((InputElement)e.getValue()).getValue());
        }
        return result;
    }

    public static Map<String, InputElement> convertD(Map<String, Object> data) {
        HashMap<String, InputElement> result = new HashMap<String, InputElement>();
        for (Map.Entry<String, Object> e : data.entrySet()) {
            if (e.getKey().startsWith("#") || e.getValue() == null || !(e.getValue() instanceof InputElement)) continue;
            result.put(e.getKey(), (InputElement)e.getValue());
        }
        return result;
    }

    public static Map<String, InputElement> clear(Map<String, Object> data) {
        LinkedHashMap<String, InputElement> result = new LinkedHashMap<String, InputElement>();
        if (data == null || data.isEmpty()) {
            return result;
        }
        for (Map.Entry<String, Object> e : data.entrySet()) {
            String key = e.getKey();
            if (key == null || key.startsWith("#") || !(e.getValue() instanceof InputElement)) continue;
            result.put(key, (InputElement)e.getValue());
        }
        return result;
    }

    public static void mergeData(Map<String, Object> data, List<InputElement> elements) {
        if (data != null && elements != null) {
            for (InputElement el : elements) {
                data.put(el.getKey(), el);
            }
        }
    }

    public static void mergeVerifyResult(Map<String, Object> data, Map<String, Object> result) {
        if (data != null && result != null) {
            for (Map.Entry<String, Object> entry : result.entrySet()) {
                if (data.get(entry.getKey()) instanceof InputElement && entry.getValue() instanceof InputElement) {
                    InputElement newValue = (InputElement)entry.getValue();
                    InputElement oldValue = (InputElement)data.get(entry.getKey());
                    newValue.setKeyTitle(oldValue.getKeyTitle());
                }
                data.put(entry.getKey(), entry.getValue());
            }
        }
    }

    public static Map<String, InputElement> convert(List<InputElement> elements) {
        if (elements == null) {
            return null;
        }
        HashMap<String, InputElement> data = new HashMap<String, InputElement>();
        for (InputElement ie : elements) {
            data.put(ie.getKey(), ie);
        }
        return data;
    }

    public static Map<String, Object> convertObj(List<InputElement> elements) {
        if (elements == null) {
            return null;
        }
        HashMap<String, Object> data = new HashMap<String, Object>();
        for (InputElement ie : elements) {
            data.put(ie.getKey(), ie);
        }
        return data;
    }

    public static List<InputElement> convertNoClear(Map<String, InputElement> data) {
        LinkedList<InputElement> result = new LinkedList<InputElement>();
        for (Map.Entry<String, InputElement> e : data.entrySet()) {
            result.add(e.getValue());
        }
        return result;
    }

    public static Set<String> parceTemplate(String template) {
        if (template == null) {
            template = "";
        }
        HashSet<String> set = new HashSet<String>();
        Matcher m = Pattern.compile("\\$\\{((\\w|#|-|\\.)+)\\}").matcher(template);
        while (m.find()) {
            set.add(m.group(1));
        }
        return set;
    }

    public static Map<SoftwareType, String> processHelpTemplate(String template, Map<String, Object> data) {
        if (template == null || data == null) {
            return null;
        }
        Set<String> keys = StoreHelper.parceTemplate(template);
        for (String key : keys) {
            Object obj = data.get(key);
            String value = null;
            if (obj instanceof InputElement) {
                InputElement ie = (InputElement)obj;
                value = ie.getValueTitle() == null ? ie.getValue() : ie.getValueTitle();
            } else if (obj instanceof String) {
                value = (String)obj;
            }
            if (value == null) continue;
            template = template.replaceAll("\\$\\{" + key + "\\}", value);
        }
        ConcurrentHashMap<SoftwareType, String> map = new ConcurrentHashMap<SoftwareType, String>();
        map.put(SoftwareType.Any, template);
        return map;
    }

    public static Map<String, Object> clearMulti(Map<String, Object> data) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, Object> e : data.entrySet()) {
            if (e.getKey().startsWith("#") || "selected".equals(e.getKey()) || "summ".equals(e.getKey()) || "allow-change-state".equals(e.getKey()) || "editable".equals(e.getKey())) continue;
            result.put(e.getKey(), e.getValue());
        }
        return result;
    }

    public static InputElement getElement(String key, Map<String, Object> data) {
        InputElement ie = new InputElement(key, "", "", "", 0);
        if (data.get(key) != null && data.get(key) instanceof InputElement) {
            ie = (InputElement)data.get(key);
        }
        return ie;
    }

    public static InputElement getElement2(String key, Map<String, InputElement> data) {
        InputElement ie = data.get(key);
        if (ie == null) {
            ie = new InputElement(key, "", "", "", 0);
        }
        return ie;
    }

    public static String getMainValue(Map<String, Object> data) {
        Map<String, InputElement> cl = StoreHelper.clear(data);
        if (cl.isEmpty()) {
            return "undef";
        }
        InputElement ie = cl.get("id1");
        if (ie == null) {
            ie = cl.get("id2");
        }
        if (ie == null) {
            ie = cl.values().iterator().next();
        }
        return ie.getValueTitle();
    }
}

