/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.storage.io;

import java.io.Serializable;
import ru.softlogic.storage.io.Serializator;

public class ObjectIO<T extends Serializable> {
    private Serializator serilizator;
    private T data;
    private boolean readed;

    public ObjectIO(Serializator serilizator) {
        if (serilizator == null) {
            throw new NullPointerException("Serilizator must be set");
        }
        this.serilizator = serilizator;
    }

    public synchronized T read() {
        if (this.readed || this.data != null) {
            return this.data;
        }
        this.readed = true;
        try {
            this.data = (Serializable)this.serilizator.readObject();
        }
        catch (ClassCastException ex) {
            this.data = null;
        }
        return this.data;
    }

    public synchronized T read(boolean reset) {
        T res = this.read();
        if (reset) {
            this.write(null);
        }
        return res;
    }

    public synchronized T read(T def) {
        T res = this.read();
        return res != null ? res : def;
    }

    public synchronized T read(T def, boolean reset) {
        T res = this.read();
        if (reset) {
            this.write(null);
        }
        return res != null ? res : def;
    }

    public synchronized void write(T t) {
        this.data = t;
        this.serilizator.writeObject((Serializable)t);
    }
}

