/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.storage.io;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import ru.softlogic.storage.io.BaseSerializator;
import ru.softlogic.storage.io.FileSet;
import ru.softlogic.storage.io.PathLockException;
import ru.softlogic.storage.io.WrongPathException;

abstract class BaseSerializatorImpl
extends BaseSerializator {
    private final File mainFile;
    private final File backupFile;

    public BaseSerializatorImpl(FileSet fileSet) throws WrongPathException, PathLockException {
        super(fileSet);
        this.mainFile = new File(fileSet.getDir(), fileSet.getMainFile());
        this.backupFile = new File(fileSet.getDir(), fileSet.getBackupFile());
    }

    @Override
    protected final Object readObjectImpl() {
        Object res = BaseSerializatorImpl.readObjectByStream(this.mainFile);
        if (res == null) {
            res = BaseSerializatorImpl.readObjectByStream(this.backupFile);
        }
        return res;
    }

    @Override
    protected final void writeObjectImpl(Serializable t) {
        this.writeObject(t, this.mainFile);
        this.writeObject(t, this.backupFile);
    }

    protected abstract void writeObject(Serializable var1, File var2);

    @Override
    protected void closeImpl() throws IOException {
    }
}

