/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.storage.cash;

import java.util.Map;
import java.util.TreeMap;
import ru.softlogic.storage.cash.Box;
import ru.softlogic.storage.cash.BoxId;
import ru.softlogic.storage.cash.BoxNotFoundException;
import ru.softlogic.storage.cash.Store;

public final class StoreManager {
    public static final short DEFAULT_NUM = 0;
    private static final Map<Short, Map<Short, Store>> stores = new TreeMap<Short, Map<Short, Store>>();

    private StoreManager() {
    }

    public static void registerStore(short deviceClass, Store store) {
        StoreManager.registerStore(deviceClass, (short)0, store);
    }

    public static synchronized void registerStore(short deviceClass, short deviceNo, Store store) {
        if (store == null) {
            throw new NullPointerException("Store is null");
        }
        if (deviceNo < 0 || deviceNo > 4) {
            throw new IllegalArgumentException("Supported only 5 devices of the same type");
        }
        Map<Short, Store> ns = stores.get(deviceClass);
        if (ns == null) {
            ns = new TreeMap<Short, Store>();
            stores.put(deviceClass, ns);
        }
        ns.put(deviceNo, store);
    }

    public static synchronized Store getDefaultStore(short deviceClass) {
        Map<Short, Store> ns = stores.get(deviceClass);
        return ns != null ? ns.get((short)0) : null;
    }

    public static synchronized Box getBox(BoxId boxId) throws BoxNotFoundException {
        Map<Short, Store> sts = stores.get(boxId.getDeviceClass());
        if (sts == null || sts.isEmpty()) {
            throw new BoxNotFoundException("Cash store is not found for device class " + boxId.getDeviceClass());
        }
        Store st = sts.get(boxId.getDeviceNumber());
        if (st == null) {
            throw new BoxNotFoundException("Cash store is not found for device number " + boxId.getDeviceNumber());
        }
        if (st.getBoxes().length <= boxId.getBoxNumber()) {
            throw new BoxNotFoundException("Cash store is not found for box number " + boxId.getBoxNumber());
        }
        return st.getBoxes()[boxId.getBoxNumber()];
    }

    public static synchronized Map<Short, Store> getDefaultStores() {
        TreeMap<Short, Store> result = new TreeMap<Short, Store>();
        for (Map.Entry<Short, Map<Short, Store>> entry : stores.entrySet()) {
            if (entry.getValue() == null || entry.getValue().get((short)0) == null) continue;
            result.put(entry.getKey(), entry.getValue().get((short)0));
        }
        return result;
    }

    public static synchronized boolean isEmpty() {
        return stores.isEmpty();
    }
}

