/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.payout;

import java.util.List;
import java.util.Map;
import ru.softlogic.hardware.currency.Sum;
import ru.softlogic.hardware.currency.set.DenominationSet;
import ru.softlogic.hdw.DeviceId;
import ru.softlogic.storage.cash.BoxId;

public class PayoutResult {
    private final Sum requested;
    private final Sum confirmed;
    private final Map<BoxId, DenominationSet> payout;
    private final Map<DeviceId, DispenseResult> results;
    private final DenominationSet totals;

    public PayoutResult(Sum requested, Sum confirmed, Map<BoxId, DenominationSet> payout, Map<DeviceId, DispenseResult> results) {
        if (requested == null) {
            throw new NullPointerException("Requested is null");
        }
        if (confirmed == null) {
            throw new NullPointerException("Confirmed is null");
        }
        if (payout == null) {
            throw new NullPointerException("Payout is null");
        }
        if (results == null) {
            throw new NullPointerException("Results is null");
        }
        this.requested = requested;
        this.confirmed = confirmed;
        this.payout = payout;
        this.results = results;
        this.totals = new DenominationSet();
        for (DenominationSet ds : payout.values()) {
            this.totals.add(ds);
        }
    }

    public boolean hasAmbiguity() {
        for (DispenseResult dr : this.results.values()) {
            if (dr.getState() != ResultType.Ambiguity) continue;
            return true;
        }
        return false;
    }

    public Sum getRequestedSum() {
        return this.requested;
    }

    public Sum getConfirmedSum() {
        return this.confirmed;
    }

    public Sum getDispencedSum() {
        return this.totals.getTotal(this.requested.getCurrency());
    }

    public boolean isTotalPayout() {
        List<Sum> res = this.totals.getTotals();
        return res.size() == 1 && this.confirmed.equals(res.get(0));
    }

    public Map<BoxId, DenominationSet> getPayout() {
        return this.payout;
    }

    public Map<DeviceId, DispenseResult> getResults() {
        return this.results;
    }

    public DenominationSet getTotals() {
        return this.totals;
    }

    public String toString() {
        return "PayoutResult{requested=" + this.requested + ", payout=" + this.payout + ", results=" + this.results + ", totals=" + this.totals + '}';
    }

    public static enum ResultType {
        Success,
        Error,
        Ambiguity;

    }

    public static class DispenseResult {
        private final ResultType state;
        private final Map<BoxId, DenominationSet> dispenced;

        public DispenseResult(ResultType state, Map<BoxId, DenominationSet> dispenced) {
            if (state == null) {
                throw new NullPointerException("ResultType is null");
            }
            this.state = state;
            this.dispenced = dispenced;
        }

        public ResultType getState() {
            return this.state;
        }

        public Map<BoxId, DenominationSet> getDispenced() {
            return this.dispenced;
        }

        public String toString() {
            return "Result{state=" + (Object)((Object)this.state) + ", dispenced=" + this.dispenced + '}';
        }
    }
}

