/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.payout;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.log4j.Logger;
import ru.softlogic.hardware.currency.Denomination;
import ru.softlogic.hardware.currency.Sum;
import ru.softlogic.hardware.currency.SumFormatter;
import ru.softlogic.hardware.currency.set.DenominationSet;
import ru.softlogic.hdw.dev.cashdisp.CashDispenser;
import ru.softlogic.hdw.dev.cashdisp.PayoutBySetOperation;
import ru.softlogic.hdw.dev.cashdisp.PayoutException;
import ru.softlogic.hdw.handling.DeviceInfo;
import ru.softlogic.payout.CascadeOperation;
import ru.softlogic.payout.CascadePayoutTask;
import ru.softlogic.payout.DevicePriorityComparator;
import ru.softlogic.payout.Payout;
import ru.softlogic.payout.PayoutAdapter;
import ru.softlogic.payout.PayoutListener;
import ru.softlogic.payout.PayoutRequest;
import ru.softlogic.payout.alg.BasePayoutCalculator;
import ru.softlogic.payout.alg.PayoutCalculatorFactory;
import ru.softlogic.payout.alg.Restriction;
import ru.softlogic.storage.cash.Box;
import ru.softlogic.storage.cash.Store;

public final class PayoutFacade {
    private static final Logger log = Logger.getLogger(PayoutFacade.class);
    private static final Map<Integer, List<CashDispenser>> DEVICES = new TreeMap<Integer, List<CashDispenser>>();

    private PayoutFacade() {
    }

    public static void registerDevice(CashDispenser device, int priority) {
        if (device == null) {
            throw new IllegalArgumentException("Device is null");
        }
        log.info((Object)("Register payout device: " + device.getDeviceId() + ", priority: " + priority));
        List<CashDispenser> list = DEVICES.get(priority);
        if (list == null) {
            list = new ArrayList<CashDispenser>();
            DEVICES.put(priority, list);
        }
        list.add(device);
    }

    public static void unregisterDevice(CashDispenser device) {
        for (List<CashDispenser> list : DEVICES.values()) {
            if (!list.remove(device)) continue;
            return;
        }
    }

    public static Payout precalc(PayoutRequest request) {
        LinkedHashMap<CashDispenser, DenominationSet> result = new LinkedHashMap<CashDispenser, DenominationSet>();
        String currency = request.getSum().getCurrency();
        Sum sum = new Sum(request.getSum().getValue(), currency);
        BasePayoutCalculator payoutCalculator = PayoutCalculatorFactory.create(request.getAlgoritm());
        for (CashDispenser device : PayoutFacade.getSortedAvailableDevices(DEVICES, request)) {
            DenominationSet resultSet = payoutCalculator.calculate(PayoutFacade.getAvailableDenomination(device, currency), new Restriction(device.getDescriptor().getBoxDispenseCount()), sum.getValue());
            if (!resultSet.isEmpty()) {
                result.put(device, resultSet);
                sum = sum.sub(resultSet.getTotal(currency));
            }
            if (!sum.isEmpty()) continue;
            break;
        }
        return new PayoutImpl(request.getSum(), result);
    }

    private static Iterable<CashDispenser> getSortedAvailableDevices(Map<Integer, List<CashDispenser>> devices, PayoutRequest request) {
        ArrayList<CashDispenser> resultList = new ArrayList<CashDispenser>();
        for (List<CashDispenser> list : devices.values()) {
            for (CashDispenser dev : list) {
                if (!PayoutFacade.isAvalableDevice(dev, request.getAvailableDevices())) continue;
                resultList.add(dev);
            }
        }
        Map<Short, Integer> priorityTable = request.getPriorityTable();
        if (priorityTable == null || priorityTable.isEmpty()) {
            return resultList;
        }
        Collections.sort(resultList, new DevicePriorityComparator(priorityTable));
        return resultList;
    }

    private static Map<Denomination, Integer> getAvailableDenomination(CashDispenser device, String currency) {
        HashMap<Denomination, Integer> available = new HashMap<Denomination, Integer>();
        Store store = device.getStore();
        int max = device.getDescriptor().getBoxDispenseCount();
        for (Box box : store.getBoxes()) {
            if (box.getPhysicalBox() == null || !box.getPhysicalBox().isOpearable()) continue;
            for (Map.Entry<Denomination, Integer> entry : box.getCounts().entrySet()) {
                Denomination den = entry.getKey();
                Integer count = entry.getValue();
                if (!currency.equals(den.getCurrency())) continue;
                int acceptable = Math.min(count, max);
                Integer cnt = (Integer)available.get(den);
                available.put(den, acceptable + (cnt == null ? 0 : cnt));
            }
        }
        return available;
    }

    public static DenominationSet allAvailableDenominations() {
        DenominationSet available = new DenominationSet();
        for (List<CashDispenser> list : DEVICES.values()) {
            for (CashDispenser device : list) {
                if (!device.isOperable()) continue;
                Store store = device.getStore();
                for (Box box : store.getBoxes()) {
                    if (box.getBoxInfo().getType() != 3 || box.getPhysicalBox() == null || !box.getPhysicalBox().isOpearable()) continue;
                    available.add(box.getCounts());
                }
            }
        }
        return available;
    }

    private static boolean isAvalableDevice(CashDispenser device, List<Short> availableDevices) {
        if (availableDevices != null) {
            DeviceInfo lastInfo = device.getLastInfo();
            boolean contains = lastInfo == null ? false : availableDevices.contains(lastInfo.getDeviceClass());
            return contains && device.isOperable();
        }
        return device.isOperable();
    }

    private static class PayoutImpl
    implements Payout {
        private volatile boolean alreadyUse = false;
        private final Map<CashDispenser, DenominationSet> distributionMap;
        private final DenominationSet denominationSet;
        private final Sum requestedSum;

        public PayoutImpl(Sum requestedSum, Map<CashDispenser, DenominationSet> distributionMap) {
            this.requestedSum = requestedSum;
            this.distributionMap = distributionMap;
            this.denominationSet = PayoutImpl.calcTotalDenominationSet(distributionMap);
        }

        private static DenominationSet calcTotalDenominationSet(Map<CashDispenser, DenominationSet> distributionMap) {
            DenominationSet totalSet = new DenominationSet();
            for (DenominationSet set : distributionMap.values()) {
                totalSet.add(set);
            }
            return totalSet;
        }

        @Override
        public DenominationSet getCounts() {
            return this.denominationSet;
        }

        @Override
        public Sum getRequestedSum() {
            return this.requestedSum;
        }

        @Override
        public Sum getDifference() {
            return this.requestedSum.sub(this.getPossibleSum());
        }

        @Override
        public Sum getPossibleSum() {
            return this.getCounts().getTotal(this.requestedSum.getCurrency());
        }

        @Override
        public void makePayout(PayoutListener listener) throws PayoutException {
            if (this.alreadyUse) {
                throw new IllegalStateException("Method was used");
            }
            this.alreadyUse = true;
            if (this.distributionMap.size() == 1) {
                log.info((Object)"Make simple payout");
                Map.Entry<CashDispenser, DenominationSet> entry = this.distributionMap.entrySet().iterator().next();
                CashDispenser disp = entry.getKey();
                log.info((Object)"Call hdw payout");
                disp.payout(new PayoutBySetOperation(entry.getValue(), new PayoutAdapter(this.requestedSum, this.getPossibleSum(), listener, disp.getDeviceId())));
                log.info((Object)"Done");
            } else {
                log.info((Object)"Make complex payout");
                LinkedList<CascadePayoutTask> tasks = new LinkedList<CascadePayoutTask>();
                for (Map.Entry<CashDispenser, DenominationSet> entry : this.distributionMap.entrySet()) {
                    log.info((Object)("    Process " + entry.getKey().getDeviceId() + "->" + entry.getValue()));
                    if (!entry.getValue().isEmpty()) {
                        log.info((Object)"        Add");
                        tasks.add(new CascadePayoutTask(entry.getKey(), entry.getValue()));
                        continue;
                    }
                    log.info((Object)"        Skip");
                }
                CascadeOperation co = new CascadeOperation(this.requestedSum, this.getPossibleSum(), tasks, listener);
                co.start();
            }
        }

        public String toString() {
            return "PayoutImpl{, distributionMap=" + this.distributionMap + ", denominationSet=" + this.denominationSet + ", requestedSum=" + SumFormatter.asStr(this.requestedSum) + '}';
        }
    }
}

