/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hdw.dev.webcam;

import org.apache.log4j.Logger;
import ru.softlogic.hdw.BaseFactory;
import ru.softlogic.hdw.CreatingException;
import ru.softlogic.hdw.dev.webcam.Descriptor;
import ru.softlogic.hdw.dev.webcam.WcmOptions;
import ru.softlogic.hdw.dev.webcam.WebcamDriver;
import ru.softlogic.io.serial.SerialPort;

public class WebcamFactory
extends BaseFactory {
    private WebcamFactory() {
    }

    public static WebcamDriver createDriver(String type, SerialPort port, WcmOptions options, Logger log) throws CreatingException {
        WebcamFactory.checkType(type);
        WebcamFactory.checkLogger(log);
        String pkg = "ru.softlogic.hardware.wcm." + type.toLowerCase() + ".driver.Driver";
        try {
            Class<?> cl = Class.forName(pkg);
            WebcamDriver cr = (WebcamDriver)cl.getConstructor(String.class, SerialPort.class, WcmOptions.class, Logger.class).newInstance(type, port, options, log);
            return cr;
        }
        catch (ClassNotFoundException ex) {
            throw new CreatingException(ex);
        }
        catch (Throwable ex) {
            throw new CreatingException(ex);
        }
    }

    public static Descriptor createDescriptor(String type) throws CreatingException {
        return new Descriptor(WebcamFactory.getFeaturesQuetly("wcm", type));
    }
}

