/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hdw.dev.sensors;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import ru.softlogic.hdw.DeviceId;
import ru.softlogic.hdw.base.BaseDevice;
import ru.softlogic.hdw.dev.sensors.Sensor;
import ru.softlogic.io.Port;

public abstract class SensorDriver
extends BaseDevice
implements Runnable {
    private final ArrayList<Sensor> sensors;
    private final List<Thread> threads;
    private final Port port;
    private final DeviceId deviceId;
    protected Logger log;

    public SensorDriver(DeviceId deviceId, Port port, String baseDrvVersion, Logger log) {
        super(deviceId, baseDrvVersion, log);
        this.port = port;
        this.deviceId = deviceId;
        this.log = log;
        this.sensors = new ArrayList();
        this.threads = new ArrayList<Thread>(1);
        this.threads.add(new Thread((Runnable)this, "drv(" + deviceId.getType() + ")"));
    }

    @Override
    public ArrayList<Sensor> getSensors() {
        return this.sensors;
    }

    public List<Thread> getThreads() {
        return this.threads;
    }

    protected void registrationSensor(Sensor sensor) {
        if (sensor == null) {
            throw new IllegalArgumentException("Sensor is not set");
        }
        this.sensors.add(sensor);
    }

    protected boolean unregistrationSensor(Sensor sensor) {
        if (sensor == null) {
            throw new IllegalArgumentException("Sensor is not set");
        }
        return this.sensors.remove(sensor);
    }

    @Override
    public void run() {
        this.log.info((Object)"Start sensor device driver");
        if (this.port != null) {
            this.log.info((Object)("Port: " + this.port.asStr()));
        }
        this.log.info((Object)("Driver: " + this.deviceId.getType() + ", number: " + this.deviceId.getType()));
        try {
            this._run();
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
        if (this.port != null) {
            this.port.close();
        }
        this.log.info((Object)"Stop thread");
    }

    protected abstract void _run() throws InterruptedException;
}

