/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hdw.dev.printer.pos.pblock;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import ru.softlogic.hdw.dev.printer.pos.pblock.BarcodePrintBlock;
import ru.softlogic.hdw.dev.printer.pos.pblock.ImagePrintBlock;
import ru.softlogic.hdw.dev.printer.pos.pblock.PrintBlock;
import ru.softlogic.hdw.dev.printer.pos.pblock.TextPrintBlock;

public class TemplateParser {
    public static List<PrintBlock> parce(String template, Logger log) {
        LinkedList<PrintBlock> result = new LinkedList<PrintBlock>();
        try {
            if ("<empty/>".equals(template.trim())) {
                return result;
            }
            String[] res = template.split("(<img[^>]+\\/>)|(<barcode[^>]+\\/>)");
            if (res.length > 0) {
                result.add(new TextPrintBlock(res[0]));
            }
            int i = 0;
            Matcher m = Pattern.compile("(<img[^>]+\\/>)|(<barcode[^>]+\\/>)").matcher(template);
            while (m.find()) {
                Matcher mvalue;
                if (m.group(1) != null) {
                    String src;
                    String img = m.group(1);
                    Matcher mscr = Pattern.compile("src=\"([^\"]+)\"").matcher(img);
                    if (mscr.find() && !(src = mscr.group(1)).isEmpty()) {
                        Matcher msize = Pattern.compile("size=\"([^\"]+)\"").matcher(img);
                        int size = 0;
                        if (msize.find()) {
                            String sizeStr = msize.group(1);
                            if ("double".equalsIgnoreCase(sizeStr)) {
                                size = 3;
                            } else if ("double-width".equalsIgnoreCase(sizeStr)) {
                                size = 1;
                            } else if ("double-height".equalsIgnoreCase(sizeStr)) {
                                size = 2;
                            }
                        }
                        result.add(new ImagePrintBlock(src, size, log));
                    }
                    if (i >= res.length - 1) continue;
                    result.add(new TextPrintBlock(res[++i]));
                    continue;
                }
                String barcode = m.group(2);
                Matcher msize = Pattern.compile("size=\"([^\"]+)\"").matcher(barcode);
                int size = 0;
                if (msize.find()) {
                    String sizeStr = msize.group(1);
                    if ("double".equalsIgnoreCase(sizeStr)) {
                        size = 3;
                    } else if ("double-width".equalsIgnoreCase(sizeStr)) {
                        size = 1;
                    } else if ("double-height".equalsIgnoreCase(sizeStr)) {
                        size = 2;
                    }
                }
                if ((mvalue = Pattern.compile("value=\"([^\"]+)\"").matcher(barcode)).find()) {
                    String value = mvalue.group(1);
                    Matcher mtype = Pattern.compile("type=\"([^\"]+)\"").matcher(barcode);
                    if (mtype.find()) {
                        String typesrc = mtype.group(1);
                        String type = null;
                        if ("pdf417".equalsIgnoreCase(typesrc)) {
                            type = "pdf417";
                        } else if ("dm".equalsIgnoreCase(typesrc)) {
                            type = "dm";
                        } else if ("qrcode".equalsIgnoreCase(typesrc)) {
                            type = "qrcode";
                        }
                        if (type != null) {
                            result.add(new BarcodePrintBlock(type, value, size, TemplateParser.getParams(barcode), log));
                        }
                    }
                }
                if (i >= res.length - 1) continue;
                result.add(new TextPrintBlock(res[++i]));
            }
        }
        catch (Throwable ex) {
            result.add(new TextPrintBlock(template));
        }
        return result;
    }

    private static Map<String, String> getParams(String barcode) {
        HashMap<String, String> res = new HashMap<String, String>();
        Matcher mparams = Pattern.compile("params=\"([^\"]+)\"").matcher(barcode);
        if (mparams.find()) {
            String params = mparams.group(1);
            for (String p : params.split(",")) {
                String[] vals = p.split("=");
                if (vals.length != 2) continue;
                res.put(vals[0], vals[1]);
            }
        }
        return res;
    }
}

