/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hdw.dev.printer.pos.img;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import ru.softlogic.hdw.dev.printer.pos.WrongImageException;
import ru.softlogic.hdw.dev.printer.pos.img.Options;
import ru.softlogic.hdw.dev.printer.pos.img.PrnImage;

class ImageConverter {
    private ImageConverter() {
    }

    public static PrnImage readImage1b2a8dot(File path, Options options) throws WrongImageException, IOException {
        BufferedImage bi = ImageConverter.readImage(path);
        PrnImage pi = new PrnImage();
        pi.setWidth(bi.getWidth() + (bi.getWidth() % 8 == 0 ? 0 : 8 - bi.getWidth() % 8));
        pi.setHeight(bi.getHeight() + (bi.getHeight() % 8 == 0 ? 0 : 8 - bi.getHeight() % 8));
        System.out.println("WxH=" + pi.getWidth() + "x" + pi.getHeight());
        byte[] data = new byte[pi.getWidth() * pi.getHeight() / 8];
        for (int i = 0; i < pi.getWidth(); ++i) {
            for (int j = 0; j < pi.getHeight(); ++j) {
                int avgColor = ImageConverter.getGray(i, j, bi);
                if (avgColor >= 150) continue;
                int n = pi.getWidth() * (j / 8) + i;
                data[n] = (byte)(data[n] | 128 >> j % 8);
            }
        }
        pi.setData(data);
        return pi;
    }

    public static PrnImage readImage1b2a24dot(File path, Options options) throws WrongImageException, IOException {
        BufferedImage bi = ImageConverter.readImage(path);
        PrnImage pi = new PrnImage();
        pi.setWidth(bi.getWidth() + (bi.getWidth() % 8 == 0 ? 0 : 8 - bi.getWidth() % 8));
        pi.setHeight(bi.getHeight() + (bi.getHeight() % 24 == 0 ? 0 : 24 - bi.getHeight() % 24));
        System.out.println("WxH=" + pi.getWidth() + "x" + pi.getHeight());
        byte[] data = new byte[pi.getWidth() * pi.getHeight() / 8];
        for (int i = 0; i < pi.getWidth(); ++i) {
            for (int j = 0; j < pi.getHeight(); ++j) {
                int avgColor = ImageConverter.getGray(i, j, bi);
                if (avgColor >= 150) continue;
                int n = j % 24 / 8 + i * 3 + 3 * pi.getWidth() * (j / 24);
                data[n] = (byte)(data[n] | 128 >> j % 8);
            }
        }
        pi.setData(data);
        return pi;
    }

    public static PrnImage convertImage(File path, Options options) throws WrongImageException, IOException {
        BufferedImage bi = ImageConverter.readImage(path);
        PrnImage pi = new PrnImage();
        pi.setWidth(bi.getWidth() + (bi.getWidth() % 8 == 0 ? 0 : 8 - bi.getWidth() % 8));
        pi.setHeight(bi.getHeight() + (bi.getHeight() % 8 == 0 ? 0 : 8 - bi.getHeight() % 8));
        byte[] data = new byte[pi.getWidth() * pi.getHeight() / 8];
        for (int i = 0; i < pi.getWidth(); ++i) {
            for (int j = 0; j < pi.getHeight(); ++j) {
                int avgColor = ImageConverter.getGray(i, j, bi);
                if (avgColor >= 150) continue;
                int n = pi.getHeight() * i / 8 + j / 8;
                data[n] = (byte)(data[n] | 128 >> j % 8);
            }
        }
        pi.setData(data);
        return pi;
    }

    public static PrnImage convertImageH(File path, Options options) throws WrongImageException, IOException {
        BufferedImage bi = ImageConverter.readImage(path);
        PrnImage pi = new PrnImage();
        pi.setWidth(bi.getWidth() + (bi.getWidth() % 8 == 0 ? 0 : 8 - bi.getWidth() % 8));
        pi.setHeight(bi.getHeight() + (bi.getHeight() % 8 == 0 ? 0 : 8 - bi.getHeight() % 8));
        byte[] data = new byte[pi.getWidth() * pi.getHeight() / 8];
        try {
            for (int i = 0; i < pi.getHeight(); ++i) {
                for (int j = 0; j < pi.getWidth(); ++j) {
                    int avgColor = ImageConverter.getGray(j, i, bi);
                    if (avgColor >= 150) continue;
                    int n = pi.getWidth() * i / 8 + j / 8;
                    data[n] = (byte)(data[n] | 128 >> j % 8);
                }
            }
        }
        catch (Exception ex) {
            return null;
        }
        pi.setData(data);
        return pi;
    }

    private static int getGray(int i, int j, BufferedImage bi) {
        if (i >= bi.getWidth() || j >= bi.getHeight()) {
            return 0xFFFFFF;
        }
        int color = bi.getRGB(i, j) & 0xFFFFFF;
        return (int)((double)((color & 0xFF0000) >> 16) * 0.3 + (double)((color & 0xFF00) >> 8) * 0.59 + (double)(color & 0xFF) * 0.11);
    }

    private static BufferedImage readImage(File path) throws IOException, WrongImageException {
        if (!path.canRead()) {
            throw new IOException("File is not exist: " + path.getAbsolutePath());
        }
        BufferedImage bi = ImageIO.read(path);
        if (bi.getWidth() > 600) {
            throw new WrongImageException("Width must be in range 1..600px");
        }
        if (bi.getHeight() > 400) {
            throw new WrongImageException("Height must be in range 1..400px");
        }
        return bi;
    }
}

