/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hdw.dev.printer.pos.img;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.Binarizer;
import com.google.zxing.BinaryBitmap;
import com.google.zxing.DecodeHintType;
import com.google.zxing.LuminanceSource;
import com.google.zxing.MultiFormatReader;
import com.google.zxing.NotFoundException;
import com.google.zxing.Reader;
import com.google.zxing.Result;
import com.google.zxing.client.j2se.BufferedImageLuminanceSource;
import com.google.zxing.client.j2se.ImageReader;
import com.google.zxing.common.HybridBinarizer;
import com.google.zxing.multi.GenericMultipleBarcodeReader;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import ru.softlogic.hdw.dev.printer.pos.img.BarcodeException;

public class BarcodeParser {
    public static List<String> parseBarcode(File image, List<Integer> crop, boolean multi) throws BarcodeException {
        try {
            return BarcodeParser.parseBarcode(ImageReader.readImage((URI)image.toURI()), crop, multi);
        }
        catch (IOException ex) {
            throw new BarcodeException(ex);
        }
    }

    public static List<String> parseBarcode(BufferedImage image, List<Integer> crop, boolean multi) throws BarcodeException {
        Result[] results;
        Map<DecodeHintType, ?> hints = BarcodeParser.buildHints(false, false);
        BufferedImageLuminanceSource source = crop == null ? new BufferedImageLuminanceSource(image) : new BufferedImageLuminanceSource(image, crop.get(0).intValue(), crop.get(1).intValue(), crop.get(2).intValue(), crop.get(3).intValue());
        BinaryBitmap bitmap = new BinaryBitmap((Binarizer)new HybridBinarizer((LuminanceSource)source));
        MultiFormatReader multiFormatReader = new MultiFormatReader();
        try {
            if (multi) {
                GenericMultipleBarcodeReader reader = new GenericMultipleBarcodeReader((Reader)multiFormatReader);
                results = reader.decodeMultiple(bitmap, hints);
            } else {
                results = new Result[]{multiFormatReader.decode(bitmap, hints)};
            }
        }
        catch (NotFoundException ignored) {
            throw new BarcodeException(ignored);
        }
        ArrayList<String> result = new ArrayList<String>(results.length);
        for (Result res : results) {
            result.add(res.getText());
        }
        return result;
    }

    private static Map<DecodeHintType, ?> buildHints(boolean tryHarder, boolean pureBarcode) {
        ArrayList<BarcodeFormat> finalPossibleFormats = null;
        if (finalPossibleFormats == null || finalPossibleFormats.isEmpty()) {
            finalPossibleFormats = new ArrayList<BarcodeFormat>();
            finalPossibleFormats.addAll(Arrays.asList(BarcodeFormat.UPC_A, BarcodeFormat.UPC_E, BarcodeFormat.EAN_13, BarcodeFormat.EAN_8, BarcodeFormat.RSS_14, BarcodeFormat.RSS_EXPANDED));
            finalPossibleFormats.addAll(Arrays.asList(BarcodeFormat.CODE_39, BarcodeFormat.CODE_93, BarcodeFormat.CODE_128, BarcodeFormat.ITF, BarcodeFormat.QR_CODE, BarcodeFormat.DATA_MATRIX, BarcodeFormat.AZTEC, BarcodeFormat.PDF_417, BarcodeFormat.CODABAR, BarcodeFormat.MAXICODE));
        }
        EnumMap<DecodeHintType, Serializable> hints = new EnumMap<DecodeHintType, Serializable>(DecodeHintType.class);
        hints.put(DecodeHintType.POSSIBLE_FORMATS, finalPossibleFormats);
        if (tryHarder) {
            hints.put(DecodeHintType.TRY_HARDER, Boolean.TRUE);
        }
        if (pureBarcode) {
            hints.put(DecodeHintType.PURE_BARCODE, Boolean.TRUE);
        }
        return Collections.unmodifiableMap(hints);
    }
}

