/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hdw.dev.printer.pos.img;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.datamatrix.DataMatrixWriter;
import com.google.zxing.pdf417.PDF417Writer;
import com.google.zxing.pdf417.encoder.Dimensions;
import com.google.zxing.qrcode.QRCodeWriter;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import org.apache.log4j.Logger;
import ru.softlogic.hdw.dev.printer.pos.img.BarcodeException;

public class BarcodeGenerator {
    private static final Logger log = Logger.getLogger(BarcodeGenerator.class);

    private BarcodeGenerator() {
    }

    public static void generateQRCode(File path, String value, Map<String, String> params) throws BarcodeException {
        log.info((Object)("Generate QR, value: " + value + ", path: " + path.getAbsolutePath()));
        try {
            HashMap<EncodeHintType, Object> hintMap = new HashMap<EncodeHintType, Object>();
            hintMap.put(EncodeHintType.ERROR_CORRECTION, ErrorCorrectionLevel.L);
            hintMap.put(EncodeHintType.MARGIN, BarcodeGenerator.getParam(params, "margin", 0, 0, 25));
            int size = BarcodeGenerator.getParam(params, "size", 256, 100, 500);
            QRCodeWriter qrCodeWriter = new QRCodeWriter();
            BitMatrix biteMatrix = qrCodeWriter.encode(value, BarcodeFormat.QR_CODE, size, size, hintMap);
            MatrixToImageWriter.writeToPath((BitMatrix)biteMatrix, (String)"png", (Path)path.toPath());
        }
        catch (Throwable ex) {
            throw new BarcodeException("Error on generate barcode on path: " + path.getAbsolutePath(), ex);
        }
    }

    public static File generateQRCode(String value, Map<String, String> params) throws BarcodeException {
        try {
            Path path = Files.createTempFile("slbarcode", ".png", new FileAttribute[0]);
            log.info((Object)("Generate QR, value: " + value + ", path: " + path));
            HashMap<EncodeHintType, Object> hintMap = new HashMap<EncodeHintType, Object>();
            hintMap.put(EncodeHintType.ERROR_CORRECTION, ErrorCorrectionLevel.L);
            hintMap.put(EncodeHintType.MARGIN, BarcodeGenerator.getParam(params, "margin", 0, 0, 25));
            int size = BarcodeGenerator.getParam(params, "size", 256, 100, 500);
            QRCodeWriter qrCodeWriter = new QRCodeWriter();
            BitMatrix biteMatrix = qrCodeWriter.encode(value, BarcodeFormat.QR_CODE, size, size, hintMap);
            MatrixToImageWriter.writeToPath((BitMatrix)biteMatrix, (String)"png", (Path)path);
            return path.toFile();
        }
        catch (Throwable ex) {
            throw new BarcodeException("Error on generate barcode", ex);
        }
    }

    public static void generatePDF417(File path, String value, Map<String, String> params) throws BarcodeException {
        log.info((Object)("Generate PDF417, value: " + value + ", path: " + path.getAbsolutePath()));
        try {
            PDF417Writer dF417Writer = new PDF417Writer();
            HashMap<EncodeHintType, Integer> hintMap = new HashMap<EncodeHintType, Integer>();
            hintMap.put(EncodeHintType.MARGIN, BarcodeGenerator.getParam(params, "margin", 0, 0, 25));
            int minCols = BarcodeGenerator.getParam(params, "min-cols", 1, 1, 100);
            int maxCols = BarcodeGenerator.getParam(params, "max-cols", 100, minCols, 100);
            int minRows = BarcodeGenerator.getParam(params, "min-rows", 25, 1, 100);
            int maxRows = BarcodeGenerator.getParam(params, "max-rows", 100, minRows, 100);
            hintMap.put(EncodeHintType.PDF417_DIMENSIONS, (Integer)new Dimensions(minCols, maxCols, minRows, maxRows));
            BitMatrix biteMatrix = dF417Writer.encode(value, BarcodeFormat.PDF_417, 2, 1, hintMap);
            MatrixToImageWriter.writeToPath((BitMatrix)biteMatrix, (String)"png", (Path)path.toPath());
        }
        catch (Throwable ex) {
            throw new BarcodeException("Error on generate barcode on path: " + path.getAbsolutePath(), ex);
        }
    }

    public static File generatePDF417(String value, Map<String, String> params) throws BarcodeException {
        try {
            Path path = Files.createTempFile("slbarcode", ".png", new FileAttribute[0]);
            log.info((Object)("Generate QR, value: " + value + ", path: " + path));
            PDF417Writer dF417Writer = new PDF417Writer();
            HashMap<EncodeHintType, Integer> hintMap = new HashMap<EncodeHintType, Integer>();
            hintMap.put(EncodeHintType.MARGIN, BarcodeGenerator.getParam(params, "margin", 0, 0, 25));
            int minCols = BarcodeGenerator.getParam(params, "min-cols", 1, 1, 100);
            int maxCols = BarcodeGenerator.getParam(params, "max-cols", 100, minCols, 100);
            int minRows = BarcodeGenerator.getParam(params, "min-rows", 25, 1, 100);
            int maxRows = BarcodeGenerator.getParam(params, "max-rows", 100, minRows, 100);
            hintMap.put(EncodeHintType.PDF417_DIMENSIONS, (Integer)new Dimensions(minCols, maxCols, minRows, maxRows));
            BitMatrix biteMatrix = dF417Writer.encode(value, BarcodeFormat.PDF_417, 2, 1, hintMap);
            MatrixToImageWriter.writeToPath((BitMatrix)biteMatrix, (String)"png", (Path)path);
            return path.toFile();
        }
        catch (Throwable ex) {
            throw new BarcodeException("Error on generate barcode", ex);
        }
    }

    public static void generateDataMatrix(File path, String value, Map<String, String> params) throws BarcodeException {
        log.info((Object)("Generate DataMatrix, value: " + value + ", path: " + path.getAbsolutePath()));
        try {
            DataMatrixWriter writer = new DataMatrixWriter();
            int size = BarcodeGenerator.getParam(params, "size", 256, 100, 500);
            BitMatrix biteMatrix = writer.encode(value, BarcodeFormat.DATA_MATRIX, size, size);
            BufferedImage bi = BarcodeGenerator.getScaled(MatrixToImageWriter.toBufferedImage((BitMatrix)biteMatrix), size);
            ImageIO.write((RenderedImage)bi, "png", path);
        }
        catch (Throwable ex) {
            throw new BarcodeException("Error on generate barcode on path: " + path.getAbsolutePath(), ex);
        }
    }

    public static File generateDataMatrix(String value, Map<String, String> params) throws BarcodeException {
        try {
            Path path = Files.createTempFile("slbarcode", ".png", new FileAttribute[0]);
            log.info((Object)("Generate DataMatrix, value: " + value + ", path: " + path));
            DataMatrixWriter writer = new DataMatrixWriter();
            int size = BarcodeGenerator.getParam(params, "size", 256, 100, 500);
            BitMatrix biteMatrix = writer.encode(value, BarcodeFormat.DATA_MATRIX, size, size);
            BufferedImage bi = BarcodeGenerator.getScaled(MatrixToImageWriter.toBufferedImage((BitMatrix)biteMatrix), size);
            ImageIO.write((RenderedImage)bi, "png", path.toFile());
            return path.toFile();
        }
        catch (Throwable ex) {
            throw new BarcodeException("Error on generate barcode", ex);
        }
    }

    private static BufferedImage getScaled(BufferedImage bi, int max) {
        if (bi.getWidth() > max / 2) {
            return bi;
        }
        int scale = max / bi.getWidth();
        Image scaled = bi.getScaledInstance(bi.getWidth() * scale, bi.getHeight() * scale, 1);
        BufferedImage res = new BufferedImage(scaled.getWidth(null), scaled.getHeight(null), 2);
        Graphics g = res.getGraphics();
        g.drawImage(scaled, 0, 0, null);
        g.dispose();
        return res;
    }

    private static int getParam(Map<String, String> params, String name, int def, int min, int max) {
        String val = params.get(name);
        if (val == null || !val.matches("\\d+")) {
            return def;
        }
        int res = Integer.parseInt(val);
        if (res < min) {
            return min;
        }
        if (res > max) {
            return max;
        }
        return res;
    }
}

