/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hdw.dev.printer;

import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ru.softlogic.config.BaseSection;
import ru.softlogic.config.ParceException;
import ru.softlogic.hdw.dev.printer.PrtConfiguration;
import ru.softlogic.hdw.dev.printer.ipp.IppPrtConfiguration;
import ru.softlogic.hdw.dev.printer.ipp.IppPrtOptions;
import ru.softlogic.hdw.dev.printer.kkm.KkmPrtConfiguration;
import ru.softlogic.hdw.dev.printer.kkm.KkmPrtOptions;
import ru.softlogic.hdw.dev.printer.pos.PosPrinterUtils;
import ru.softlogic.hdw.dev.printer.pos.PosPrtConfiguration;
import ru.softlogic.hdw.dev.printer.pos.PosPrtOptions;
import ru.softlogic.io.Port;
import ru.softlogic.io.PortScanner;
import ru.softlogic.io.PortType;
import ru.softlogic.io.parallel.ParallelPort;
import ru.softlogic.io.serial.DataBits;
import ru.softlogic.io.serial.Parity;
import ru.softlogic.io.serial.SerialParams;
import ru.softlogic.io.serial.SerialPort;
import ru.softlogic.io.serial.StopBits;
import ru.softlogic.io.usb.UsbPort;

public class PrtSection
extends BaseSection {
    private static final String DEV_CLASS = "class";
    private static final String CLASS_IPP = "ipp";
    private static final String CLASS_POS = "pos";
    private static final String CLASS_KKM = "kkm";
    private static final String IPP_NAME = "name";
    private static final String IPP_ATTR_FONT_SIZE = "font-size";
    private static final String IPP_ATTR_FONT_NAME = "font-name";
    private static final String IPP_ATTR_SCROLL = "scroll";
    private static final String POS_TYPE = "type";
    private static final String POS_LEFT_MARGIN = "left-margin";
    private static final String POS_WIDTH = "width";
    private static final String POS_SCROLL = "scroll";
    private static final String POS_FONT = "font";
    private static final String POS_CUSTOM_FONT = "use-custom-font";
    private static final String POS_SPACING = "spacing";
    private static final String POS_EJECT = "eject";
    private static final String POS_ENCODE = "encode";
    private static final String POS_USE_PNE_SENSOR = "use-pne-sensor";
    private static final String KKM_TYPE = "type";
    private static final String KKM_PRN_MODE = "prn-mode";
    private static final String KKM_WIDTH = "width";
    private static final String KKM_SCROLL = "scroll";
    private static final String KKM_PWD1 = "password1";
    private static final String KKM_PWD2 = "password2";
    private static final String KKM_PRESENTER = "presenter";
    private PrtConfiguration conf;

    public PrtSection() {
    }

    public PrtSection(PrtConfiguration conf) {
        if (conf == null) {
            throw new NullPointerException("PrtConfiguration is null");
        }
        this.conf = conf;
    }

    @Override
    public String getGroup() {
        return "hardware";
    }

    @Override
    public String getKey() {
        return "printer";
    }

    @Override
    public void parce(Element element) throws ParceException {
        String prtClass = element.getAttribute(DEV_CLASS);
        if (CLASS_IPP.equals(prtClass)) {
            this.parceIpp(element);
        } else if (CLASS_POS.equals(prtClass)) {
            this.parcePos(element);
        } else if (CLASS_KKM.equals(prtClass)) {
            this.parceKkm(element);
        } else {
            throw new ParceException("Wrong printer class: " + prtClass);
        }
    }

    @Override
    public Node generate(Document doc) {
        String prtClass = this.conf.getPrtClass();
        if (CLASS_IPP.equals(prtClass)) {
            return this.generateIpp(doc);
        }
        if (CLASS_POS.equals(prtClass)) {
            return this.generatePos(doc);
        }
        if (CLASS_KKM.equals(prtClass)) {
            return this.generateKkm(doc);
        }
        return null;
    }

    private void parceIpp(Element element) {
        String name = element.getAttribute(IPP_NAME);
        Map<String, String> opts = this.readOptions(element);
        int fontSize = this.readInt(opts, IPP_ATTR_FONT_SIZE, 9);
        String fontName = this.readString(opts, IPP_ATTR_FONT_NAME, "");
        int scroll = this.readInt(opts, "scroll", 0);
        this.conf = new PrtConfiguration();
        this.conf.setPrtClass(CLASS_IPP);
        this.conf.setIppPrtConfiguration(new IppPrtConfiguration(name, new IppPrtOptions(fontSize, fontName, scroll)));
    }

    private void parceKkm(Element element) throws ParceException {
        String type = element.getAttribute("type");
        Map<String, String> opts = this.readOptions(element);
        boolean prnMode = this.readBoolean(opts, KKM_PRN_MODE, false);
        int width = this.readInt(opts, "width", 0);
        int scroll = this.readInt(opts, "scroll", 0);
        String pwd1 = opts.get(KKM_PWD1);
        String pwd2 = opts.get(KKM_PWD2);
        int presenter = this.readInt(opts, KKM_PRESENTER, 0);
        this.conf = new PrtConfiguration();
        this.conf.setPrtClass(CLASS_KKM);
        this.conf.setKkmPrtConfiguration(new KkmPrtConfiguration(type, this.getSerialPort(element), new KkmPrtOptions(prnMode, width, scroll, pwd1, pwd2, presenter)));
    }

    public PrtConfiguration getConfiguration() {
        return this.conf;
    }

    private Node generateIpp(Document doc) {
        Element root = doc.createElement(this.getKey());
        IppPrtConfiguration c = this.conf.getIppPrtConfiguration();
        root.setAttribute(DEV_CLASS, CLASS_IPP);
        root.setAttribute(IPP_NAME, c.getName());
        if (c.getOptions().getFontName() != null && !c.getOptions().getFontName().isEmpty()) {
            this.writeOption(doc, root, IPP_ATTR_FONT_NAME, c.getOptions().getFontName());
        }
        if (c.getOptions().getFontSize() != 9) {
            this.writeOption(doc, root, IPP_ATTR_FONT_SIZE, c.getOptions().getFontSize());
        }
        if (c.getOptions().getScroll() > 0) {
            this.writeOption(doc, root, "scroll", c.getOptions().getScroll());
        }
        return root;
    }

    private void parcePos(Element element) throws ParceException {
        String type = element.getAttribute("type");
        Map<String, String> opts = this.readOptions(element);
        int leftMargin = this.readInt(opts, POS_LEFT_MARGIN);
        int width = this.readInt(opts, "width");
        int scroll = this.readInt(opts, "scroll", 0);
        int font = this.readInt(opts, POS_FONT, 0);
        int spacing = this.readInt(opts, POS_SPACING, 0);
        int eject = this.readInt(opts, POS_EJECT, 0);
        String encode = this.readString(opts, POS_ENCODE, PosPrinterUtils.getDefaultEncoding());
        boolean usePne = this.readBoolean(opts, POS_USE_PNE_SENSOR, true);
        boolean useCustomFont = this.readBoolean(opts, POS_CUSTOM_FONT, false);
        this.conf = new PrtConfiguration();
        this.conf.setPrtClass(CLASS_POS);
        this.conf.setPosPrtConfiguration(new PosPrtConfiguration(type, this.getPort(element), new PosPrtOptions(leftMargin, width, scroll, font, spacing, eject, usePne, encode, useCustomFont)));
    }

    private Node generatePos(Document doc) {
        Element root = doc.createElement(this.getKey());
        PosPrtConfiguration c = this.conf.getPosPrtConfiguration();
        PosPrtOptions o = c.getOptions();
        root.setAttribute(DEV_CLASS, CLASS_POS);
        root.setAttribute("type", c.getType());
        root.setAttribute("port", this.formatPort(c.getPort()));
        this.writeOption(doc, root, POS_LEFT_MARGIN, Integer.toString(o.getLeftMargin()));
        this.writeOption(doc, root, "width", Integer.toString(o.getWidth()));
        if (o.getEncode() != null && !PosPrinterUtils.getDefaultEncoding().equals(o.getEncode())) {
            this.writeOption(doc, root, POS_ENCODE, o.getEncode());
        }
        if (o.getScroll() > 0) {
            this.writeOption(doc, root, "scroll", Integer.toString(o.getScroll()));
        }
        if (o.getFont() != 0) {
            this.writeOption(doc, root, POS_FONT, Integer.toString(o.getFont()));
        }
        if (o.getSpacing() != 0) {
            this.writeOption(doc, root, POS_SPACING, Integer.toString(o.getSpacing()));
        }
        if (o.getEject() > 0) {
            this.writeOption(doc, root, POS_EJECT, Integer.toString(o.getEject()));
        }
        if (!o.isUsePneSensor()) {
            this.writeOption(doc, root, POS_USE_PNE_SENSOR, Boolean.toString(o.isUsePneSensor()));
        }
        if (o.isUseCustomFont()) {
            this.writeOption(doc, root, POS_CUSTOM_FONT, Boolean.TRUE.toString());
        }
        return root;
    }

    private Node generateKkm(Document doc) {
        Element root = doc.createElement(this.getKey());
        KkmPrtConfiguration c = this.conf.getKkmPrtConfiguration();
        KkmPrtOptions o = c.getOptions();
        root.setAttribute(DEV_CLASS, CLASS_KKM);
        root.setAttribute("type", c.getType());
        root.setAttribute("port", this.formatPort((Port)c.getPort()));
        if (o.getWidth() > 0) {
            this.writeOption(doc, root, "width", Integer.toString(o.getWidth()));
        }
        if (o.getScroll() > 0) {
            this.writeOption(doc, root, "scroll", Integer.toString(o.getScroll()));
        }
        if (o.isPrinterMode()) {
            this.writeOption(doc, root, KKM_PRN_MODE, Boolean.toString(o.isPrinterMode()));
        }
        if (o.getPassword1() != null && !o.getPassword1().isEmpty()) {
            this.writeOption(doc, root, KKM_PWD1, o.getPassword1());
        }
        if (o.getPassword2() != null && !o.getPassword2().isEmpty()) {
            this.writeOption(doc, root, KKM_PWD1, o.getPassword2());
        }
        if (o.getPresenterMode() != 0) {
            this.writeOption(doc, root, KKM_PWD1, Integer.toString(o.getPresenterMode()));
        }
        return root;
    }

    protected Port getPort(Element element) throws ParceException {
        String port = element.getAttribute("port");
        if (port.isEmpty()) {
            return null;
        }
        if (port.toLowerCase().matches("[a-z0-9/]+:\\d+,\\d,(1|1\\.5|2),(none|odd|even|mark|space)")) {
            String[] paths = port.split(":");
            String[] pr = paths[1].split(",");
            if (PortScanner.suggestType((String)paths[0]) != PortType.SerialPort) {
                throw new ParceException("Wrong port type, needs serial " + paths[0]);
            }
            return new SerialPort(paths[0], new SerialParams(Integer.parseInt(pr[0]), DataBits.value((String)pr[1]), StopBits.value((String)pr[2]), Parity.valueOf((String)pr[3])));
        }
        PortType pt = PortScanner.suggestType((String)port);
        if (pt == PortType.ParallelPort) {
            return new ParallelPort(port);
        }
        return new UsbPort(port);
    }

    protected SerialPort getSerialPort(Element element) throws ParceException {
        String port = element.getAttribute("port");
        if (port.isEmpty()) {
            return null;
        }
        String[] paths = port.split(":");
        String[] pr = paths[1].split(",");
        if (PortScanner.suggestType((String)paths[0]) != PortType.SerialPort) {
            throw new ParceException("Wrong port type, needs serial " + paths[0]);
        }
        return new SerialPort(paths[0], new SerialParams(Integer.parseInt(pr[0]), DataBits.value((String)pr[1]), StopBits.value((String)pr[2]), Parity.valueOf((String)pr[3])));
    }

    protected String formatPort(Port port) {
        if (port != null) {
            if (port.getType() == PortType.SerialPort) {
                SerialPort p = (SerialPort)port;
                return p.getName() + ":" + p.getParams().getSpeed() + "," + p.getParams().getDataBits().getCode() + "," + p.getParams().getStopBits().getName() + "," + p.getParams().getParity();
            }
            return port.getName();
        }
        return "";
    }
}

