/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hdw.dev.printer;

import java.util.Properties;
import org.apache.log4j.Logger;
import ru.softlogic.hdw.BaseFactory;
import ru.softlogic.hdw.CreatingException;
import ru.softlogic.hdw.DeviceId;
import ru.softlogic.hdw.dev.printer.PrtConfiguration;
import ru.softlogic.hdw.dev.printer.ipp.IppPrintSpoolerDriver;
import ru.softlogic.hdw.dev.printer.ipp.IppPrtConfiguration;
import ru.softlogic.hdw.dev.printer.ipp.IppPrtOptions;
import ru.softlogic.hdw.dev.printer.kkm.KkmPrinter;
import ru.softlogic.hdw.dev.printer.kkm.KkmPrtConfiguration;
import ru.softlogic.hdw.dev.printer.kkm.KkmPrtOptions;
import ru.softlogic.hdw.dev.printer.pos.PosPrinter;
import ru.softlogic.hdw.dev.printer.pos.PosPrinterApi;
import ru.softlogic.hdw.dev.printer.pos.PosPrinterDescriptor;
import ru.softlogic.hdw.dev.printer.pos.PosPrtConfiguration;
import ru.softlogic.hdw.dev.printer.pos.PosPrtOptions;
import ru.softlogic.hdw.dev.printer.pos.fonts.FontDescriptor;
import ru.softlogic.hdw.dev.printer.spooler.DefaultPrintSpoolerDriver;
import ru.softlogic.hdw.dev.printer.spooler.PrintSpoolerDriver;
import ru.softlogic.io.Port;
import ru.softlogic.io.PortType;
import ru.softlogic.io.parallel.ParallelPort;
import ru.softlogic.io.serial.SerialPort;
import ru.softlogic.io.usb.UsbPort;

public final class PrinterFactory
extends BaseFactory {
    public static final String PRINTER_TYPE_IPP = "ipp";
    public static final String PRINTER_TYPE_POS = "pos";
    public static final String PRINTER_TYPE_KKM = "kkm";

    private PrinterFactory() {
    }

    public static PrintSpoolerDriver creatDriver(PrtConfiguration conf, Logger log) throws CreatingException {
        PrintSpoolerDriver psd = null;
        String prtClass = conf.getPrtClass();
        if (PRINTER_TYPE_IPP.equals(prtClass)) {
            IppPrtConfiguration ic = conf.getIppPrtConfiguration();
            psd = PrinterFactory.createIppDriver(ic.getName(), ic.getOptions(), log);
        } else if (PRINTER_TYPE_POS.equals(prtClass)) {
            PosPrtConfiguration pc = conf.getPosPrtConfiguration();
            psd = PrinterFactory.createPosDriver(pc.getType(), pc.getPort(), pc.getOptions(), log);
        } else if (PRINTER_TYPE_KKM.equals(prtClass)) {
            KkmPrtConfiguration pc = conf.getKkmPrtConfiguration();
            psd = PrinterFactory.createKkmDriver(pc.getType(), pc.getPort(), pc.getOptions(), log);
        } else {
            throw new CreatingException("Unknown printer type: " + conf.getPrtClass());
        }
        return psd;
    }

    public static PrintSpoolerDriver createPosDriver(String type, Port port, PosPrtOptions opt, Logger log) throws CreatingException {
        if (port.getType() == PortType.SerialPort) {
            return PrinterFactory.createSerialPosDriver(type, (SerialPort)port, opt, log);
        }
        if (port.getType() == PortType.UsbPort) {
            return PrinterFactory.createUsbPosDriver(type, (UsbPort)port, opt, log);
        }
        return PrinterFactory.createLptPosDriver(type, (ParallelPort)port, opt, log);
    }

    public static PrintSpoolerDriver createFailureDriver(Logger log) throws CreatingException {
        String pkg = "ru.softlogic.hardware.pos.stub.failure.Api";
        try {
            Class<?> cl = Class.forName(pkg);
            PosPrinterApi cr = (PosPrinterApi)cl.getConstructor(new Class[0]).newInstance(new Object[0]);
            PosPrtOptions opt = new PosPrtOptions(1, 80, 0, 0, 0, 0, false, "866", false);
            PosPrinter pp = new PosPrinter("failure-stub", cr, opt, log);
            return new DefaultPrintSpoolerDriver(pp, new DeviceId(0, "failure-stub", 0), log);
        }
        catch (ClassNotFoundException ex) {
            throw new CreatingException(ex);
        }
        catch (Throwable ex) {
            throw new CreatingException(ex);
        }
    }

    public static PrintSpoolerDriver createKkmDriver(String type, SerialPort port, KkmPrtOptions opt, Logger log) throws CreatingException {
        PrinterFactory.check(type, (Port)port, log);
        if (opt == null) {
            throw new NullPointerException("KkmPrtOptions is null");
        }
        String pkg = "ru.softlogic.hardware.kkm." + type.toLowerCase() + ".driver.Api";
        try {
            Class<?> cl = Class.forName(pkg);
            short dc = opt.isPrinterMode() ? (short)0 : 2;
            DeviceId deviceId = new DeviceId(dc, type, 0);
            KkmPrinter kp = (KkmPrinter)cl.getConstructor(SerialPort.class, KkmPrtOptions.class, DeviceId.class, Logger.class).newInstance(port, opt, deviceId, log);
            return new DefaultPrintSpoolerDriver(kp, deviceId, log);
        }
        catch (ClassNotFoundException ex) {
            throw new CreatingException(ex);
        }
        catch (Throwable ex) {
            throw new CreatingException(ex);
        }
    }

    public static PrintSpoolerDriver createSerialPosDriver(String type, SerialPort port, PosPrtOptions opt, Logger log) throws CreatingException {
        String pkg = "ru.softlogic.hardware.pos." + type.toLowerCase() + ".Api";
        try {
            Class<?> cl = Class.forName(pkg);
            PosPrinterApi cr = (PosPrinterApi)cl.getConstructor(SerialPort.class, PosPrtOptions.class, Logger.class).newInstance(port, opt, log);
            PosPrinter pp = new PosPrinter(type, cr, opt, log);
            return new DefaultPrintSpoolerDriver(pp, new DeviceId(0, type, 0), log);
        }
        catch (ClassNotFoundException ex) {
            throw new CreatingException(ex);
        }
        catch (Throwable ex) {
            throw new CreatingException(ex);
        }
    }

    public static PrintSpoolerDriver createUsbPosDriver(String type, UsbPort port, PosPrtOptions opt, Logger log) throws CreatingException {
        String pkg = "ru.softlogic.hardware.pos." + type.toLowerCase() + ".Api";
        try {
            Class<?> cl = Class.forName(pkg);
            PosPrinterApi cr = (PosPrinterApi)cl.getConstructor(UsbPort.class, PosPrtOptions.class, Logger.class).newInstance(port, opt, log);
            PosPrinter pp = new PosPrinter(type, cr, opt, log);
            return new DefaultPrintSpoolerDriver(pp, new DeviceId(0, type, 0), log);
        }
        catch (ClassNotFoundException ex) {
            throw new CreatingException(ex);
        }
        catch (Throwable ex) {
            throw new CreatingException(ex);
        }
    }

    public static PrintSpoolerDriver createLptPosDriver(String type, ParallelPort port, PosPrtOptions opt, Logger log) throws CreatingException {
        String pkg = "ru.softlogic.hardware.pos." + type.toLowerCase() + ".Api";
        try {
            Class<?> cl = Class.forName(pkg);
            PosPrinterApi cr = (PosPrinterApi)cl.getConstructor(ParallelPort.class, PosPrtOptions.class, Logger.class).newInstance(port, opt, log);
            PosPrinter pp = new PosPrinter(type, cr, opt, log);
            return new DefaultPrintSpoolerDriver(pp, new DeviceId(0, type, 0), log);
        }
        catch (ClassNotFoundException ex) {
            throw new CreatingException(ex);
        }
        catch (Throwable ex) {
            throw new CreatingException(ex);
        }
    }

    public static PrintSpoolerDriver createIppDriver(String name, IppPrtOptions opt, Logger log) throws CreatingException {
        return new IppPrintSpoolerDriver(name, opt, log);
    }

    public static PosPrinterDescriptor createPosDescriptor(String type) throws CreatingException {
        Properties prop = PrinterFactory.getParamProperties(PRINTER_TYPE_POS, type);
        int feat = PrinterFactory.getFeatures(prop);
        int defWidth = PrinterFactory.getIntParam(prop, "defwidth");
        int minWidth = PrinterFactory.getIntParam(prop, "minwidth");
        int maxWidth = PrinterFactory.getIntParam(prop, "maxwidth");
        int defLeftMargin = PrinterFactory.getIntParam(prop, "defleftmargin");
        int defScroll = PrinterFactory.getIntParam(prop, "defscroll");
        String propertyFontA = prop.getProperty("font.size.a");
        FontDescriptor fontA = FontDescriptor.parse(propertyFontA);
        String propertyFontB = prop.getProperty("font.size.b");
        FontDescriptor fontB = FontDescriptor.parse(propertyFontB);
        return new PosPrinterDescriptor(feat, minWidth, maxWidth, defWidth, defLeftMargin, defScroll, fontA, fontB);
    }
}

