/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hdw.dev.modem;

import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import ru.softlogic.io.utils.BU;

public class Sms {
    private static final String REC_UNREAD = "REC UNREAD";
    private static final String REC_READ = "REC READ";
    private static final String INDEX = "index";
    private static final String STATUS = "status";
    private static final String ADDRESS = "address";
    private static final String ADDRESS_TEXT = "address_text";
    private static final String SERVICE_DATE = "service_center_date";
    private static final String SERVICE_TIME = "service_center_time";
    private static final String ADDRESS_TYPE = "address_type";
    private static final String BODY_LEN = "body";
    private final Map params;
    private String text;
    private final String[] keys = new String[]{"index", "status", "address", "address_text", "service_center_date", "service_center_time", "address_type", "body"};

    public Sms(String info, String body) {
        String infoFields = info.replaceAll("\\+.*: |\"", "");
        LinkedList<String> fields = new LinkedList<String>(Arrays.asList(infoFields.split(",")));
        this.params = new HashMap();
        if (fields.size() < 3) {
            throw new IllegalArgumentException();
        }
        if (((String)fields.get(0)).startsWith("REC")) {
            fields.add(0, "0");
        }
        for (int j = 0; j < fields.size(); ++j) {
            String field = (String)fields.get(j);
            if (INDEX.equals(this.keys[j])) {
                this.params.put(this.keys[j], Integer.parseInt(field));
                continue;
            }
            if (STATUS.equals(this.keys[j])) {
                this.params.put(this.keys[j], REC_READ.equals(field));
                continue;
            }
            if (ADDRESS_TYPE.equals(this.keys[j]) || BODY_LEN.equals(this.keys[j])) {
                this.params.put(this.keys[j], Integer.parseInt(field));
                continue;
            }
            this.params.put(this.keys[j], field);
        }
        this.text = body;
    }

    public int getIndex() {
        Object obj = this.params.get(INDEX);
        if (obj != null) {
            return (Integer)obj;
        }
        return 0;
    }

    public boolean isRead() {
        Object obj = this.params.get(STATUS);
        if (obj != null) {
            return (Boolean)obj;
        }
        return false;
    }

    public String getAddress() {
        return (String)this.params.get(ADDRESS);
    }

    public String getAddressText() {
        return (String)this.params.get(ADDRESS_TEXT);
    }

    public String getServiceCenterTime() {
        return (String)this.params.get(SERVICE_DATE) + " " + (String)this.params.get(SERVICE_TIME);
    }

    public int getAddressType() {
        Object obj = this.params.get(ADDRESS_TYPE);
        if (obj != null) {
            return (Integer)obj;
        }
        return -1;
    }

    public int getBodyLength() {
        Object obj = this.params.get(BODY_LEN);
        if (obj != null) {
            return (Integer)obj;
        }
        return -1;
    }

    public String getText() {
        try {
            byte[] bytes = BU.convertFromHex((String)this.text.trim());
            return new String(bytes, "UTF-16BE");
        }
        catch (UnsupportedEncodingException ex) {
            return this.text;
        }
    }

    public String toString() {
        return "Sms{params=" + this.params + ",\n text=" + this.getText() + '}';
    }
}

