/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hdw.dev.modem;

import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import ru.softlogic.config.ParceException;
import ru.softlogic.config.SerialDeviceSection;
import ru.softlogic.hdw.dev.modem.ModConfiguration;
import ru.softlogic.hdw.dev.modem.ModOptions;
import ru.softlogic.io.serial.SerialPort;

public class ModSection
extends SerialDeviceSection {
    private static final String CHECK_BALANCE = "check-balance";
    private static final String USSD = "ussd";
    private ModConfiguration conf;

    public ModSection() {
    }

    public ModSection(ModConfiguration conf) {
        this.conf = conf;
    }

    @Override
    public String getKey() {
        return "modem";
    }

    @Override
    public void parce(Element element) throws ParceException {
        boolean enable = this.getEnable(element);
        String type = this.getDriver(element);
        SerialPort port = this.getSerialPort(element);
        Map<String, String> opt = this.readOptions(element);
        this.conf = new ModConfiguration(enable, type, port, new ModOptions(this.readBoolean(opt, CHECK_BALANCE, true), this.readString(opt, USSD, "")));
    }

    @Override
    public Element generate(Document doc) {
        return this.generate(doc, this.conf);
    }

    @Override
    protected void generateOptions(Document doc, Element root) {
        this.writeOption(doc, root, CHECK_BALANCE, Boolean.toString(this.conf.getOptions().isCheckBalance()));
        this.writeOption(doc, root, USSD, this.conf.getOptions().getUssd());
    }

    public ModConfiguration getConfiguration() {
        return this.conf;
    }
}

